/*
 * Decompiled with CFR 0.152.
 */
package com.trs.jni;

import com.trs.jni.JNIPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DeployJNI {
    static /* synthetic */ Class class$0;

    public static void deploy(String jniName) throws IOException {
        DeployJNI.deployDLL(jniName);
        DeployJNI.deployJar(jniName);
    }

    public static void deployDLL(String jniName) throws IOException {
        File destDll = new File(JNIPath.getDestDLLFile(jniName));
        DeployJNI.extractFile(JNIPath.getSrcDLLFile(jniName), destDll);
        if (JNIPath.getOSName().equals("hpux")) {
            DeployJNI.chmod(destDll, "+x");
        }
    }

    public static void deployJar(String jniName) throws IOException {
        File destJar = new File(JNIPath.getDestJarFile(jniName));
        DeployJNI.extractFile(JNIPath.getSrcJarFile(jniName), destJar);
    }

    private static void extractFile(String jniFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.jni.DeployJNI");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream dllIn = clazz.getResourceAsStream(jniFile);
            FileOutputStream dllOut = new FileOutputStream(destFile);
            byte[] b = new byte[1024];
            int bytes = 0;
            while ((bytes = dllIn.read(b, 0, 1024)) > 0) {
                dllOut.write(b, 0, bytes);
            }
            dllIn.close();
            dllOut.close();
        }
    }

    private static boolean chmod(File file, String attrib) {
        String sFile = file.getAbsolutePath();
        String cmd = "chmod " + attrib + " " + sFile;
        int exitValue = -1;
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmd);
            proc.waitFor();
            exitValue = proc.exitValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exitValue == 0;
    }

    public static void main(String[] args) {
        try {
            DeployJNI.deploy("trsbean");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

