/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLookupOp
extends AbstractSVGFilterConverter {
    private static final double GAMMA = 0.4166666666666667;
    private static final int[] linearToSRGBLut = new int[256];
    private static final int[] sRGBToLinear = new int[256];

    public SVGLookupOp(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        if (bufferedImageOp instanceof LookupOp) {
            return this.toSVG((LookupOp)bufferedImageOp);
        }
        return null;
    }

    public SVGFilterDescriptor toSVG(LookupOp lookupOp) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(lookupOp);
        Document document = this.generatorContext.domFactory;
        if (sVGFilterDescriptor == null) {
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "filter");
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "feComponentTransfer");
            String[] stringArray = SVGLookupOp.convertLookupTables(lookupOp);
            Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncR");
            Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncG");
            Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncB");
            Element element6 = null;
            String string = "table";
            if (stringArray.length == 1) {
                element3.setAttributeNS(null, "type", string);
                element4.setAttributeNS(null, "type", string);
                element5.setAttributeNS(null, "type", string);
                element3.setAttributeNS(null, "tableValues", stringArray[0]);
                element4.setAttributeNS(null, "tableValues", stringArray[0]);
                element5.setAttributeNS(null, "tableValues", stringArray[0]);
            } else if (stringArray.length >= 3) {
                element3.setAttributeNS(null, "type", string);
                element4.setAttributeNS(null, "type", string);
                element5.setAttributeNS(null, "type", string);
                element3.setAttributeNS(null, "tableValues", stringArray[0]);
                element4.setAttributeNS(null, "tableValues", stringArray[1]);
                element5.setAttributeNS(null, "tableValues", stringArray[2]);
                if (stringArray.length == 4) {
                    element6 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncA");
                    element6.setAttributeNS(null, "type", string);
                    element6.setAttributeNS(null, "tableValues", stringArray[3]);
                }
            }
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
            if (element6 != null) {
                element2.appendChild(element6);
            }
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("componentTransfer"));
            StringBuffer stringBuffer = new StringBuffer("url(");
            stringBuffer.append("#");
            stringBuffer.append(element.getAttributeNS(null, "id"));
            stringBuffer.append(")");
            sVGFilterDescriptor = new SVGFilterDescriptor(stringBuffer.toString(), element);
            this.defSet.add(element);
            this.descMap.put(lookupOp, sVGFilterDescriptor);
        }
        return sVGFilterDescriptor;
    }

    private static String[] convertLookupTables(LookupOp lookupOp) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        Object[] objectArray2;
        LookupTable lookupTable = lookupOp.getTable();
        int n6 = lookupTable.getNumComponents();
        if (n6 != 1 && n6 != 3 && n6 != 4) {
            throw new SVGGraphics2DRuntimeException("BufferedImage LookupOp should have 1, 3 or 4 lookup arrays");
        }
        StringBuffer[] stringBufferArray = new StringBuffer[n6];
        int n7 = 0;
        while (n7 < n6) {
            stringBufferArray[n7] = new StringBuffer();
            ++n7;
        }
        if (!(lookupTable instanceof ByteLookupTable)) {
            objectArray2 = new int[n6];
            objectArray = new int[n6];
            n5 = lookupTable.getOffset();
            n4 = 0;
            while (n4 < n5) {
                n3 = 0;
                while (n3 < n6) {
                    stringBufferArray[n3].append(SVGLookupOp.doubleString((double)n4 / 255.0, 1000));
                    stringBufferArray[n3].append(" ");
                    ++n3;
                }
                ++n4;
            }
            n3 = n5;
            while (n3 <= 255) {
                n2 = 0;
                while (n2 < n6) {
                    objectArray2[n2] = n3;
                    ++n2;
                }
                lookupTable.lookupPixel((int[])objectArray2, (int[])objectArray);
                n = 0;
                while (n < n6) {
                    stringBufferArray[n].append(SVGLookupOp.doubleString((double)objectArray[n] / 255.0, 1000));
                    stringBufferArray[n].append(" ");
                    ++n;
                }
                ++n3;
            }
        } else {
            objectArray2 = new byte[n6];
            objectArray = new byte[n6];
            n5 = lookupTable.getOffset();
            n4 = 0;
            while (n4 < n5) {
                n3 = 0;
                while (n3 < n6) {
                    stringBufferArray[n3].append(SVGLookupOp.doubleString((double)n4 / 255.0, 1000));
                    stringBufferArray[n3].append(" ");
                    ++n3;
                }
                ++n4;
            }
            n3 = 0;
            while (n3 <= 255) {
                n2 = 0;
                while (n2 < n6) {
                    objectArray2[n2] = (byte)(0xFF & n3);
                    ++n2;
                }
                ((ByteLookupTable)lookupTable).lookupPixel((byte[])objectArray2, (byte[])objectArray);
                n = 0;
                while (n < n6) {
                    stringBufferArray[n].append(SVGLookupOp.doubleString((double)(0xFF & objectArray[n]) / 255.0, 1000));
                    stringBufferArray[n].append(" ");
                    ++n;
                }
                ++n3;
            }
        }
        objectArray2 = new String[n6];
        int n8 = 0;
        while (n8 < n6) {
            objectArray2[n8] = (int)stringBufferArray[n8].toString().trim();
            ++n8;
        }
        return objectArray2;
    }

    public static String doubleString(double d, int n) {
        if ((double)((int)(d = (double)Math.round(d * (double)n) / (double)n)) == d) {
            return Integer.toString((int)d);
        }
        return Double.toString(d);
    }

    static {
        int n = 0;
        while (n < 256) {
            float f = (float)n / 255.0f;
            f = (double)f <= 0.0031308 ? (f *= 12.92f) : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
            SVGLookupOp.linearToSRGBLut[n] = Math.round(f * 255.0f);
            f = (float)n / 255.0f;
            f = (double)f <= 0.04045 ? (f /= 12.92f) : (float)Math.pow((f + 0.055f) / 1.055f, 2.4);
            SVGLookupOp.sRGBToLinear[n] = Math.round(f * 255.0f);
            ++n;
        }
    }
}

