/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.support.file.FilesMan;
import java.io.File;

public class SourcePathHelper {
    private static String s_sAppRootPath = null;
    private static final String FILENAME_MAPPING = "channel_mapping.xml";
    private static final String FILENAME_SITEINFO = "wcm_websites.xml";
    private static final String FILENAME_BASECHANNELINFO = "channels_of_site";
    private static final String FILENAME_FIELDINFO = "wcm_fields.xml";
    private static final String FILENAME_FIELDINFO_MOCK = "wcm_fields_mock.xml";
    private static final String FILENAME_FIELDMAPPING_MOCK = "field_mapping_mock.xml";
    private static final String FILENAME_TEMPLATEINFO = "wcm_templates.xml";
    private static final String DIRNAME_SETTINGS = "wcmsetting";

    public static String getTemplatePackageDir() {
        if (s_sAppRootPath == null) {
            String sClassName = SourcePathHelper.class.getName();
            int nPos = sClassName.lastIndexOf(46);
            s_sAppRootPath = ConfigConstants.getConfigRootPath() + sClassName.substring(0, nPos) + File.separator;
        }
        return s_sAppRootPath;
    }

    public static String getMappingFilePath() {
        return SourcePathHelper.getTemplatePackageDir() + FILENAME_MAPPING;
    }

    public static String getFieldMockMappingFilePath() {
        return SourcePathHelper.getTemplatePackageDir() + FILENAME_FIELDMAPPING_MOCK;
    }

    public static String getMockFieldInfoFilePath() {
        return SourcePathHelper.getTemplatePackageDir() + FILENAME_FIELDINFO_MOCK;
    }

    public static String getSiteInfoFilePath() {
        return SourcePathHelper.getTemplateTemporaryDir() + FILENAME_SITEINFO;
    }

    public static String getBaseChannelInfoFilePath(int _nSiteId) {
        return SourcePathHelper.getTemplateTemporaryDir() + FILENAME_BASECHANNELINFO + "_" + _nSiteId + ".xml";
    }

    public static String getFieldInfoFilePath() {
        return SourcePathHelper.getTemplateTemporaryDir() + FILENAME_FIELDINFO;
    }

    public static String getTemplateInfoFilePath() {
        return SourcePathHelper.getTemplateTemporaryDir() + FILENAME_TEMPLATEINFO;
    }

    private static String getTemplateTemporaryDir() {
        try {
            FilesMan oFilesMan = FilesMan.getFilesMan();
            return oFilesMan.mapFilePath(oFilesMan.getNextFilePathName("ST", "zip"), 0);
        }
        catch (WCMException ex) {
            throw new RuntimeException("Failed to get the system temporary file directory!");
        }
    }

    public static String getFormatedSettingFilesDir(String _sZipFilePath) {
        try {
            FilesMan oFilesMan = FilesMan.getFilesMan();
            return oFilesMan.mapFilePath(_sZipFilePath, 0) + DIRNAME_SETTINGS + File.separator;
        }
        catch (WCMException ex) {
            throw new RuntimeException("Failed to get the system temporary file directory!");
        }
    }
}

