/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.xml;

import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.definition.FlowRules;
import com.trs.cms.process.xml.FlowRuleXMLConvertor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import org.dom4j.Element;

public class FlowNodeXmlConverter
extends BaseObjToXmlConverter {
    private ObjToXmlConverter m_converter;
    private FlowNode m_currNode;
    private static User m_currUser = User.getSystem();

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        this.m_currNode = (FlowNode)_baseObj;
        this.m_converter = new ObjToXmlConverter();
        Element[] childEls = new Element[]{this.getUserElement(), this.getGroupElement(), this.getBranchElement(), this.getRuleElement(), this.getFieldsElement()};
        return childEls;
    }

    private Element getUserElement() throws WCMException {
        Users users = this.m_currNode.getOperUsers(m_currUser);
        return this.m_converter.toXmlElement(users, "UserId,UserName");
    }

    private Element getGroupElement() throws WCMException {
        Groups groups = this.m_currNode.getOperGroups(m_currUser);
        return this.m_converter.toXmlElement(groups, "GroupId");
    }

    private Element getBranchElement() throws WCMException {
        FlowNodeBranchs branchs = this.m_currNode.getBranchs(m_currUser);
        return this.m_converter.toXmlElement(branchs, null);
    }

    private Element getRuleElement() throws WCMException {
        FlowRules rules = FlowRules.findOf(User.getSystem(), this.m_currNode);
        FlowRuleXMLConvertor ruleConverter = new FlowRuleXMLConvertor();
        return ruleConverter.toXmlElement(rules, null);
    }

    private Element getFieldsElement() throws WCMException {
        FlowNodeFields fields = FlowNodeFields.findOf(User.getSystem(), this.m_currNode);
        return this.m_converter.toXmlElement(fields, null);
    }
}

