/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.config;

import com.trs.idm.common.IConfig;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SPPropertyConfig
implements IConfig {
    private static final Logger logger = Logger.getLogger(SPPropertyConfig.class);
    public static final String DBACCESSOR_CLASS = "IDBAccessor.class";
    public static final String DEFAULT_CONFIG_FILE_NAME = "/trsids-agent.properties";
    public static final String TEST_CONFIG_FILE_NAME_SIMPLE = "/trsids-sp-forUnitTestOnly_simple.properties";
    public static final String TEST_CONFIG_FILE_NAME_SAML = "/trsids-sp-forUnitTestOnly_saml.properties";
    public static final String SEVICE_THREAD_SLEEP_MS = "st.sleep.ms";
    private Properties configs;
    private String configFileName;

    public SPPropertyConfig(String configFileName) {
        logger.debug((Object)("configFileName: " + configFileName));
        if (StringHelper.isEmpty(configFileName)) {
            logger.warn((Object)"configFileName is null, init with default configFile: /trsids-agent.properties");
            this.configFileName = DEFAULT_CONFIG_FILE_NAME;
        }
        this.configFileName = configFileName;
        this.init(configFileName);
    }

    public void init(String configFileName) {
        this.initialize(configFileName);
    }

    @Override
    public String getConfig(String cfgKey) {
        if (StringHelper.isEmpty(cfgKey)) {
            return null;
        }
        return this.configs.getProperty(cfgKey);
    }

    @Override
    public String getConfig(String cfgKey, String defValue) {
        return PropertyUtil.getPropertyAsGBK(this.configs, cfgKey, defValue);
    }

    @Override
    public int getConfigAsInt(String cfgKey) {
        return PropertyUtil.getPropertyAsInt(this.configs, cfgKey, 0);
    }

    @Override
    public int getConfigAsInt(String cfgKey, int defValue) {
        return PropertyUtil.getPropertyAsInt(this.configs, cfgKey, defValue);
    }

    @Override
    public void setConfig(String cfgKey, String cfgValue) {
        if (cfgKey != null && cfgValue != null) {
            this.configs.setProperty(cfgKey, cfgValue);
        }
    }

    public String toString() {
        return this.configs.toString();
    }

    @Override
    public boolean isUsingLDAP() {
        return "LDAP".equals(this.getConfig("userStore"));
    }

    @Override
    public boolean getConfigAsBool(String cfgKey, boolean defValue) {
        return PropertyUtil.getPropertyAsBool(this.configs, cfgKey, defValue);
    }

    protected void initialize(String configFileName) {
        Properties currConfigs = PropertyUtil.loadFromResource(this.getClass(), configFileName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Inject config]: " + currConfigs));
        }
        this.configs = currConfigs;
    }

    @Override
    public synchronized void reload() {
        this.initialize(this.configFileName);
    }

    @Override
    public Properties getCustomHBProps() {
        return PropertyUtil.getSubProperties(this.configs, "hibernate");
    }

    @Override
    public Properties getProperties() {
        return this.configs;
    }
}

