/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.protocol;

import com.trs.net.ftp.protocol.ProtocolEvent;
import com.trs.net.ftp.protocol.ProtocolListener;
import java.net.ServerSocket;

class ProtocolListenerContainer {
    private int m_iCount = 0;
    private Object m_oSource;
    private ProtocolListener[] m_oContainer;

    ProtocolListenerContainer(Object source) {
        this.m_oSource = source;
        this.m_oContainer = new ProtocolListener[16];
    }

    void fireActiveTimeout(ServerSocket socket, int iTimeout) {
        if (this.m_iCount <= 0) {
            return;
        }
        int iCount = this.m_iCount;
        int iPort = socket.getLocalPort();
        String sHost = socket.getInetAddress().getHostAddress();
        ProtocolEvent event = new ProtocolEvent(this.m_oSource, sHost, iPort, iTimeout);
        ProtocolListener[] list = this.m_oContainer;
        int i = 0;
        while (i < iCount) {
            list[i].onCommandSent(event);
            ++i;
        }
    }

    void fireCommandSent(String command, String message) {
        if (this.m_iCount <= 0) {
            return;
        }
        int iCount = this.m_iCount;
        ProtocolEvent event = new ProtocolEvent(this.m_oSource, command, message);
        ProtocolListener[] list = this.m_oContainer;
        int i = 0;
        while (i < iCount) {
            list[i].onCommandSent(event);
            ++i;
        }
    }

    void fireReplyReceived(int replyCode, String message) {
        if (this.m_iCount <= 0) {
            return;
        }
        int iCount = this.m_iCount;
        ProtocolEvent event = new ProtocolEvent(this.m_oSource, replyCode, message);
        ProtocolListener[] list = this.m_oContainer;
        int i = 0;
        while (i < iCount) {
            list[i].onReplyReceived(event);
            ++i;
        }
    }

    synchronized void addProtocolListener(ProtocolListener listener) {
        if (listener == null) {
            return;
        }
        if (this.m_iCount >= this.m_oContainer.length) {
            ProtocolListener[] newContainer = new ProtocolListener[this.m_iCount * 2];
            int i = 0;
            while (i < this.m_iCount) {
                newContainer[i] = this.m_oContainer[i];
                ++i;
            }
            this.m_oContainer = newContainer;
        }
        int i = 0;
        while (i < this.m_iCount) {
            if (listener == this.m_oContainer[i]) {
                return;
            }
            ++i;
        }
        this.m_oContainer[this.m_iCount++] = listener;
    }

    synchronized void removeProtocolListener(ProtocolListener listener) {
        if (listener == null || this.m_iCount == 0) {
            return;
        }
        int iFound = -1;
        int i = 0;
        while (i < this.m_iCount) {
            if (listener == this.m_oContainer[i]) {
                iFound = i;
                break;
            }
            ++i;
        }
        if (iFound >= 0) {
            --this.m_iCount;
            i = iFound;
            while (i <= this.m_iCount) {
                this.m_oContainer[i] = i < this.m_iCount ? this.m_oContainer[i + 1] : null;
                ++i;
            }
            this.m_oContainer[this.m_iCount] = null;
        }
    }

    public boolean hasListener() {
        return this.m_iCount > 0;
    }

    public int size() {
        return this.m_iCount;
    }
}

