/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.analysis;

import com.chenlb.mmseg4j.analysis.TokenUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class CutLetterDigitFilter
extends TokenFilter {
    protected Queue<Token> tokenQueue = new LinkedList<Token>();
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private Token reusableToken = new Token();

    public CutLetterDigitFilter(TokenStream tokenStream) {
        super(tokenStream);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public Token next(Token token) throws IOException {
        return this.nextToken(token);
    }

    private Token nextToken(Token token) throws IOException {
        assert (token != null);
        Token token2 = this.tokenQueue.poll();
        if (token2 != null) {
            return token2;
        }
        token2 = TokenUtils.nextToken(this.input, token);
        if (token2 != null && ("letter_or_digit".equalsIgnoreCase(token2.type()) || "digit_or_letter".equalsIgnoreCase(token2.type()))) {
            char[] cArray = token2.termBuffer();
            int n = token2.termLength();
            byte by = (byte)Character.getType(cArray[0]);
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                byte by2 = (byte)Character.getType(cArray[i]);
                if (by2 <= 4) {
                    by2 = 2;
                }
                if (by2 != by) {
                    this.addToken(token2, n2, n3, by);
                    n2 += n3;
                    n3 = 0;
                    by = by2;
                }
                ++n3;
            }
            if (n3 > 0) {
                this.addToken(token2, n2, n3, by);
            }
            token2 = this.tokenQueue.poll();
        }
        return token2;
    }

    private void addToken(Token token, int n, int n2, byte by) {
        Token token2 = new Token(token.termBuffer(), n, n2, token.startOffset() + n, token.startOffset() + n + n2);
        if (by == 9) {
            token2.setType("digit");
        } else {
            token2.setType("letter");
        }
        this.tokenQueue.offer(token2);
    }

    public void close() throws IOException {
        super.close();
        this.tokenQueue.clear();
    }

    public void reset() throws IOException {
        super.reset();
        this.tokenQueue.clear();
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        Token token = this.nextToken(this.reusableToken);
        if (token != null) {
            this.termAtt.setTermBuffer(token.termBuffer(), 0, token.termLength());
            this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
            this.typeAtt.setType(token.type());
            return true;
        }
        this.end();
        return false;
    }

    public void end() {
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

