/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix4j.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zabbix4j.ZabbixApiException;
import com.zabbix4j.ZabbixApiMethod;
import com.zabbix4j.configuration.ConfigurationExportRequest;
import com.zabbix4j.configuration.ConfigurationExportResponse;
import com.zabbix4j.configuration.ConfigurationImportRequest;
import com.zabbix4j.configuration.ConfigurationImportResponse;

public class Configuration
extends ZabbixApiMethod {
    public Configuration(String apiUrl, String auth) {
        super(apiUrl, auth);
    }

    public ConfigurationExportResponse export(ConfigurationExportRequest request) throws ZabbixApiException {
        ConfigurationExportResponse response = null;
        request.setAuth(this.auth);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String requestJson = gson.toJson((Object)request);
        try {
            String responseJson = this.sendRequest(requestJson);
            response = (ConfigurationExportResponse)gson.fromJson(responseJson, ConfigurationExportResponse.class);
        }
        catch (ZabbixApiException e) {
            throw new ZabbixApiException(e);
        }
        return response;
    }

    public ConfigurationImportResponse imports(ConfigurationImportRequest request) throws ZabbixApiException {
        ConfigurationImportResponse response = null;
        request.setAuth(this.auth);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String requestJson = gson.toJson((Object)request);
        try {
            String responseJson = this.sendRequest(requestJson);
            response = (ConfigurationImportResponse)gson.fromJson(responseJson, ConfigurationImportResponse.class);
        }
        catch (ZabbixApiException e) {
            throw new ZabbixApiException(e);
        }
        return response;
    }

    public static enum FORMAT {
        JSON("json"),
        XML("xml");

        public String value;

        private FORMAT(String value) {
            this.value = value;
        }
    }
}

