/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.swf;

import com.artofsolving.jodconverter.DocumentFamily;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.util.swf.ErrorInputStreamWatchThread;
import com.trs.util.swf.InputStreamWatchThread;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SWFCreator
extends Thread {
    private static Logger m_Logger = Logger.getLogger(SWFCreator.class);
    private FileService m_oSrcFile;
    private FileService m_oPDFFile;
    private String m_sSWFFileName;
    public String m_sServiceHost = "127.0.0.1";
    public int m_nServicePort = 8100;
    public String m_sSWFToollsPath = "C:\\SWFTools\\";

    public SWFCreator(String _sSrcFileName) {
        this.m_oSrcFile = new FileService(_sSrcFileName);
        String sPDFFileName = SWFCreator.changeFileExt(_sSrcFileName, "pdf");
        this.m_oPDFFile = new FileService(sPDFFileName);
        this.m_sSWFFileName = SWFCreator.changeFileExt(_sSrcFileName, "swf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toPDF() {
        String sFileExt = SWFCreator.extractFileExt(this.m_oSrcFile.getName());
        if (sFileExt.equalsIgnoreCase("pdf") || this.m_oPDFFile.exists()) {
            return true;
        }
        boolean bResult = false;
        long lStartTime = System.currentTimeMillis();
        SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(this.m_sServiceHost, this.m_nServicePort);
        try {
            connection.connect();
            OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter((OpenOfficeConnection)connection);
            if (sFileExt.equalsIgnoreCase("txt")) {
                String sCharset = CharsetDetector.detect(this.m_oSrcFile.getAbsolutePath());
                DocumentFormat txt = new DocumentFormat("Plain Text", DocumentFamily.TEXT, "text/plain", "txt");
                txt.setImportOption("FilterName", (Object)"Text (encoded)");
                txt.setImportOption("FilterOptions", (Object)(sCharset + ",CRLF"));
                txt.setExportFilter(DocumentFamily.TEXT, "Text (encoded)");
                txt.setExportOption(DocumentFamily.TEXT, "FilterOptions", (Object)(sCharset + ",CRLF"));
                DocumentFormat pdf = new DocumentFormat("Portable Document Format", "application/pdf", "pdf");
                pdf.setExportFilter(DocumentFamily.DRAWING, "draw_pdf_Export");
                pdf.setExportFilter(DocumentFamily.PRESENTATION, "impress_pdf_Export");
                pdf.setExportFilter(DocumentFamily.SPREADSHEET, "calc_pdf_Export");
                pdf.setExportFilter(DocumentFamily.TEXT, "writer_pdf_Export");
                converter.convert(this.m_oSrcFile.getInputStream(), txt, this.m_oPDFFile.getOutputStream(), pdf);
            } else {
                converter.convert(this.m_oSrcFile.getInputStream(), null, this.m_oPDFFile.getOutputStream(), null);
            }
            bResult = true;
        }
        catch (ConnectException cex) {
            cex.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        m_Logger.debug((Object)("\u751f\u6210" + this.m_oPDFFile.getName() + "\u8017\u8d39\uff1a" + (System.currentTimeMillis() - lStartTime) + "\u6beb\u79d2"));
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean toSWF() throws IOException {
        if (new FileService(this.m_sSWFFileName).exists()) {
            return true;
        }
        if (!this.m_oPDFFile.exists()) {
            m_Logger.info((Object)"pdf\u8f6c\u6362swf\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728!");
            throw new IOException();
        }
        if (this.m_sSWFToollsPath.length() > 0 && this.m_sSWFToollsPath.charAt(this.m_sSWFToollsPath.length() - 1) != File.separatorChar) {
            this.m_sSWFToollsPath = this.m_sSWFToollsPath + File.separatorChar;
        }
        FileService fileService = this.m_oPDFFile;
        synchronized (fileService) {
            m_Logger.debug((Object)("\u5f00\u59cb\u8c03\u7528swftools\u8f6c\u6362pdf\u6587\u4ef6:" + this.m_sSWFFileName));
            String sSwfToolsDir = this.m_sSWFToollsPath + "pdf2swf";
            ArrayList<String> command = new ArrayList<String>();
            command.add(sSwfToolsDir);
            command.add("-z");
            command.add("-s");
            command.add("flashversion=9");
            command.add("-s");
            command.add("poly2bitmap");
            command.add(this.m_oPDFFile.getAbsolutePath());
            command.add("-o");
            command.add(this.m_sSWFFileName);
            String[] cmdarray = new String[command.size()];
            command.toArray(cmdarray);
            if (m_Logger.isDebugEnabled()) {
                m_Logger.info((Object)"pdf2swf\u6267\u884c\u7684\u547d\u4ee4\uff1a");
                StringBuffer sbCmd = new StringBuffer();
                for (int i = 0; i < cmdarray.length; ++i) {
                    sbCmd.append(cmdarray[i]).append(" ");
                }
                m_Logger.info((Object)sbCmd.toString());
            }
            Process process = Runtime.getRuntime().exec(cmdarray);
            InputStreamWatchThread inputWathThread = new InputStreamWatchThread(process);
            inputWathThread.start();
            ErrorInputStreamWatchThread errorInputWathThread = new ErrorInputStreamWatchThread(process);
            errorInputWathThread.start();
            try {
                process.waitFor();
                inputWathThread.setOver(true);
                errorInputWathThread.setOver(true);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        m_Logger.debug((Object)"\u8f6c\u6362\u5b8c\u6210");
        return true;
    }

    @Override
    public void run() {
        if (this.toPDF()) {
            try {
                this.toSWF();
            }
            catch (Exception e) {
                m_Logger.error((Object)("Fail to convert " + this.m_oSrcFile + " to " + this.m_sSWFFileName), (Throwable)e);
            }
        }
    }

    public FileService getInputFile() {
        return this.m_oSrcFile;
    }

    public void setInputFile(FileService inputFile) {
        this.m_oSrcFile = inputFile;
    }

    public FileService getOutputFile() {
        return this.m_oPDFFile;
    }

    public void setOutputFile(FileService outputFile) {
        this.m_oPDFFile = outputFile;
    }

    private static String extractFileExt(String _sFileName) {
        int nPos = _sFileName.lastIndexOf(46);
        return nPos >= 0 ? _sFileName.substring(nPos + 1) : "";
    }

    private static String changeFileExt(String _sFileName, String _sNewExt) {
        int nPos = _sFileName.lastIndexOf(46);
        if (nPos < 0) {
            return _sFileName + "." + _sNewExt;
        }
        return _sFileName.substring(0, nPos + 1) + _sNewExt;
    }

    public static void main(String[] args) {
        SWFCreator tools = new SWFCreator("c:/TRS\u5185\u5bb9\u7ba1\u7406\u4ea4\u6d41.ppt");
        tools.start();
    }
}

