/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.database.TableInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class DocBakMgr {
    private static Logger m_oLogger = Logger.getLogger((String)DocBakMgr.class.getName());

    public DocBaks findDocBaks(Document _currDocument) throws WCMException {
        return this.findDocBaks(_currDocument, null);
    }

    public DocBaks findDocBaks(Document _currDocument, WCMFilter _filter) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label1", "\u5f53\u524d\u6587\u6863\u4e3a\u7a7a,\u65e0\u6cd5\u53d6\u5f97\u5176\u5907\u4efd"));
        }
        String sWhere = "DocId=" + _currDocument.getDocId();
        WCMFilter aFilter = new WCMFilter("", sWhere, "DOCVERSION");
        aFilter.mergeWith(_filter);
        try {
            return DocBaks.openWCMObjs(this.getLoginUser(), aFilter);
        }
        catch (Exception ex) {
            m_oLogger.debug((Object)ex.getMessage());
            throw new WCMException(1100, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label2", "\u6253\u5f00\u6587\u6863\u5907\u4efd\u96c6\u5408\u5931\u8d25!"), ex);
        }
    }

    public DocBak getDocBak(Document _currDocument, int _nVersion) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "DocVersion=" + _nVersion, "");
        DocBaks aDocBaks = this.findDocBaks(_currDocument, aFilter);
        if (aDocBaks == null || aDocBaks.isEmpty()) {
            return null;
        }
        return (DocBak)aDocBaks.getAt(0);
    }

    public synchronized DocBak bakupDocument(Document _currDocument) throws WCMException {
        if (_currDocument == null || !_currDocument.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label3", "\u5f53\u524d\u6587\u6863\u65e0\u6548,\u65e0\u6cd5\u5907\u4efd\u8be5\u6587\u6863!"));
        }
        int nVersionNew = this.getNewDocVersion(_currDocument);
        DocBak anOldDocBak = this.getDocBak(_currDocument, nVersionNew);
        if (anOldDocBak != null) {
            this.deleteDocBak(anOldDocBak);
        }
        DocBak docBakNew = this.saveDocBak(_currDocument);
        if (!_currDocument.isAddMode() && _currDocument.isModified()) {
            _currDocument.setVersion(nVersionNew);
        } else {
            _currDocument.setVersion(nVersionNew);
            AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            Appendixes newAppendixes = appendixMgr.getAppendixes(_currDocument, -1);
            for (int i = 0; i < newAppendixes.size(); ++i) {
                appendixMgr.saveAppendix(_currDocument, (Appendix)newAppendixes.getAt(i));
            }
            String[] pSQL = new String[]{"update WCMDOCUMENT SET DOCVERSION=? where DocId=?"};
            int[] pParameters = new int[]{nVersionNew, _currDocument.getId()};
            DBManager.getDBManager().sqlExecuteUpdate(pSQL, pParameters);
        }
        return docBakNew;
    }

    private int getNewDocVersion(Document _currDocument) throws WCMException {
        int nVersionNew = _currDocument.getVersion() + 1;
        if (nVersionNew >= 59) {
            WCMFilter aFilter = new WCMFilter("", "", "BakTime", "DocId,DocVersion", 1);
            DocBaks aDocBaks = this.findDocBaks(_currDocument, aFilter);
            if (aDocBaks.isEmpty()) {
                nVersionNew = 0;
            } else {
                DocBak aDocBak = (DocBak)aDocBaks.getAt(0);
                if (aDocBak == null) {
                    nVersionNew = 0;
                } else {
                    nVersionNew = aDocBak.getVersion();
                    this.deleteDocBak(aDocBak);
                }
            }
        }
        return nVersionNew;
    }

    public void deleteDocBak(DocBak _currDocBak) throws WCMException {
        if (_currDocBak == null) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label4", "\u6587\u6863\u5907\u4efd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        _currDocBak.delete(this.getLoginUser());
    }

    private DocBak saveDocBak(Document _currDocument) throws WCMException {
        User user = this.getLoginUser();
        DocBak docBakNew = new DocBak();
        docBakNew.canEdit(user);
        docBakNew.setProperties(_currDocument.getAllProperty());
        docBakNew.removeProperty("DOCFROMVERSION");
        docBakNew.setBakUser(user);
        docBakNew.insert(user);
        return docBakNew;
    }

    public Document recoverDocument(DocBak _aDocBak, Document _currDocument) throws WCMException {
        if (_currDocument == null || !_currDocument.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label5", "\u5f53\u524d\u6587\u6863\u65e0\u6548,\u65e0\u6cd5\u6062\u590d"));
        }
        if (_aDocBak == null || !_aDocBak.isValidInstance() || _aDocBak.getDocId() != _currDocument.getId()) {
            throw new WCMException(10, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label6", "\u6307\u5b9a\u6587\u6863\u5907\u4efd\u5bf9\u8c61\u65e0\u6548"));
        }
        if (!_currDocument.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label7", "\u9501\u5b9a\u5bf9\u8c61\u5931\u8d25,\u5f53\u524d\u6587\u6863\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a!"));
        }
        try {
            int nDocChnlId = _currDocument.getChannelId();
            _currDocument = this.recoverDataFromBak(_aDocBak, _currDocument);
            _currDocument.setFromVersion(_aDocBak.getVersion());
            _currDocument.setChannel(nDocChnlId);
        }
        catch (Exception ex) {
            _currDocument.unlock();
            throw new WCMException(1100, I18NMessage.get(DocBakMgr.class, "DocBakMgr.label8", "\u4ece\u5907\u4efd\u4e2d\u6062\u590d\u6570\u636e\u5931\u8d25"), ex);
        }
        DocumentMgr currMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        _currDocument = currMgr.save(_currDocument);
        return _currDocument;
    }

    private Document recoverDataFromBak(DocBak _aDocBak, Document _currDocument) throws WCMException {
        DocBak aDocBak = (DocBak)_aDocBak.cloneToNewWCMObj();
        DBManager dbmanager = DBManager.getDBManager();
        if (dbmanager.getDBTypeAsInt() == 1) {
            Hashtable<String, Object> props = aDocBak.getAllProperty();
            TableInfo docTable = dbmanager.getTableInfo("WCMDOCUMENT");
            Enumeration itrField = docTable.getFieldNames();
            while (itrField.hasMoreElements()) {
                String fieldName = (String)itrField.nextElement();
                if ("DOCID".equals(fieldName) || "CRTIME".equals(fieldName) || props.containsKey(fieldName)) continue;
                props.put(fieldName, new NullValue(docTable.getFieldInfo(fieldName).getDataType().getType()));
            }
        }
        aDocBak.removeProperty("BAKTIME");
        aDocBak.removeProperty("BAKUSER");
        aDocBak.removeProperty("DOCVERSION");
        aDocBak.removeProperty("DOCSTATUS");
        _currDocument.setNewProperties(aDocBak.getAllProperty());
        return _currDocument;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

