/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateEmployMgr {
    private static final Logger logger = Logger.getLogger((String)TemplateEmployMgr.class.getName());
    private ITemplateEmployCacheMgr m_oCacheMgr = (ITemplateEmployCacheMgr)DreamFactory.createObjectById("ITemplateEmployCacheMgr");

    public TemplateEmploys getEmploysOf(IPublishElement _employer, int _nTemplateType) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.getEmploysOfEmployer(_employer.getType(), _employer.getId(), _nTemplateType);
    }

    public TemplateEmploys getEmploysOf(IPublishElement _employer) throws WCMException {
        return this.getEmploysOf(_employer, -1);
    }

    public TemplateEmploys getEmploysOfEmployer(int _nEmployerType, int _nEmployerId, int _nTemplateType) throws WCMException {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("EMPLOYERID=").append(_nEmployerId);
            buff.append(" AND EMPLOYERTYPE=").append(_nEmployerType);
            if (_nTemplateType != -1) {
                buff.append(" AND TEMPLATETYPE=").append(_nTemplateType);
            }
            WCMFilter filter = new WCMFilter("", buff.toString(), "ISDEFAULT DESC");
            buff.setLength(0);
            TemplateEmploys employs = new TemplateEmploys(ContextHelper.getLoginUser());
            employs.open(filter);
            return employs;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query template employs of the specified employer!", ex);
        }
    }

    private TemplateEmploy getDefaultEmployOfEmployer(int _nEmployerType, int _nEmployerId, int _nTemplateType) throws WCMException {
        try {
            StringBuffer buff = new StringBuffer(64);
            buff.append("EMPLOYERID=?");
            buff.append(" AND EMPLOYERTYPE=?");
            buff.append(" AND TEMPLATETYPE=?");
            buff.append(" AND ISDEFAULT=1");
            WCMFilter filter = new WCMFilter("", buff.toString(), "");
            filter.addSearchValues(_nEmployerId);
            filter.addSearchValues(_nEmployerType);
            filter.addSearchValues(_nTemplateType);
            filter.setMaxRowNumber(1);
            buff.setLength(0);
            TemplateEmploys employs = new TemplateEmploys(ContextHelper.getLoginUser());
            employs.open(filter);
            if (employs.isEmpty()) {
                return null;
            }
            return (TemplateEmploy)employs.getAt(0);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query template employs of the specified employer!", ex);
        }
    }

    public TemplateEmploys getEmploysOfEmployer(int _nEmployerType, int _nEmployerId) throws WCMException {
        return this.getEmploysOfEmployer(_nEmployerType, _nEmployerId, -1);
    }

    private Templates getTemplates(IPublishElement _employer, int _nTemplateType) throws WCMException {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("EMPLOYERID=").append(_employer.getId());
            buff.append(" AND EMPLOYERTYPE=").append(_employer.getType());
            if (_nTemplateType != -1) {
                buff.append(" AND TEMPLATETYPE=" + _nTemplateType);
            }
            WCMFilter filter = new WCMFilter("WCMTEMPLATEEMPLOY", buff.toString(), "ISDEFAULT DESC", "TEMPLATEID AS TEMPID");
            buff.setLength(0);
            Templates templates = new Templates(ContextHelper.getLoginUser());
            templates.open(filter);
            return templates;
        }
        catch (Exception ex) {
            String s = "Failed to fetch the employed templates of the specified employer.";
            logger.fatal((Object)s, (Throwable)ex);
            throw new WCMException(1100, s, ex);
        }
    }

    public Templates getOutlineTemplates(IPublishFolder _folder) throws WCMException {
        return this.m_oCacheMgr.getOutlineTemplates(_folder);
    }

    public Templates getOtherOutlineTemplates(IPublishFolder _folder) throws WCMException {
        StringBuffer buff = new StringBuffer();
        buff.append("EMPLOYERID=").append(_folder.getId());
        buff.append(" AND EMPLOYERTYPE=").append(_folder.getType());
        buff.append(" AND TEMPLATETYPE=");
        buff.append(1).append(" AND ");
        buff.append("ISDEFAULT=").append(0);
        WCMFilter filter = new WCMFilter("WCMTEMPLATEEMPLOY", buff.toString(), "", "TEMPLATEID AS TEMPID");
        buff.setLength(0);
        Templates templates = new Templates(ContextHelper.getLoginUser());
        templates.open(filter);
        return templates;
    }

    public Template getDefaultOutlineTemplate(IPublishFolder _folder) throws WCMException {
        return this.m_oCacheMgr.getDefaultOutlineTemplate(_folder);
    }

    public Template getDetailTemplate(IPublishElement _employer) throws WCMException {
        return this.m_oCacheMgr.getDetailTemplate(_employer);
    }

    public Template getDetailTemplate(int _nEmployerType, int _nEmployerId) throws WCMException {
        return this.m_oCacheMgr.getDetailTemplate(_nEmployerType, _nEmployerId);
    }

    public Template getDetailTemplate(IPublishElement _employer, int _nTemplateType) throws WCMException {
        if (_nTemplateType == 2) {
            return this.m_oCacheMgr.getDetailTemplate(_employer);
        }
        return this.getDefaultTemplate(_employer, _nTemplateType);
    }

    private Template getDefaultTemplate(IPublishElement _employer, int _nTemplateType) throws WCMException {
        BaseObjs templates = null;
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("EMPLOYERID=").append(_employer.getId());
            buff.append(" AND EMPLOYERTYPE=").append(_employer.getType());
            buff.append(" AND TEMPLATETYPE=").append(_nTemplateType);
            buff.append(" AND ISDEFAULT=1");
            WCMFilter filter = new WCMFilter("WCMTEMPLATEEMPLOY", buff.toString(), null, "TEMPLATEID AS TEMPID");
            filter.setMaxRowNumber(1);
            buff.setLength(0);
            templates = Templates.openWCMObjs(ContextHelper.getLoginUser(), filter);
            if (templates.isEmpty()) {
                Template template = null;
                return template;
            }
            Template template = (Template)templates.getAt(0);
            return template;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the default employed template of the specified employer.", ex);
        }
        finally {
            if (templates != null) {
                templates.clear();
            }
        }
    }

    public void setOutlineTemplates(IPublishFolder _folder, String _sTemplateIds, boolean _bResetChildren) throws WCMException {
        if (_sTemplateIds == null || (_sTemplateIds = _sTemplateIds.trim()).length() == 0) {
            throw new WCMException(10, "Template id list required!");
        }
        User loginUser = ContextHelper.getLoginUser();
        try {
            int[] arrTemplateIds = CMyString.splitToInt(_sTemplateIds, ",");
            if (arrTemplateIds.length < 1) {
                throw new WCMDatainvalidException(I18NMessage.get(TemplateEmployMgr.class, "TemplateEmployMgr.label1", "\u4f20\u5165\u7684\u6982\u89c8\u6a21\u677f\u5e8f\u5217\u6709\u8bef!"));
            }
            this.setDefaultOutline(_folder, arrTemplateIds[0]);
            this.deleteUnuseEmploys(loginUser, _folder, arrTemplateIds);
            this.dowthNewOtherOutlineEmploys(loginUser, _folder, arrTemplateIds);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to set the folder outline templates!", ex);
        }
        if (_bResetChildren) {
            this.resetChildern(_folder, _sTemplateIds, true);
        }
    }

    private void dowthNewOtherOutlineEmploys(User loginUser, IPublishFolder _folder, int[] arrTemplateIds) throws WCMException {
        if (arrTemplateIds.length == 1) {
            return;
        }
        Template defaultOutlineTemplate = this.m_oCacheMgr.getDefaultOutlineTemplate(_folder);
        Templates outlineTemplates = this.m_oCacheMgr.getOutlineTemplates(_folder);
        int nOthersStartIndex = 0;
        if (defaultOutlineTemplate != null && outlineTemplates.getIdAt(0) == defaultOutlineTemplate.getId()) {
            nOthersStartIndex = 1;
        }
        for (int i = 1; i < arrTemplateIds.length; ++i) {
            int nNewTemplateId = arrTemplateIds[i];
            if (outlineTemplates.indexOf(nNewTemplateId) >= nOthersStartIndex) continue;
            TemplateEmploy otherEmploy = new TemplateEmploy();
            otherEmploy.setEmployer(_folder);
            otherEmploy.setDefault(false);
            otherEmploy.setTemplate(1, nNewTemplateId);
            otherEmploy.save(loginUser);
        }
    }

    private void deleteUnuseEmploys(User loginUser, IPublishFolder _folder, int[] _currTemplateIds) throws WCMException {
        String sWhere = "ISDEFAULT=0 and EmployerType=? and EmployerId=?";
        if (_currTemplateIds.length > 1) {
            String sUseTemplateIds = String.valueOf(_currTemplateIds[1]);
            for (int i = 2; i < _currTemplateIds.length; ++i) {
                sUseTemplateIds = sUseTemplateIds + "," + _currTemplateIds[i];
            }
            sWhere = sWhere + " and TemplateId not in(" + sUseTemplateIds + ")";
        }
        WCMFilter delFilter = new WCMFilter("", sWhere, "");
        delFilter.addSearchValues(0, _folder.getType());
        delFilter.addSearchValues(1, _folder.getId());
        TemplateEmploys.openWCMObjs(loginUser, delFilter).removeAll(true);
    }

    public void setDefaultOutline(IPublishFolder _folder, int _nNewDefaultTemplateId) throws WCMException {
        if (_nNewDefaultTemplateId == 0) {
            if (this.m_oCacheMgr.getDefaultOutlineTemplate(_folder) == null) {
                return;
            }
            TemplateEmploy defaultEmploy = this.getDefaultEmployOfEmployer(_folder.getType(), _folder.getId(), 1);
            if (defaultEmploy != null) {
                defaultEmploy.delete(ContextHelper.getLoginUser());
            }
        } else {
            int nOldDefaultTemplateId;
            Template defatulTemplate = this.m_oCacheMgr.getDefaultOutlineTemplate(_folder);
            int n = nOldDefaultTemplateId = defatulTemplate == null ? 0 : defatulTemplate.getId();
            if (nOldDefaultTemplateId == _nNewDefaultTemplateId) {
                return;
            }
            TemplateEmploy defaultEmploy = this.getDefaultEmployOfEmployer(_folder.getType(), _folder.getId(), 1);
            if (defaultEmploy != null) {
                defaultEmploy.canEdit(ContextHelper.getLoginUser());
            } else {
                defaultEmploy = new TemplateEmploy();
                defaultEmploy.setEmployer(_folder);
                defaultEmploy.setDefault(true);
            }
            defaultEmploy.setTemplate(1, _nNewDefaultTemplateId);
            defaultEmploy.save(ContextHelper.getLoginUser());
        }
    }

    public void setOtherOutlines(User loginUser, IPublishFolder _folder, String _sTemplateIds) throws WCMException {
        String sWhere = "ISDEFAULT=0 and EmployerType=? and EmployerId=?";
        if (_sTemplateIds != null && _sTemplateIds.length() > 0) {
            sWhere = sWhere + " and TemplateId not in(" + _sTemplateIds + ")";
        }
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _folder.getType());
        filter.addSearchValues(1, _folder.getId());
        TemplateEmploys.openWCMObjs(loginUser, filter).removeAll(true);
        filter.setWhere("exists(select WCMTemplateEmploy.TemplateId from WCMTemplateEmploy where ISDEFAULT=0 and EmployerType=? and EmployerId=? and WCMTemplateEmploy.TemplateId=WCMTemplate.TempId)");
        Templates outlineTemplates = Templates.openWCMObjs(loginUser, filter);
        int[] arrTemplateIds = CMyString.splitToInt(_sTemplateIds, ",");
        for (int i = 0; i < arrTemplateIds.length; ++i) {
            int nNewTemplateId = arrTemplateIds[i];
            if (outlineTemplates.indexOf(nNewTemplateId) >= 0) continue;
            TemplateEmploy otherEmploy = new TemplateEmploy();
            otherEmploy.setEmployer(_folder);
            otherEmploy.setDefault(false);
            otherEmploy.setTemplate(1, nNewTemplateId);
            otherEmploy.save(loginUser);
        }
    }

    public void setDetailTemplate(IPublishElement _employer, int _nTemplateId, boolean _bResetChildren, int _nDetailTemplateType) throws WCMException {
        String sWhere = "EMPLOYERID=? and EMPLOYERTYPE=? and TEMPLATETYPE=?";
        WCMFilter filter = new WCMFilter("", sWhere, null);
        filter.addSearchValues(_employer.getId());
        filter.addSearchValues(_employer.getType());
        filter.addSearchValues(_nDetailTemplateType);
        filter.setMaxRowNumber(1);
        User currUser = ContextHelper.getLoginUser();
        TemplateEmploys employs = new TemplateEmploys(currUser, 1, 1);
        employs.open(filter);
        if (_nTemplateId == 0) {
            employs.removeAll(true);
        } else {
            try {
                TemplateEmploy employ = null;
                if (employs.isEmpty()) {
                    employ = new TemplateEmploy();
                    employ.setEmployer(_employer);
                    employ.setTemplate(_nDetailTemplateType, _nTemplateId);
                    employ.setDefault(true);
                    employ.insert(currUser);
                } else {
                    employ = (TemplateEmploy)employs.getAt(0);
                    if (employ.canEdit(currUser)) {
                        employ.setTemplate(_nDetailTemplateType, _nTemplateId);
                        employ.setEmployer(_employer);
                        employ.setTemplate(_nDetailTemplateType, _nTemplateId);
                        employ.setDefault(true);
                        employ.update(currUser);
                    }
                }
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to set the employer detail template!", ex);
            }
            finally {
                if (employs != null) {
                    employs.clear();
                }
            }
        }
        if (_bResetChildren && _employer instanceof IPublishFolder) {
            String sIds = _nTemplateId == 0 ? "" : String.valueOf(_nTemplateId);
            this.resetChildern((IPublishFolder)_employer, sIds, false);
        }
    }

    public void setDetailTemplate(IPublishElement _employer, int _nTemplateId, boolean _bResetChildren) throws WCMException {
        String sWhere = "EMPLOYERID=? and EMPLOYERTYPE=? and TEMPLATETYPE=?";
        WCMFilter filter = new WCMFilter("", sWhere, null);
        filter.addSearchValues(_employer.getId());
        filter.addSearchValues(_employer.getType());
        filter.addSearchValues(2);
        filter.setMaxRowNumber(1);
        User currUser = ContextHelper.getLoginUser();
        TemplateEmploys employs = new TemplateEmploys(currUser, 1, 1);
        employs.open(filter);
        if (_nTemplateId == 0) {
            employs.removeAll(true);
        } else {
            try {
                TemplateEmploy employ = null;
                if (employs.isEmpty()) {
                    employ = new TemplateEmploy();
                    employ.setEmployer(_employer);
                    employ.setTemplate(2, _nTemplateId);
                    employ.setDefault(true);
                    employ.insert(currUser);
                } else {
                    employ = (TemplateEmploy)employs.getAt(0);
                    if (employ.canEdit(currUser)) {
                        employ.setTemplate(2, _nTemplateId);
                        employ.setEmployer(_employer);
                        employ.setDefault(true);
                        employ.update(currUser);
                    }
                }
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to set the employer detail template!", ex);
            }
            finally {
                if (employs != null) {
                    employs.clear();
                }
            }
        }
        if (_bResetChildren && _employer instanceof IPublishFolder) {
            String sIds = _nTemplateId == 0 ? "0" : String.valueOf(_nTemplateId);
            this.resetChildern((IPublishFolder)_employer, sIds, false);
        }
    }

    public List getEmployers(Template _template, WCMFilter _filter) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        TemplateEmploys employs = null;
        try {
            employs = this.getTemplateEmployers(_template, _filter);
            ArrayList<IPublishElement> list = new ArrayList<IPublishElement>();
            for (int i = 0; i < employs.size(); ++i) {
                TemplateEmploy anEmploy = (TemplateEmploy)employs.getAt(i);
                if (anEmploy == null) continue;
                list.add(anEmploy.getEmployer());
            }
            ArrayList<IPublishElement> arrayList = list;
            return arrayList;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the folders who use the specified template.", ex);
        }
        finally {
            if (employs != null) {
                employs.clear();
            }
        }
    }

    public TemplateEmploys getTemplateEmployers(Template _template, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "TEMPLATEID=?", "");
        filter.addSearchValues(0, _template.getId());
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        TemplateEmploys employs = new TemplateEmploys(ContextHelper.getLoginUser());
        employs.open(filter);
        return employs;
    }

    public List getEmployers(Template _template, int _nEmployerType) throws WCMException {
        WCMFilter filter = new WCMFilter("", "EMPLOYERTYPE=?", "");
        filter.addSearchValues(0, _nEmployerType);
        return this.getEmployers(_template, filter);
    }

    public int clearEmploysOfEmployer(IPublishElement _employer) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, "Valid publish element required!");
        }
        return this.clearEmploysOfEmployer(_employer.getType(), _employer.getId());
    }

    public int clearEmploysOfEmployer(int _nEmployerType, int _nEmployerId) throws WCMException {
        String sWhere = "EMPLOYERID=? AND EMPLOYERTYPE=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _nEmployerId);
        filter.addSearchValues(1, _nEmployerType);
        TemplateEmploys employs = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        int nRecord = employs.size();
        employs.removeAll(true);
        return nRecord;
    }

    public int clearEmploysOfTemplate(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        return this.clearEmploysOfTemplate(_template.getId());
    }

    public int clearEmploysOfTemplate(int _nTemplateId) throws WCMException {
        String sWhere = "TEMPLATEID=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _nTemplateId);
        TemplateEmploys employs = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), filter);
        int nRecord = employs.size();
        employs.removeAll(true);
        return nRecord;
    }

    public void resetChildern(IPublishFolder _folder, String _sTemplateIds, boolean _bOutLine) throws WCMException {
        IPublishElements children = _folder.getChildren();
        if (children == null) {
            return;
        }
        IPublishFolder child = null;
        for (int i = 0; i < children.size(); ++i) {
            Channel chnl;
            int nChnlType;
            try {
                child = (IPublishFolder)children.get(i);
            }
            catch (Exception e) {
                throw new WCMException(1100, I18NMessage.get(TemplateEmployMgr.class, "TemplateEmployMgr.label2", "\u83b7\u53d6\u5b50folder\u53d1\u751f\u5f02\u5e38!"), e);
            }
            if (child == null) continue;
            CMSObj substance = null;
            substance = child.getSubstance();
            if (substance != null && substance instanceof Channel && ((nChnlType = (chnl = (Channel)substance).getType()) == 2 || nChnlType == 1 || nChnlType == 11)) continue;
            if (_bOutLine) {
                this.setOutlineTemplates(child, _sTemplateIds, true);
                continue;
            }
            this.setDetailTemplate(child, Integer.parseInt(_sTemplateIds), true);
        }
    }

    public void resetChildern(IPublishFolder _folder) throws WCMException {
        Template detailTemplate = this.getDetailTemplate(_folder);
        String sTemplateId = "0";
        if (detailTemplate != null) {
            sTemplateId = String.valueOf(detailTemplate.getId());
        }
        this.resetChildern(_folder, sTemplateId, false);
        IPublishElements children = _folder.getChildren();
        if (children == null) {
            return;
        }
        Templates templates = this.getOutlineTemplates(_folder);
        sTemplateId = "0";
        if (!templates.isEmpty()) {
            sTemplateId = templates.getIdListAsString();
        }
        if (this.getDefaultOutlineTemplate(_folder) == null && !sTemplateId.equals("0")) {
            sTemplateId = "0," + sTemplateId;
        }
        this.resetChildern(_folder, sTemplateId, true);
    }
}

