/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GroupUserCacheMgr
implements ICacheMgr {
    public static int MAX_CACHE_SIZE = 52000;
    public static long LRU_CACHE_EXPIRES = 3600000L;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");

    public GroupUserCacheMgr() {
        cache.setMaxSize(MAX_CACHE_SIZE);
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (this.isListening(_oObjAdded)) {
            GroupUser groupUser = (GroupUser)_oObjAdded;
            this.addToCache(groupUser.getUserId(), groupUser.getGroupId());
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (this.isListening(_oObjDeleted)) {
            GroupUser groupUser = (GroupUser)_oObjDeleted;
            this.removeFromCache(groupUser.getUserId(), groupUser.getGroupId());
        }
    }

    @Override
    public boolean init() throws WCMException {
        Users aUsers = Users.openWCMObjs(null, null);
        int nCacheMaxSize = MAX_CACHE_SIZE;
        if (nCacheMaxSize < MAX_CACHE_SIZE && (nCacheMaxSize = (int)((double)nCacheMaxSize * 1.5)) > MAX_CACHE_SIZE) {
            nCacheMaxSize = MAX_CACHE_SIZE;
        }
        cache.setMaxSize(nCacheMaxSize);
        User currUser = null;
        for (int i = 0; i < 1000 && i < aUsers.size(); ++i) {
            currUser = (User)aUsers.getAt(i);
            if (currUser == null) continue;
            this.initCache(currUser.getId());
        }
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
    }

    final Groups getGroups(User _currUser) throws WCMException {
        return this.getGroups(_currUser.getId());
    }

    private void addToCache(int _nUserId, int _nGroupId) throws WCMException {
        Integer oGroupId;
        List<Object> list = cache.lrange(this.getKey(_nUserId), 0L, -1L);
        if (list == null || list.size() == 0) {
            this.initCache(_nUserId);
        }
        if (list.indexOf(oGroupId = new Integer(_nGroupId)) < 0) {
            cache.rpush(this.getKey(_nUserId), oGroupId);
        }
        cache.pexpire(this.getKey(_nUserId), LRU_CACHE_EXPIRES);
    }

    private void removeFromCache(int _nUserId, int _nGroupId) throws WCMException {
        String cacheKey = this.getKey(_nUserId);
        cache.lrem(cacheKey, 1L, new Integer(_nGroupId));
    }

    private Groups getGroups(int _nUserId) throws WCMException {
        Integer key = new Integer(_nUserId);
        Groups groups = null;
        List<Object> list = cache.lrange(this.getKey(key), 0L, -1L);
        if (list != null && list.size() > 0) {
            String _sIds = StringUtils.join(list, (String)",");
            groups = Groups.findByIds(null, _sIds);
        }
        if (groups != null) {
            return groups;
        }
        groups = this.initCache(_nUserId);
        return groups;
    }

    private synchronized Groups initCache(int _nUserId) throws WCMException {
        Integer iKey = new Integer(_nUserId);
        Groups groups = null;
        List<Object> list = cache.lrange(this.getKey(iKey), 0L, -1L);
        if (list != null && list.size() > 0) {
            String _sIds = StringUtils.join(list, (String)",");
            groups = Groups.findByIds(null, _sIds);
        }
        if (groups != null) {
            return groups;
        }
        String sWhere = "UserId=?";
        WCMFilter aFilter = new WCMFilter("WCMGrpUser", sWhere, "GroupId");
        aFilter.addSearchValues(_nUserId);
        groups = Groups.openWCMObjs(User.getSystem(), aFilter);
        String cacheKey = this.getKey(iKey);
        cache.clear(cacheKey);
        for (int i = 0; i < groups.size(); ++i) {
            cache.rpush(cacheKey, groups.getAt(i).getKey());
        }
        return groups;
    }

    private boolean isListening(BaseObj _obejct) {
        return _obejct != null && _obejct instanceof GroupUser;
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(Integer userId) {
        return this.getKey() + "." + userId;
    }
}

