/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class ChnlDocToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(ChnlDocToXML.class);
    private static final int CHNLID = 1;
    private static final int DOCSTATUS = 2;
    private static final int DOCID = 3;

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHNLID", 1, "CHANNEL");
        this.registerHostSpecialProperty("DOCSTATUS", 2);
        this.registerHostSpecialProperty("DOCID", 3, "DOCUMENT");
    }

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) throws ConvertException {
        try {
            switch (_nPropertyId) {
                case 1: {
                    return this.makeChannelValue(_currValue);
                }
                case 2: {
                    return this.makeStatus(_currValue);
                }
                case 3: {
                    int nDocId = ((Number)_currValue).intValue();
                    return this.makeDocumentValue(nDocId, _methodContext);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)CMyString.format(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label1", "\u8f6c\u6362\u5bf9\u8c61[{0}]\u6570\u636e[{1}\u5931\u8d25\uff01]"), new String[]{_currObj.toString(), _nPropertyId + ""}), (Throwable)e);
            throw new ConvertException(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label4", "\u8f6c\u6362\u6570\u636e[") + _nPropertyId + I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label3", "]\u5931\u8d25\uff01"), e);
        }
        return null;
    }

    private String[][] makeStatus(Object _currValue) throws WCMException {
        Status status = Status.findById(((Long)_currValue).intValue());
        if (status == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label5", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", status.getKey().toString()}, {"NAME", status.getDisp()}};
    }

    private String[][] makeDocumentValue(int _nDocId, MethodContext _methodContext) throws WCMException {
        Document document = Document.findById(_nDocId, _methodContext.getValue("DocumentSelectFields"));
        if (document == null) {
            return new String[][]{{"ID", String.valueOf(_nDocId)}, {"Title", I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label6", "======\u6587\u6863[ID=") + _nDocId + I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label7", "]\u6ca1\u6709\u627e\u5230\uff01======")}};
        }
        return new String[][]{{"ID", String.valueOf(_nDocId)}, {"DocType", String.valueOf(document.getType())}, {"DocTypeName", document.getTypeString()}, {"DocChannelId", String.valueOf(document.getChannelId())}, {"DocChannelName", document.getChannel().getDispDesc()}, {"Title", document.getTitle()}};
    }

    private String[][] makeChannelValue(Object _currValue) throws WCMException {
        Channel channel = Channel.findById(((Long)_currValue).intValue());
        if (channel == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label5", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", channel.getKey().toString()}, {"NAME", channel.getDispDesc()}};
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{ChnlDocs.class.getName(), ChnlDoc.class.getName()};
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) throws ConvertException {
        try {
            return new String[][]{{"CanEdit", String.valueOf(AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)((Document)object), 32))}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label8", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) throws ConvertException {
        ChnlDoc chnlDoc = (ChnlDoc)object;
        String[] sRightInfo = null;
        if (context.getValue("ContainsRight", false)) {
            try {
                Document document = chnlDoc.getDocument();
                User loginUser = ContextHelper.getLoginUser();
                Channel currChannel = chnlDoc.getChannel();
                String sRightValue = WCMDocumentHelper.makeRightValue(context, loginUser, currChannel, document);
                sRightInfo = new String[]{"Right", sRightValue};
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label9", "\u6784\u9020[DocId=") + chnlDoc.getDocId() + ",ChnlId=" + chnlDoc.getChannelId() + I18NMessage.get(ChnlDocToXML.class, "ChnlDocToXML.label10", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        String[] sTopedInfo = new String[]{"Topped", String.valueOf(chnlDoc.isTopped())};
        return new String[][]{sTopedInfo, sRightInfo};
    }
}

