/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.controller.login;

import com.trs.cis4.bean.SysApplication;
import com.trs.cis4.bean.SysUser;
import com.trs.cis4.bean.User;
import com.trs.cis4.gateway.logic.ISysUserLogic;
import com.trs.cis4.timer.task.UserStatusData;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.PasswordUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class Login_Controller
implements Controller {
    private Logger log = Logger.getLogger(Login_Controller.class);
    private String successView;
    private String failureView;
    private ISysUserLogic sysUserLogic;

    public void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public void setSuccessView(String successView) {
        this.successView = successView;
    }

    public void setSysUserLogic(ISysUserLogic sysUserLogic) {
        this.sysUserLogic = sysUserLogic;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse arg1) throws ServletException, ExceptionUtil {
        String signoffuser;
        Map<String, String> model = new HashMap<String, String>();
        String userid = request.getParameter("userid");
        String password = request.getParameter("password");
        String validateCode = (String)request.getSession().getAttribute("rand");
        String inputCode = request.getParameter("validatecode");
        SysUser sysUser = this.sysUserLogic.getSysUser(userid);
        this.log.info((Object)("\u767b\u9646\u4fe1\u606f\uff1auserid = " + userid + "; session\u4e2d\u7684\u9a8c\u8bc1\u7801\uff1a" + validateCode + "; \u7528\u6237\u8f93\u5165\u9a8c\u8bc1\u7801\u4e3a" + inputCode));
        if (validateCode == null || !validateCode.equalsIgnoreCase(inputCode) && !request.getParameter("signoffuser").equals("true")) {
            String failureShow = "\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01";
            model.put("failureShow", failureShow);
            model.put("userid", userid);
            model.put("password", password);
            model.put("validatecode", inputCode);
            return new ModelAndView(this.failureView, model);
        }
        if (sysUser == null) {
            String failureShow = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01";
            model.put("failureShow", failureShow);
            model.put("userid", userid);
            model.put("password", password);
            model.put("errortype", "0");
            model.put("validatecode", inputCode);
            return new ModelAndView(this.failureView, model);
        }
        if (!PasswordUtil.check((String)sysUser.getPassword(), (String)password)) {
            String failureShow = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01";
            model.put("failureShow", failureShow);
            model.put("userid", userid);
            model.put("password", password);
            model.put("errortype", "1");
            model.put("validatecode", inputCode);
            return new ModelAndView(this.failureView, model);
        }
        if (sysUser.getSinglelogin() != null && sysUser.getSinglelogin().booleanValue() && (model = this.checkUserOnline(userid, signoffuser = request.getParameter("signoffuser"))) != null) {
            return new ModelAndView(this.failureView, model);
        }
        this.log.info((Object)(String.valueOf(sysUser.getUserid()) + " \u7528\u6237\u9a8c\u8bc1\u901a\u8fc7\uff01"));
        this.assembleUser(sysUser, request);
        this.saveScreenValue(request);
        return new ModelAndView(this.successView);
    }

    public Map checkUserOnline(String userid, String signoffuser) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("errortype", "-1");
        String failureShow = "";
        try {
            Collection loginCollection = UserStatusData.getPlatformUsers().values();
            for (Object object : loginCollection) {
                if (object instanceof User) {
                    User user = (User)object;
                    if (!user.getSysuser().getUserid().equals(userid)) continue;
                    if (signoffuser.equals("true")) {
                        UserStatusData.removeUserBySessionid((String)user.getSessionid());
                        continue;
                    }
                    model.put("userLogined", new Boolean(true));
                    model.put("ip", user.getUserip());
                    model.put("failureShow", failureShow);
                    return model;
                }
                failureShow = "\u7528\u6237\u767b\u5f55\u5931\u8d25\uff01\uff01";
                model.put("failureShow", failureShow);
                return model;
            }
        }
        catch (Exception e) {
            System.out.println("\u767b\u9646\u5931\u8d25\uff01" + e);
            failureShow = "\u7528\u6237\u767b\u5f55\u5931\u8d25\uff01";
            model.put("failureShow", failureShow);
            return model;
        }
        return null;
    }

    public void assembleUser(SysUser sysUser, HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setMaxInactiveInterval(SysApplication.getSessionMaxInactiveInterval());
        User user = new User();
        user.setSysuser(sysUser);
        UserStatusData.addPlatformUser((String)session.getId(), (User)user);
        user.setUserip(request.getRemoteAddr());
        user.setSessionid(session.getId());
        user.setMaxinactiveinterval((long)session.getMaxInactiveInterval());
        user.setCreationtime(session.getCreationTime());
        session.setAttribute("user", (Object)user);
    }

    public void saveScreenValue(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String userwindowwidth = request.getParameter("userwindowwidth");
        String userwindowheight = request.getParameter("userwindowheight");
        String userwindowdpi = request.getParameter("userwindowdpi");
        session.setAttribute("userwindowwidth", (Object)userwindowwidth);
        session.setAttribute("userwindowheight", (Object)userwindowheight);
        session.setAttribute("userwindowdpi", (Object)userwindowdpi);
    }
}

