/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;

public abstract class DelegatingDataSource
implements DataSource,
InitializingBean {
    private DataSource targetDataSource;

    public void setTargetDataSource(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    public void afterPropertiesSet() {
        if (this.targetDataSource == null) {
            throw new IllegalArgumentException("targetDataSource is required");
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getTargetDataSource().getConnection(username, password);
    }

    public int getLoginTimeout() throws SQLException {
        return this.targetDataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.targetDataSource.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.targetDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.targetDataSource.setLogWriter(out);
    }
}

