/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class TdsInputStream
extends FilterInputStream
implements DataInput {
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    protected byte[] _buf = new byte[8];
    protected int _next = -1;
    protected int _last = -1;
    private boolean _byteswap = false;

    public TdsInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public int available() throws IOException {
        return this._last - this._next + this.in.available();
    }

    public void close() throws IOException {
        this._buf = null;
        this.in.close();
    }

    public void flush() {
        this._next = -1;
        this._last = -1;
    }

    public boolean getBigEndian() {
        return this._byteswap ^ true;
    }

    public abstract String getCharset();

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public boolean readBoolean() throws IOException {
        throw new IOException("Not implemented");
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public char readChar() throws IOException {
        throw new IOException("Not implemented");
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.read(byArray, n, n2);
            n += n3;
            n2 -= n3;
        }
    }

    public int readInt() throws IOException {
        int n = this.read(this._buf, 0, 4);
        if (n < 0) {
            throw new EOFException();
        }
        return this._byteswap ? (0xFF & this._buf[3]) << 24 | (0xFF & this._buf[2]) << 16 | (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 24 | (0xFF & this._buf[1]) << 16 | (0xFF & this._buf[2]) << 8 | 0xFF & this._buf[3];
    }

    public int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray, 0, 4);
        if (n < 0) {
            throw new EOFException();
        }
        return this._byteswap ? (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0] : (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
    }

    public String readLine() throws IOException {
        throw new IOException("Not implemented");
    }

    public long readLong() throws IOException {
        int n = this.read(this._buf, 0, 8);
        if (n < 0) {
            throw new EOFException();
        }
        return this._byteswap ? (0xFFL & (long)this._buf[7]) << 56 | (0xFFL & (long)this._buf[6]) << 48 | (0xFFL & (long)this._buf[5]) << 40 | (0xFFL & (long)this._buf[4]) << 32 | (0xFFL & (long)this._buf[3]) << 24 | (0xFFL & (long)this._buf[2]) << 16 | (0xFFL & (long)this._buf[1]) << 8 | 0xFFL & (long)this._buf[0] : (0xFFL & (long)this._buf[0]) << 56 | (0xFFL & (long)this._buf[1]) << 48 | (0xFFL & (long)this._buf[2]) << 40 | (0xFFL & (long)this._buf[3]) << 32 | (0xFFL & (long)this._buf[4]) << 24 | (0xFFL & (long)this._buf[5]) << 16 | (0xFFL & (long)this._buf[6]) << 8 | 0xFFL & (long)this._buf[7];
    }

    public short readShort() throws IOException {
        int n = this.read(this._buf, 0, 2);
        if (n < 0) {
            throw new EOFException();
        }
        return (short)(this._byteswap ? (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 8 | 0xFF & this._buf[1]);
    }

    public String readString(int n) throws IOException {
        return null;
    }

    public String readUTF() throws IOException {
        throw new IOException("Not implemented");
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public long readUnsignedIntAsLong() throws IOException {
        int n = this.read(this._buf, 0, 4);
        if (n != 4) {
            throw new EOFException();
        }
        return this._byteswap ? (0xFFL & (long)this._buf[3]) << 24 | (0xFFL & (long)this._buf[2]) << 16 | (0xFFL & (long)this._buf[1]) << 8 | 0xFFL & (long)this._buf[0] : (0xFFL & (long)this._buf[0]) << 24 | (0xFFL & (long)this._buf[1]) << 16 | (0xFFL & (long)this._buf[2]) << 8 | 0xFFL & (long)this._buf[3];
    }

    public int readUnsignedShort() throws IOException {
        int n = this.read(this._buf, 0, 2);
        if (n < 0) {
            throw new EOFException();
        }
        return this._byteswap ? (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 8 | 0xFF & this._buf[1];
    }

    public void setBigEndian(boolean bl) {
        this._byteswap = bl ^ true;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            n2 += (int)this.in.skip(n - n2);
        }
        return n;
    }
}

