/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.category.CategoryDataset;

public class RotatedAxisLabels
implements ChartPostProcessor {
    public void processChart(Object chart, Map params) {
        CategoryPlot plot = (CategoryPlot)((JFreeChart)chart).getPlot();
        CategoryAxis axis = plot.getDomainAxis();
        Number rotateThreshold = (Number)params.get("rotate_at");
        Number skipThreshold = (Number)params.get("skip_at");
        Number removeThreshold = (Number)params.get("remove_at");
        CategoryDataset dataset = plot.getDataset();
        int iCategoryCount = dataset.getRowCount();
        if (rotateThreshold != null) {
            if (iCategoryCount >= rotateThreshold.intValue()) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else {
                axis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
            }
        }
        if (skipThreshold != null) {
            // empty if block
        }
        if (removeThreshold != null) {
            axis.setTickLabelsVisible(iCategoryCount < removeThreshold.intValue());
        }
    }
}

