/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.InheritInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class InheritCaculatorByWCM52RightMode {
    private static Logger logger = Logger.getLogger(InheritCaculatorByWCM52RightMode.class);
    private RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private HashMap m_hDefineRightCacheForChannel = new HashMap();
    private HashMap m_hDefineRightCacheForSite = new HashMap();
    private Channels m_oLeafChannels = null;

    public List makeInheritInfo(Channels _channels) throws WCMException {
        DebugTimer timer = new DebugTimer();
        timer.start();
        Channels channels = _channels;
        if (channels == null) {
            WCMFilter filterForChannel = new WCMFilter("WCMChannel a", "status>=0 and not exists(select 1 from WCMChannel b where a.ChannelId=b.ParentId)", "ParentId", "");
            channels = Channels.openWCMObjs(null, filterForChannel);
        }
        this.m_oLeafChannels = channels;
        Users users = Users.openWCMObjs(null, null);
        timer.start();
        ArrayList<Integer> arChannelIdsDealWith = new ArrayList<Integer>();
        ArrayList<InheritInfo> arResult = new ArrayList<InheritInfo>(channels.size() * 10);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            while (channel != null) {
                int nParentId;
                Users oInheritUsers = new Users(null);
                DebugTimer tempTimer = new DebugTimer();
                tempTimer.start();
                int nUserSize = users.size();
                for (int j = 0; j < nUserSize; ++j) {
                    User user = (User)users.getAt(j);
                    if (user == null || user.isAdministrator()) continue;
                    user.setCacheGroupsAndRoles(true);
                    if (!this.hasInheritFromParent(user, channel)) continue;
                    oInheritUsers.addElement(user);
                }
                tempTimer.stop();
                if (tempTimer.getTime() > 1000L) {
                    logger.debug((Object)("HasInheritFromParent once use [" + tempTimer.getTime() + "]ms!"));
                }
                if (!oInheritUsers.isEmpty()) {
                    arResult.add(new InheritInfo(channel, oInheritUsers));
                }
                if ((nParentId = channel.getParentId()) == 0 || arChannelIdsDealWith.indexOf(new Integer(nParentId)) >= 0) break;
                arChannelIdsDealWith.add(new Integer(nParentId));
                channel = channel.getParent();
            }
            timer.stop();
            if (timer.getTime() > 1000L) {
                logger.debug((Object)("Dowith channel[" + channels.getAt(i) + "] use [" + timer.getTime() + "]ms!"));
            }
            timer.start();
        }
        return arResult;
    }

    private boolean hasInheritFromParent(User _user, Channel _oChannel) throws WCMException {
        boolean bHasDefineRight = this.hasDefineRightOnCurrObjFromCache(_user, _oChannel);
        if (bHasDefineRight) {
            return false;
        }
        for (BaseChannel parent = _oChannel.getHost(); parent != null; parent = parent.getHost()) {
            bHasDefineRight = this.hasDefineRightOnCurrObjFromCache(_user, parent);
            if (bHasDefineRight) {
                return true;
            }
            if (!parent.isSite()) continue;
            return false;
        }
        return false;
    }

    private boolean hasDefineRightOnCurrObjFromCache(User _user, BaseChannel _oChannelOrSite) throws WCMException {
        HashMap hCache = null;
        if (_oChannelOrSite.isSite()) {
            hCache = this.m_hDefineRightCacheForSite;
        } else {
            if (this.m_oLeafChannels.indexOf(_oChannelOrSite.getId()) >= 0) {
                return this.hasDefineRightOnCurrObj(_user, _oChannelOrSite);
            }
            hCache = this.m_hDefineRightCacheForChannel;
        }
        String sKey = _user.getId() + "." + _oChannelOrSite.getId();
        Boolean bResult = (Boolean)hCache.get(sKey);
        if (bResult != null) {
            return bResult;
        }
        boolean bHasDefineRight = this.hasDefineRightOnCurrObj(_user, _oChannelOrSite);
        hCache.put(sKey, new Boolean(bHasDefineRight));
        return bHasDefineRight;
    }

    private boolean hasDefineRightOnCurrObj(User _user, BaseChannel _oChannelOrSite) throws WCMException {
        long lTemp;
        int i;
        Roles roles = null;
        Groups groups = null;
        int nObjType = _oChannelOrSite.getWCMType();
        int nObjId = _oChannelOrSite.getId();
        long lRightValue = this.rightCacheMgr.getRightValue(_oChannelOrSite.getWCMType(), _oChannelOrSite.getId(), 204, _user.getId(), -1L);
        if (lRightValue != -1L) {
            return true;
        }
        roles = _user.getRoles();
        lRightValue = lRightValue > 0L ? lRightValue : 0L;
        for (i = 0; i < roles.size(); ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null || role.isSystemRole() || (lTemp = this.rightCacheMgr.getRightValue(nObjType, nObjId, 203, roles.getIdAt(i), -1L)) == -1L) continue;
            return true;
        }
        groups = _user.getGroups();
        for (i = 0; i < groups.size(); ++i) {
            Group currGroup = (Group)groups.getAt(i);
            if (currGroup == null || (lTemp = this.makeGroupRightValueOfObject(currGroup, nObjType, nObjId)) == -1L) continue;
            return true;
        }
        return false;
    }

    private long makeGroupRightValueOfObject(Group _currGroup, int _objType, int _objId) throws WCMException {
        long RIGHTVALUE_WHEN_NOT_EXISTS = -1L;
        if (_currGroup == null) {
            return RIGHTVALUE_WHEN_NOT_EXISTS;
        }
        long lTemp = this.rightCacheMgr.getRightValue(_objType, _objId, 201, _currGroup.getId(), RIGHTVALUE_WHEN_NOT_EXISTS);
        if (lTemp != RIGHTVALUE_WHEN_NOT_EXISTS) {
            return lTemp;
        }
        return this.makeGroupRightValueOfObject(_currGroup.getParent(), _objType, _objId);
    }

    public static void main(String[] args) {
    }
}

