/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BiTagValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(BiTagValidator.class, "BiTagValidator.label1", "W3C\u89c4\u8303");
    protected Object m_oWarning = I18NMessage.get(BiTagValidator.class, "BiTagValidator.label2", "B,I\u8282\u70b9\u4e3a\u975eWCAG2\u7684\u89c4\u8303\u8282\u70b9,\u5efa\u8bae\u66ff\u6362\u4e3astrong,em");
    protected String m_oExample = I18NMessage.get(BiTagValidator.class, "BiTagValidator.label3", "\u4f7f\u7528strong,em\u8282\u70b9\u52a0\u7c97/\u659c\u5b57\u4f53\uff0c\u907f\u514d\u4f7f\u7528B,I\u8282\u70b9\uff0c\u4f8b\u5982\uff1a<br>") + I18NMessage.get(BiTagValidator.class, "BiTagValidator.label4", "<br>&nbsp;&nbsp;<strong>\u52a0\u7c97</strong>(&lt;strong&gt;\u52a0\u7c97&lt;/strong&gt;)\uff0c<em>\u52a0\u659c</em>(&lt;em&gt;\u52a0\u659c&lt;/em&gt;)");

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList rst = new ArrayList();
        this.renderEle(content, rst, "B");
        this.renderEle(content, rst, "I");
        return rst;
    }

    private void renderEle(String content, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            this.addToList(content, rstFail, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

