/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JSLocaleLoader {
    private static Logger logger = Logger.getLogger(JSLocaleLoader.class);
    private Map m_mapCNLocales = new HashMap();
    private String[] m_sRootPaths = new String[]{"D:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app", "D:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/wcm_locales"};
    private Map m_mapENLocales = new HashMap();

    public static void main(String[] args) throws Exception {
        new JSLocaleLoader().loadLocales();
    }

    public void loadLocales() throws CMyException {
        for (int i = 0; i < this.m_sRootPaths.length; ++i) {
            this.loadLocalesInDir(new FileService(this.m_sRootPaths[i]));
        }
    }

    private void loadLocalesInDir(FileStore oFile) throws CMyException {
        if (!this.isAccept(oFile)) {
            return;
        }
        if (oFile.isFile()) {
            this.loadLocalesInFile(oFile);
            return;
        }
        FileStore[] files = oFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.loadLocalesInDir(files[i]);
        }
    }

    private boolean isAccept(FileStore oFile) {
        if (oFile.isDirectory()) {
            return true;
        }
        String sFileName = oFile.getAbsolutePath();
        if (!sFileName.endsWith(".js")) {
            return false;
        }
        if (sFileName.endsWith("localeimg.js")) {
            return false;
        }
        if (sFileName.indexOf("\\locale") >= 0) {
            return true;
        }
        if (sFileName.indexOf("lang") >= 0) {
            return true;
        }
        return sFileName.endsWith("cn.js") || sFileName.endsWith("en.js");
    }

    private void loadLocalesInFile(FileStore oFile) throws CMyException {
        logger.info((Object)("loader\u52a0\u8f7d\u6587\u4ef6:" + oFile.getAbsolutePath()));
        boolean bIsCN = this.isCN(oFile);
        this.toMap(oFile.getAbsolutePath(), bIsCN ? this.m_mapCNLocales : this.m_mapENLocales, bIsCN);
    }

    private boolean isCN(FileStore oFile) {
        String sFileName = oFile.getAbsolutePath();
        if (sFileName.endsWith("cn.js")) {
            return true;
        }
        if (sFileName.endsWith("en.js")) {
            return false;
        }
        return sFileName.indexOf("wcm_locales") < 0;
    }

    private Map toMap(String _sFileName, Map result, boolean isCN) throws CMyException {
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        String sEncoding = CharsetDetector.detect(_sFileName);
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, sEncoding));
            String sVarName = "";
            String sValue = "";
            while ((sLine = buffReader.readLine()) != null) {
                String sOldLine = sLine;
                if ((sLine = sLine.trim()).startsWith("+") && sVarName.length() > 0) {
                    sValue = sValue + "\n" + sOldLine;
                    result.put(sVarName, sValue);
                    continue;
                }
                int nPos = sLine.indexOf(58);
                if (nPos < 0 || sLine.startsWith("*") || sLine.startsWith("//")) continue;
                sVarName = sLine.substring(0, nPos).trim();
                sValue = sLine.substring(nPos + 1).trim();
                sValue = sValue.substring(1);
                try {
                    sValue = sValue.endsWith("',") || sValue.endsWith("\",") ? sValue.substring(0, sValue.length() - 2) : sValue.substring(0, sValue.length() - 1);
                }
                catch (Exception e) {
                    System.out.println("------------" + _sFileName);
                    throw new CMyException("\u8bfb\u53d6js\u6587\u4ef6\u4e2d\u7684\u884c\u4fe1\u606f\u5931\u8d25", e);
                }
                if (isCN) {
                    result.put(sValue, sVarName);
                    continue;
                }
                result.put(sVarName, sValue);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230", ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public String getLableByCN(String sChinese) {
        return (String)this.m_mapCNLocales.get(sChinese);
    }

    public String getENByLabel(String sLabel) {
        return (String)this.m_mapENLocales.get(sLabel);
    }
}

