/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.Favorite;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.MicroUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.model.Comment;
import weibo4j.model.CommentWapper;
import weibo4j.model.Favorites;
import weibo4j.model.Paging;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.User;

public class SinaObjectUtil {
    public static MicroContent constructMicroContent(Status _oSinaStatus) throws Exception {
        MicroContent oResult = new MicroContent();
        String sBmiddlePic = _oSinaStatus.getBmiddlePic();
        oResult.addBmiddlePic(sBmiddlePic);
        String sOriginalPic = _oSinaStatus.getOriginalPic();
        oResult.addOriginalPic(sOriginalPic);
        String sThumbnailPic = _oSinaStatus.getThumbnailPic();
        oResult.addThumbnailPic(sThumbnailPic);
        int nCommentCount = _oSinaStatus.getCommentsCount();
        oResult.setCommentCount(nCommentCount);
        String sContent = _oSinaStatus.getText();
        oResult.setContent(sContent);
        Date dCreateDate = _oSinaStatus.getCreatedAt();
        oResult.setCreateDate(dCreateDate);
        boolean bIsFavorited = _oSinaStatus.isFavorited();
        oResult.setFavorited(bIsFavorited);
        String sMicroContentID = _oSinaStatus.getId();
        oResult.setId(sMicroContentID);
        boolean bIsRetweeted = false;
        Status oRetweetedStatus = _oSinaStatus.getRetweetedStatus();
        if (oRetweetedStatus != null) {
            bIsRetweeted = true;
        }
        oResult.setRetweeted(bIsRetweeted);
        if (bIsRetweeted) {
            if (oRetweetedStatus.getUser() == null || oRetweetedStatus.toString().indexOf("\u62b1\u6b49\uff0c\u6b64\u5fae\u535a\u5df2\u88ab\u4f5c\u8005\u5220\u9664") >= 0) {
                oResult.setRetweetedMicroContent(null);
            } else {
                oResult.setRetweetedMicroContent(SinaObjectUtil.constructMicroContent(oRetweetedStatus));
            }
        } else {
            oResult.setRetweetedMicroContent(null);
        }
        String sSource = null;
        if (_oSinaStatus.getSource() != null) {
            sSource = _oSinaStatus.getSource().getName();
        }
        oResult.setSource(sSource);
        boolean bTruncated = _oSinaStatus.isTruncated();
        oResult.setTruncated(bTruncated);
        MicroUser oMicroUser = null;
        if (_oSinaStatus.getUser() != null) {
            oMicroUser = SinaObjectUtil.constructMicroUser(_oSinaStatus.getUser());
        }
        oResult.setUser(oMicroUser);
        int nRepostCount = _oSinaStatus.getRepostsCount();
        oResult.setRepostCount(nRepostCount);
        return oResult;
    }

    public static MicroContentWrapper constructMicroContentWrapper(StatusWapper _oSinaStatusWapper) throws Exception {
        if (_oSinaStatusWapper == null) {
            return new MicroContentWrapper(new ArrayList<MicroContent>(), 0L);
        }
        long lTotalNumber = _oSinaStatusWapper.getTotalNumber();
        List oSinaStatusList = _oSinaStatusWapper.getStatuses();
        ArrayList<MicroContent> oMicroContentList = new ArrayList<MicroContent>();
        for (int i = 0; i < oSinaStatusList.size(); ++i) {
            Status oTempStatus = (Status)oSinaStatusList.get(i);
            if (oTempStatus == null || oTempStatus.getUser() == null || oTempStatus.getUser().getName() == null) continue;
            try {
                oMicroContentList.add(SinaObjectUtil.constructMicroContent((Status)oSinaStatusList.get(i)));
                continue;
            }
            catch (Exception _oException) {
                throw new Exception("\u6784\u9020MicroContent\u629b\u9519\uff01", _oException);
            }
        }
        return new MicroContentWrapper(oMicroContentList, lTotalNumber);
    }

    public static MicroUser constructMicroUser(User _oSinaUser) throws Exception {
        String sMicroUserID = _oSinaUser.getId();
        String sNickName = _oSinaUser.getScreenName();
        String sDescription = _oSinaUser.getDescription();
        long lFollowerCount = _oSinaUser.getFollowersCount();
        long lFriendsCount = _oSinaUser.getFriendsCount();
        String sHead = _oSinaUser.getavatarLarge();
        long lContentCount = _oSinaUser.getStatusesCount();
        long lFavoriteCount = _oSinaUser.getFavouritesCount();
        int nProvinceCode = _oSinaUser.getProvince();
        int nCityCode = _oSinaUser.getCity();
        String sLocation = _oSinaUser.getLocation();
        boolean bFollowMe = _oSinaUser.isFollowMe();
        boolean bFollowing = _oSinaUser.isFollowing();
        boolean bAllowAllActMsg = _oSinaUser.isallowAllActMsg();
        boolean bAllowAllComment = _oSinaUser.isallowAllComment();
        boolean bIsVIP = _oSinaUser.isVerified();
        boolean bIsMale = true;
        if (_oSinaUser.getGender().equals("f")) {
            bIsMale = false;
        }
        MicroUser oResult = new MicroUser();
        oResult.setId(sMicroUserID);
        oResult.setName(sNickName);
        oResult.setDescription(sDescription);
        oResult.setFollowersCount(lFollowerCount);
        oResult.setFriendsCount(lFriendsCount);
        oResult.setHead(sHead);
        oResult.setMicroContentCount(lContentCount);
        oResult.setFavoritesCount(lFavoriteCount);
        oResult.setProvinceCode(nProvinceCode);
        oResult.setCityCode(nCityCode);
        oResult.setLocation(sLocation);
        oResult.setFollowMe(bFollowMe);
        oResult.setFollowing(bFollowing);
        oResult.setAllowAllActMsg(bAllowAllActMsg);
        oResult.setAllowAllComment(bAllowAllComment);
        oResult.setVip(bIsVIP);
        oResult.setMale(bIsMale);
        return oResult;
    }

    public static Favorite constructMicroFavorites(Favorites _oFavors) throws Exception {
        Favorite oResult = new Favorite();
        Date oDate = _oFavors.getFavoritedTime();
        Status oStatus = _oFavors.getStatus();
        MicroContent oMicroContent = SinaObjectUtil.constructMicroContent(oStatus);
        oResult.setFavoriteTime(oDate);
        oResult.setMicroContent(oMicroContent);
        return oResult;
    }

    public static com.trs.scm.sdk.model.Comment constructMicroComment(Comment _oSinaComment) throws Exception {
        Date oCreateDate = _oSinaComment.getCreatedAt();
        String sCommentId = String.valueOf(_oSinaComment.getId());
        String sContent = _oSinaComment.getText();
        String sSource = _oSinaComment.getSource();
        Comment oSinaReplyComment = _oSinaComment.getReplycomment();
        User oSinaUser = _oSinaComment.getUser();
        Status oSinaStatus = _oSinaComment.getStatus();
        com.trs.scm.sdk.model.Comment oMicroComment = new com.trs.scm.sdk.model.Comment();
        oMicroComment.setCreateDate(oCreateDate);
        oMicroComment.setCommentId(sCommentId);
        oMicroComment.setContent(sContent);
        oMicroComment.setSource(sSource);
        if (oSinaReplyComment != null) {
            oMicroComment.setReplyComment(SinaObjectUtil.constructMicroComment(oSinaReplyComment));
        }
        if (oSinaUser != null) {
            oMicroComment.setUser(SinaObjectUtil.constructMicroUser(oSinaUser));
        }
        if (oSinaStatus != null) {
            oMicroComment.setReplyMicroContent(SinaObjectUtil.constructMicroContent(oSinaStatus));
        }
        return oMicroComment;
    }

    public static CommentWrapper constructMicroCommentWrapper(CommentWapper _oSinaCommentWrapper, int pageIndex, int pageSize) throws Exception {
        long nTotalNumber = _oSinaCommentWrapper.getTotalNumber();
        ArrayList<com.trs.scm.sdk.model.Comment> oMicroCommentList = new ArrayList<com.trs.scm.sdk.model.Comment>();
        for (Comment oSinaComment : _oSinaCommentWrapper.getComments()) {
            try {
                oMicroCommentList.add(SinaObjectUtil.constructMicroComment(oSinaComment));
            }
            catch (Exception _oException) {
                throw new Exception("\u521b\u5efaMicroComment\u65f6\u62a5\u9519", _oException);
            }
        }
        int nListSize = oMicroCommentList.size();
        int nPageCount = (int)(nTotalNumber % (long)pageSize == 0L ? nTotalNumber / (long)pageSize : nTotalNumber / (long)pageSize + 1L);
        if (nListSize < pageSize && nPageCount != pageIndex) {
            nTotalNumber = pageIndex == 1 ? (long)nListSize : (nTotalNumber -= (long)pageSize);
        }
        return new CommentWrapper(oMicroCommentList, nTotalNumber);
    }

    public static Paging constructSinaPaging(int _pageIndex, int _pageSize, ExtraParams _extraParams) throws Exception {
        if (_pageSize < 1 || _pageSize > 70) {
            throw new Exception("\u8f93\u5165\u7684\u9875\u9762\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u9875\u9762\u5927\u5c0f\u8303\u56f4\u4e3a\uff1a1-70\u3002");
        }
        int nPageIndex = _pageIndex;
        int nPageSize = _pageSize;
        if (_pageIndex < 1) {
            nPageIndex = 1;
        }
        return new Paging(nPageIndex, nPageSize);
    }
}

