/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mas;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.video.VSConfig;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.mas.MediaHelper;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.util.HashTable;
import org.apache.log4j.Logger;

public class TagParserForMASS
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(TagParserForMASS.class);

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        String sIds = "";
        String sField = _context.getAttributeTrim("FIELD");
        if (sField != null) {
            IPublishElement publishElement = _context.getUpperHost();
            if (!(publishElement instanceof PublishContentViewDataImpl) && !(publishElement instanceof PublishContentDocumentImpl)) {
                throw new WCMException(200006, "\u5f53\u524dUpperHost\u4e0d\u662fViewData\uff01");
            }
            sIds = publishElement.getSubstance().getPropertyAsString(sField);
        }
        if (CMyString.isEmpty(sIds)) {
            sIds = _context.getAttributeTrim("IDS");
        }
        if (sIds == null || sIds.length() == 0) {
            return null;
        }
        int[] pMasIds = CMyString.splitToInt(sIds, ",");
        String sExcludeIds = this.makeNotCacheIds(_context, pMasIds);
        if (sExcludeIds != null) {
            this.initCache(_context, sExcludeIds);
        }
        return this.makeObjectsFromCache(_context, pMasIds);
    }

    private DefaultObjs makeObjectsFromCache(PublishTagContext _context, int[] _pCachcIds) throws WCMException {
        DefaultObjs objs = new DefaultObjs(null);
        objs.setPageSize(300);
        HashTable hMasObjects = (HashTable)_context.getPageContext().getTaskContext().getCachObject("MASObjects");
        for (int i = 0; i < _pCachcIds.length; ++i) {
            int nMasId = _pCachcIds[i];
            Integer iObjectKey = new Integer(nMasId);
            DefaultObj oValue = (DefaultObj)hMasObjects.get((Object)iObjectKey);
            if (oValue == null) continue;
            objs.addElement(oValue);
        }
        return objs;
    }

    private void initCache(PublishTagContext _context, String _sCacheIds) throws WCMException {
        Map[] pMediaInfo = this.getMediaInfo(_context, _sCacheIds);
        if (pMediaInfo == null) {
            return;
        }
        HashTable hMasObjects = (HashTable)_context.getPageContext().getTaskContext().getCachObject("MASObjects");
        for (int i = 0; i < pMediaInfo.length; ++i) {
            Map hMediaInfo = pMediaInfo[i];
            int nMasId = Integer.parseInt(hMediaInfo.get("masId").toString());
            Integer iObjectKey = new Integer(nMasId);
            Object oValue = hMasObjects.get((Object)iObjectKey);
            if (oValue != null) continue;
            DefaultObj oDefaultObj = new DefaultObj();
            Iterator itKeys = hMediaInfo.keySet().iterator();
            while (itKeys.hasNext()) {
                String sKey = itKeys.next().toString();
                oDefaultObj.setProperty(sKey.toUpperCase(), hMediaInfo.get(sKey), false);
            }
            oDefaultObj.setId(nMasId);
            oDefaultObj.setAddMode(false);
            hMasObjects.put((Object)iObjectKey, (Object)oDefaultObj);
        }
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        return true;
    }

    private String makeNotCacheIds(PublishTagContext _context, int[] _pMasIds) throws WCMException {
        StringBuffer sbNotCacheIds = new StringBuffer();
        for (int i = 0; i < _pMasIds.length; ++i) {
            Integer iObjectKey;
            int nMasId = _pMasIds[i];
            if (nMasId <= 0) continue;
            HashTable hMasObjects = (HashTable)_context.getPageContext().getTaskContext().getCachObject("MASObjects");
            if (hMasObjects == null) {
                hMasObjects = new HashTable();
                _context.getPageContext().getTaskContext().putInCache("MASObjects", hMasObjects);
            }
            if (hMasObjects.get((Object)(iObjectKey = new Integer(nMasId))) != null) continue;
            sbNotCacheIds.append(nMasId);
            sbNotCacheIds.append(',');
        }
        if (sbNotCacheIds.length() <= 0) {
            return null;
        }
        sbNotCacheIds.setLength(sbNotCacheIds.length() - 1);
        return sbNotCacheIds.toString();
    }

    private Map[] getMediaInfo(PublishTagContext _context, String _sMasIds) throws WCMException {
        IPublishElement publishElement = _context.getUpperHost();
        if (!(publishElement instanceof PublishContentViewDataImpl) && !(publishElement instanceof PublishContentDocumentImpl)) {
            throw new WCMException(200006, "\u5f53\u524dUpperHost\u4e0d\u662fViewData\uff01");
        }
        int nDocId = publishElement.getSubstance().getId();
        int nMaxGetCount = _context.getAttribute("MaxGetCount", 4);
        int nMaxGetTime = _context.getAttribute("MaxGetTime", 600);
        String sVideoType = _context.getAttributeTrim("TYPE");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TYPES" + sVideoType));
        }
        if (CMyString.isEmpty(sVideoType)) {
            sVideoType = "vod";
        }
        Map[] pMediaInfo = null;
        String sMasURL = ConfigServer.getServer().getSysConfigValue("MAS_HOST_URL", "http://bbs.trs.net.cn/mas/openapi/pages.do");
        DebugTimer timer = new DebugTimer();
        boolean bSucccess = false;
        for (int i = 0; i < nMaxGetCount; ++i) {
            timer.start();
            try {
                pMediaInfo = MediaHelper.getMediaInfo(sMasURL, VSConfig.getAppKey(), _sMasIds, sVideoType, String.valueOf(nDocId));
                if (pMediaInfo == null) {
                    logger.error((Object)("Fail to get the media[Id=" + _sMasIds + "] info from MAS[" + sMasURL + "]!"));
                    return null;
                }
                timer.stop();
                if (timer.getTime() > (long)nMaxGetTime) {
                    logger.warn((Object)("Get the media[Id=" + _sMasIds + "] info from MAS[" + sMasURL + "] use [" + timer.getTime() + "]ms!"));
                }
                for (int j = 0; j < pMediaInfo.length; ++j) {
                    pMediaInfo[j].put("DOCID", nDocId);
                }
                return pMediaInfo;
            }
            catch (Exception e) {
                logger.error((Object)("Fail to get the media[Id=" + _sMasIds + "] info from MAS[" + sMasURL + "]!"), (Throwable)e);
                timer.stop();
                logger.warn((Object)("Get[" + (i + 1) + "] the media[Id=" + _sMasIds + "] info from MAS[" + sMasURL + "] use [" + timer.getTime() + "]ms!"));
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }
}

