/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CMySign {
    private static final Logger LOG;
    private static final Map INSTANCES;
    private Signature m_signat;
    private Signature m_verify;
    private static final char[] encode_array;
    private static final byte[] decode_array;

    private CMySign() {
    }

    public byte[] decodeRadix64(byte[] inbuf) {
        int size = inbuf.length / 4 * 3;
        if (size == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 46) {
            --size;
            if (inbuf[inbuf.length - 2] == 46) {
                --size;
            }
        }
        byte[] outbuf = new byte[size];
        int inpos = 0;
        int outpos = 0;
        for (size = inbuf.length; size > 0; size -= 4) {
            byte a = decode_array[inbuf[inpos++] & 0xFF];
            byte b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
        }
        return outbuf;
    }

    public String encodeRadix64(byte[] inbuf) {
        if (inbuf.length == 0) {
            return "";
        }
        byte[] outbuf = new byte[(inbuf.length + 2) / 3 * 4];
        int inpos = 0;
        int outpos = 0;
        for (int size = inbuf.length; size > 0; size -= 3) {
            byte c;
            byte b;
            byte a;
            if (size == 1) {
                a = inbuf[inpos++];
                b = 0;
                c = 0;
                outbuf[outpos++] = (byte)encode_array[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)encode_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = 46;
                outbuf[outpos++] = 46;
                continue;
            }
            if (size == 2) {
                a = inbuf[inpos++];
                b = inbuf[inpos++];
                c = 0;
                outbuf[outpos++] = (byte)encode_array[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)encode_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = (byte)encode_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
                outbuf[outpos++] = 46;
                continue;
            }
            a = inbuf[inpos++];
            b = inbuf[inpos++];
            c = inbuf[inpos++];
            outbuf[outpos++] = (byte)encode_array[a >>> 2 & 0x3F];
            outbuf[outpos++] = (byte)encode_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            outbuf[outpos++] = (byte)encode_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            outbuf[outpos++] = (byte)encode_array[c & 0x3F];
        }
        return new String(outbuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMySign getSign(String _sPrivateKey) throws Exception {
        CMySign instance;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Debug Code", (Throwable)new Exception("For call stack inspect."));
            LOG.debug((Object)("Key File: " + _sPrivateKey));
        }
        if ((instance = (CMySign)INSTANCES.get(_sPrivateKey)) == null) {
            InputStream ins = null;
            ByteArrayOutputStream baos = null;
            try {
                ins = new FileService(_sPrivateKey).getInputStream();
                baos = new ByteArrayOutputStream(512);
                int iLength = 0;
                byte[] buff = new byte[512];
                while ((iLength = ins.read(buff)) != -1) {
                    baos.write(buff, 0, iLength);
                }
                buff = baos.toByteArray();
                PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(buff);
                KeyFactory keyf = KeyFactory.getInstance("DSA");
                PrivateKey prikey = keyf.generatePrivate(priPKCS8);
                Signature signature = Signature.getInstance("DSA");
                signature.initSign(prikey);
                instance = new CMySign();
                instance.m_signat = signature;
                INSTANCES.put(_sPrivateKey, instance);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMySign getVerify(String _sPublicKey) throws Exception {
        CMySign instance;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Debug Code", (Throwable)new Exception("For call stack inspect."));
            LOG.debug((Object)("Key File: " + _sPublicKey));
        }
        if ((instance = (CMySign)INSTANCES.get(_sPublicKey)) == null) {
            InputStream ins = null;
            ByteArrayOutputStream baos = null;
            try {
                ins = new FileService(_sPublicKey).getInputStream();
                baos = new ByteArrayOutputStream(512);
                int iLength = 0;
                byte[] buff = new byte[512];
                while ((iLength = ins.read(buff)) != -1) {
                    baos.write(buff, 0, iLength);
                }
                buff = baos.toByteArray();
                X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(buff);
                KeyFactory keyf = KeyFactory.getInstance("DSA");
                PublicKey pubkey = keyf.generatePublic(pubX509);
                Signature signature = Signature.getInstance("DSA");
                signature.initVerify(pubkey);
                instance = new CMySign();
                instance.m_verify = signature;
                INSTANCES.put(_sPublicKey, instance);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(byte[] buff) throws Exception {
        Signature s;
        Signature signature = s = this.m_signat;
        synchronized (signature) {
            s.update(buff);
            return s.sign();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, int iLength) throws Exception {
        Signature v;
        int iOffset = data.length - iLength;
        byte[] sign = new byte[iLength];
        System.arraycopy(data, iOffset, sign, 0, iLength);
        Signature signature = v = this.m_verify;
        synchronized (signature) {
            v.update(data, 0, iOffset - 4);
            return v.verify(sign);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String m_sDataWithSign = "";
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            CMySign su = CMySign.getSign("/f:/private_platform_log.key");
            bos = new ByteArrayOutputStream(512);
            dos = new DataOutputStream(bos);
            ((DataOutputStream)dos).writeInt(1);
            ((DataOutputStream)dos).writeUTF("admin");
            ((DataOutputStream)dos).writeUTF("fuck&damn&fuck");
            ((DataOutputStream)dos).flush();
            byte[] buff = su.sign(bos.toByteArray());
            ((DataOutputStream)dos).writeInt(buff.length);
            dos.write(buff);
            ((DataOutputStream)dos).flush();
            m_sDataWithSign = su.encodeRadix64(bos.toByteArray());
            System.out.println("m_sDataWithSign:" + m_sDataWithSign);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ex) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception ex) {}
            }
        }
        try {
            m_sDataWithSign = "AAAAAQAFYWRtaW4ADmZ1Y2smZGFtbiZmdWNrAAAALzAtAhUAhKx4_Y46slqXWrpAwo41o7R5v44CFFqciKKysJislreuU9hQWz72U1Mj";
            byte[] buff = m_sDataWithSign.getBytes();
            CMySign verify = CMySign.getVerify("/f:/public_platform_log.key");
            buff = verify.decodeRadix64(buff);
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
            System.out.println(is.readInt());
            System.out.println(is.readUTF());
            System.out.println(is.readUTF());
            int len = is.readInt();
            System.out.println(len);
            if (!verify.verify(buff, len)) {
                System.out.println("sign error");
            } else {
                System.out.println("Verify true");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(System.getProperty("file.encoding", "dd"));
        System.out.println(CMySign.createEncodeUserInfo("/f:/private_platform_log.key", "zengrong&true&zengrong"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createEncodeUserInfo(String _sPrivateKeyFile, String _sParam) {
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            String sDataWithSign;
            CMySign su = CMySign.getSign(_sPrivateKeyFile);
            bos = new ByteArrayOutputStream(1024);
            dos = new DataOutputStream(bos);
            ((DataOutputStream)dos).writeInt(1);
            ((DataOutputStream)dos).writeUTF("admin");
            String param = CMyString.showEmpty(_sParam);
            ((DataOutputStream)dos).writeUTF(param);
            ((DataOutputStream)dos).flush();
            byte[] buff = su.sign(bos.toByteArray());
            ((DataOutputStream)dos).writeInt(buff.length);
            dos.write(buff);
            ((DataOutputStream)dos).flush();
            String string = sDataWithSign = su.encodeRadix64(bos.toByteArray());
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception exception) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    static {
        int i;
        LOG = Logger.getLogger(CMySign.class);
        INSTANCES = new HashMap(4);
        encode_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        decode_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            CMySign.decode_array[i] = -1;
        }
        for (i = 0; i < encode_array.length; ++i) {
            CMySign.decode_array[CMySign.encode_array[i]] = (byte)i;
        }
    }
}

