/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.ExceptionNumber;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CMyException
extends Exception {
    protected int errNo = 0;
    protected Throwable rootCause = null;

    public CMyException(int _errNo) {
        this.errNo = _errNo;
    }

    public CMyException(int _errNo, String _sMsg) {
        super(_sMsg);
        this.errNo = _errNo;
    }

    public CMyException(String _sMsg) {
        super(_sMsg);
    }

    public CMyException(int _errNo, String _sMsg, Throwable _rootCause) {
        super(_sMsg);
        this.errNo = _errNo;
        this.rootCause = _rootCause;
    }

    public CMyException(String _sMsg, Throwable _rootCause) {
        super(_sMsg);
        this.rootCause = _rootCause;
    }

    public int getErrNo() {
        return this.errNo;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getErrNoMsg() {
        return ExceptionNumber.getErrNoMsg(this.errNo);
    }

    public String getMyMessage() {
        return super.getMessage();
    }

    @Override
    public String toString() {
        String sMessage = "[ERR-" + this.errNo + "] " + this.getMyMessage();
        return sMessage;
    }

    @Override
    public String getMessage() {
        String sMessage = this.toString();
        if (this.rootCause != null) {
            sMessage = sMessage + "\r\n<-- " + this.rootCause.toString();
        }
        return sMessage;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream _ps) {
        if (this.rootCause == null) {
            super.printStackTrace(_ps);
        } else {
            Throwable root = this.rootCause;
            PrintStream printStream = _ps;
            synchronized (printStream) {
                _ps.println(this.toString());
                Throwable temp = null;
                while (root instanceof CMyException) {
                    _ps.println("<-- " + root.toString());
                    temp = root;
                    if ((root = ((CMyException)root).getRootCause()) != null) continue;
                    temp.printStackTrace(_ps);
                    break;
                }
                if (root != null) {
                    _ps.print("<-- ");
                    root.printStackTrace(_ps);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter _pw) {
        if (this.rootCause == null) {
            super.printStackTrace(_pw);
        } else {
            Throwable root = this.rootCause;
            PrintWriter printWriter = _pw;
            synchronized (printWriter) {
                _pw.println(this.toString());
                Throwable preRoot = null;
                while (root instanceof CMyException) {
                    _pw.print("<-- ");
                    preRoot = root;
                    root = ((CMyException)root).getRootCause();
                    if (root == null) {
                        preRoot.printStackTrace(_pw);
                        break;
                    }
                    _pw.println(preRoot.toString());
                }
                if (root != null) {
                    _pw.print("<-- ");
                    root.printStackTrace(_pw);
                }
            }
        }
    }

    public String getStackTraceText() {
        return CMyException.getStackTraceText(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceText(Throwable _ex) {
        StringWriter strWriter = null;
        PrintWriter prtWriter = null;
        try {
            strWriter = new StringWriter();
            prtWriter = new PrintWriter(strWriter);
            _ex.printStackTrace(prtWriter);
            prtWriter.flush();
            String string = strWriter.toString();
            return string;
        }
        catch (Exception ex2) {
            String string = _ex.getMessage();
            return string;
        }
        finally {
            if (strWriter != null) {
                try {
                    strWriter.close();
                }
                catch (Exception exception) {}
            }
            if (prtWriter != null) {
                try {
                    prtWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final void main(String[] args) {
        CMyException fire0 = new CMyException(1, "my exception 0");
        CMyException fire = new CMyException(1, "my exception 1", fire0);
        CMyException fire2 = new CMyException(10, "my exception 2", fire);
        fire2.printStackTrace(System.out);
        System.out.println("-------------------");
        System.out.println(fire2.getMessage());
        System.out.println("-------------------");
        System.out.println(fire2.getStackTraceText());
        try {
            int a = 0;
            int b = 1 / a;
            System.out.println(b);
        }
        catch (Exception ex) {
            System.out.println(CMyException.getStackTraceText(ex));
        }
    }
}

