/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class AttributesString {
    public static final String ATTRIBUTE_DELIM = "&";
    private HashMap m_hAttributesMap = null;
    private ArrayList m_arNameList = null;
    private String m_sDelim = null;

    public AttributesString() {
    }

    public AttributesString(String _attributes) {
        this.setAttributes(_attributes);
    }

    public String toString() {
        return this.getAttributes();
    }

    public String getAttributes() {
        int nCount = this.getNameList().size();
        if (nCount == 0) {
            return null;
        }
        String sRet = "";
        for (int i = 0; i < nCount; ++i) {
            if (i > 0) {
                sRet = sRet + this.getDelim();
            }
            sRet = sRet + this.getAttribute((String)this.getNameList().get(i));
        }
        return sRet;
    }

    public void setAttributes(String _attributes) {
        if (_attributes == null) {
            return;
        }
        this.clear();
        StringTokenizer stAttributes = null;
        stAttributes = new StringTokenizer(_attributes, this.getDelim());
        while (stAttributes.hasMoreElements()) {
            String sTemp = stAttributes.nextToken();
            int nPose = sTemp.indexOf("=");
            if (nPose <= 0) continue;
            String sName = sTemp.substring(0, nPose);
            String sValue = sTemp.substring(nPose + 1);
            this.putAttributeValue(sName, sValue, true);
        }
    }

    public String getAttributeValue(String _sName) {
        Object oValue = this.getValue(_sName = _sName.toUpperCase());
        if (oValue == null) {
            return null;
        }
        if (oValue instanceof String) {
            return (String)oValue;
        }
        if (oValue instanceof String[]) {
            String[] arTemp = (String[])oValue;
            return arTemp[0];
        }
        return null;
    }

    public String[] getAttributeValues(String _sName) {
        Object oValue = this.getValue(_sName = _sName.toUpperCase());
        if (oValue == null) {
            return null;
        }
        String[] arTemp = null;
        if (oValue instanceof String) {
            arTemp = new String[]{(String)oValue};
        }
        if (oValue instanceof String[]) {
            arTemp = (String[])oValue;
        }
        return arTemp;
    }

    private String getAttribute(String _sName) {
        String sName = _sName.toUpperCase();
        Object oValue = this.getValue(sName);
        if (oValue == null) {
            return null;
        }
        if (oValue instanceof String) {
            return _sName + "=" + (String)oValue;
        }
        if (oValue instanceof String[]) {
            String[] arTemp = (String[])oValue;
            String sTemp = "";
            for (int i = 0; i < arTemp.length; ++i) {
                if (i > 0) {
                    sTemp = sTemp + this.getDelim();
                }
                sTemp = sTemp + _sName + "=" + arTemp[i];
            }
            return sTemp;
        }
        return null;
    }

    public void putAttributeValue(String _name, String _value) {
        this.putAttributeValue(_name, _value, false);
    }

    public HashMap getAttributesMap() {
        if (this.m_hAttributesMap == null) {
            this.m_hAttributesMap = new HashMap(5);
        }
        return this.m_hAttributesMap;
    }

    protected void clear() {
        if (this.m_hAttributesMap == null) {
            return;
        }
        this.m_arNameList.clear();
        this.m_hAttributesMap.clear();
        this.m_hAttributesMap = null;
    }

    private Object getValue(String _sName) {
        _sName = _sName.toUpperCase();
        return this.getAttributesMap().get(_sName);
    }

    public void putAttributeValue(String _sName, String _sValue, boolean _bAllowMultValue) {
        String sName = _sName.toUpperCase();
        Object oValue = this.getValue(sName);
        if (oValue == null) {
            this.getAttributesMap().put(sName, _sValue);
            this.getNameList().add(_sName);
            return;
        }
        if (!_bAllowMultValue) {
            this.getAttributesMap().put(sName, _sValue);
            return;
        }
        String[] arValue = null;
        if (oValue instanceof String) {
            arValue = new String[]{(String)oValue, _sValue};
        }
        if (oValue instanceof String[]) {
            String[] arTemp = (String[])oValue;
            arValue = new String[arTemp.length + 1];
            for (int i = 0; i < arTemp.length; ++i) {
                arValue[i] = arTemp[i];
            }
            arValue[arTemp.length] = _sValue;
        }
        if (arValue != null) {
            this.getAttributesMap().put(sName, arValue);
        }
    }

    public List getNameList() {
        if (this.m_arNameList == null) {
            this.m_arNameList = new ArrayList(5);
        }
        return this.m_arNameList;
    }

    public String getDelim() {
        if (this.m_sDelim == null) {
            return ATTRIBUTE_DELIM;
        }
        return this.m_sDelim;
    }

    public void setDelim(String delim) {
        this.m_sDelim = delim;
    }

    public int size() {
        if (this.m_arNameList == null) {
            return 0;
        }
        return this.getNameList().size();
    }

    public boolean containsName(String _sName) {
        if (_sName == null) {
            return false;
        }
        return this.getAttributesMap().containsKey(_sName.toUpperCase());
    }

    public String getNameAt(int _nIndex) {
        return (String)this.getNameList().get(_nIndex);
    }

    public static void main(String[] args) {
        AttributesString aAttributesString = new AttributesString("a=1&b=2&c=3");
        System.out.println("a=" + aAttributesString.getAttributeValue("a"));
        System.out.println("b=" + aAttributesString.getAttributeValue("b"));
        System.out.println("c=" + aAttributesString.getAttributeValue("c"));
        System.out.println("Attributelist:" + aAttributesString.getAttributes());
        System.out.println("Test for pub attribute value:");
        aAttributesString.putAttributeValue("b", "22");
        aAttributesString.putAttributeValue("d", "4");
        System.out.println("Attributelist:" + aAttributesString.getAttributes());
    }
}

