/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange;

import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;

public class DataMigrationLogger {
    private static Logger logger = Logger.getLogger(DataMigrationLogger.class);
    private String m_sLogFileName = null;
    private String m_sCharset = "UTF-8";
    private static final String CHANNEL_START = "Begin Migration Channel to [";
    private static final String CHANNEL_END = "End Migration Channel to [";
    private static final String GROUP_START = "Begin Migration Group to [";
    private static final String GROUP_END = "End Migration Group to [";
    private static final String DATA_START = "Begin Migration Data [";
    private static final String DATA_END = "End Migration Data [";
    private static final String FLAG_LOG = "[ExchangeLog]";

    public DataMigrationLogger(String _sSrcNameOfDB, int _loggerNumId) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sLogFilePath = filesMan.getPathConfigValue("N0", 0);
        sLogFilePath = CMyString.setStrEndWith(sLogFilePath, File.separatorChar);
        this.m_sLogFileName = sLogFilePath + "exchange_" + _sSrcNameOfDB + "_" + _loggerNumId + ".log";
        PatternLayout layout = new PatternLayout("[ExchangeLog]%m - %d - %-5p %x  - %c%l -%-4r [%t] %n");
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)new FileOutputStream(this.m_sLogFileName, true));
        appender.setEncoding(this.m_sCharset);
        logger.removeAllAppenders();
        logger.addAppender((Appender)appender);
        System.out.println("Log File:" + this.m_sLogFileName);
    }

    public void recordStartChannel(int _nChannelId) {
        this.record(CHANNEL_START, _nChannelId);
    }

    public void recordEndChannel(int _nChannelId) {
        this.record(CHANNEL_END, _nChannelId);
    }

    public void recordStartGroup(int groupId) {
        this.record(GROUP_START, groupId);
    }

    public void recordEndGroup(int groupId) {
        this.record(GROUP_END, groupId);
    }

    public void recordStartData(int _nDataId, int releaseDoc, int papperDoc) {
        this.recordDoc(DATA_START, _nDataId, releaseDoc, papperDoc);
    }

    public void recordEndData(int _nDataId, int releaseDoc, int papperDoc) {
        this.recordDoc(DATA_END, _nDataId, releaseDoc, papperDoc);
    }

    public void recordApp(int nNum, int metadataId, int nFromId, String sName) {
        logger.info((Object)("\u7b2c" + nNum + "\u6761\u6570\u636e::metadataId:" + metadataId + ";FromId:" + nFromId + ";MetaLogoUrl:" + sName));
    }

    public void recordDoc(String _sLogPre, int _nId, int release, int paper) {
        logger.info((Object)(_sLogPre + _nId + "]{\u65b0\u5efa\u641e:" + release + ",\u62a5\u7eb8\uff1a" + paper + "}"));
    }

    public void recordStartShare(int _nDataId, int releaseDoc, int papperDoc) {
        this.recordShare(DATA_START, _nDataId, releaseDoc, papperDoc);
    }

    public void recordShare(String _sLogPre, int _nId, int release, int paper) {
        logger.info((Object)(_sLogPre + _nId + "]{\u65b0\u5efa\u641edocId:" + release + ",docShareRel\u7684id\uff1a" + paper + "}"));
    }

    public void shareWarn(int cbNewsId) {
        logger.warn((Object)(DATA_START + cbNewsId + "]{\u6d59\u6c5f\u65e5\u62a5\u65b0\u5efa\u7a3f\u4ef6\u8fc1\u79fbsql\u627e\u4e0d\u5230\u8fd9\u6761\u8bb0\u5f55}"));
    }

    public void recordUserNews(int newsId, String sqlUserName) {
        this.recordUser(DATA_START, newsId, sqlUserName);
    }

    public void recordUserGroup(int newsId) {
        this.recordUserGroup(DATA_START, newsId);
    }

    public void recordUserGroup(String _sLogPre, int _nId) {
        logger.info((Object)(_sLogPre + _nId + "]{\u521b\u5efa\u8005\u6240\u5728\u7684\u90e8\u95e8\u4e0d\u5728wcm}"));
    }

    public void recordUser(String _sLogPre, int _nId, String sqlUserName) {
        logger.info((Object)(_sLogPre + _nId + "]{\u521b\u5efa\u8005" + sqlUserName + "\u4e0d\u5728wcm}"));
    }

    public void recordChannelNews(int newsId) {
        this.recordChannel(DATA_START, newsId);
    }

    public void recordStartData(int _nDataId) {
        this.record(DATA_START, _nDataId);
    }

    public void recordEndData(int _nDataId) {
        this.record(DATA_END, _nDataId);
    }

    public void recordStartNews(int _nDataId, int isTopic, String templateFile, String user) {
        this.recordNews(DATA_END, _nDataId, isTopic, templateFile, user);
    }

    public void recordTodayChannelNews(int newsId) {
        this.recordChannel(DATA_START, newsId);
    }

    public void recordChannel(String _sLogPre, int _nId) {
        logger.info((Object)(_sLogPre + _nId + "]{\u7248\u9762\u4e0d\u5728wcm}"));
    }

    public void recordEndNews(int _nDataId) {
        this.record(DATA_END, _nDataId);
    }

    public void recordNews(String _sLogPre, int _nId, int isTopic, String templateFile, String user) {
        if ("admin".equals(user)) {
            logger.info((Object)(_sLogPre + _nId + "]{Topic:" + isTopic + ",TemplateFile:" + templateFile + ",Cruser:\u4e0d\u5b58\u5728}"));
        } else {
            logger.info((Object)(_sLogPre + _nId + "]{Topic:" + isTopic + ",TemplateFile:" + templateFile + "}"));
        }
    }

    public void NewsArticles(int nNewsId) {
        logger.info((Object)("Id\u4e3a\uff1a" + nNewsId + "\u7684\u65b0\u5efa\u7a3f\u4ef6\u6ca1\u6709\u627e\u5230\u6240\u5c5e\u680f\u76ee"));
    }

    public void ReleatedNews(String nNewsId) {
        logger.info((Object)("Id\u4e3a\uff1a" + nNewsId + "\u7684\u76f8\u5173\u65b0\u95fb\u8d85\u957f"));
    }

    public void ReleatedNews1(String nNewsId, String sRelNews) {
        logger.info((Object)("Id\u4e3a\uff1a" + nNewsId + "\u7684\u76f8\u5173\u65b0\u95fb:" + sRelNews));
    }

    public void Abstract(String nNewsId) {
        logger.info((Object)("Id\u4e3a\uff1a" + nNewsId + "\u7684\u6458\u8981\u8d85\u957f"));
    }

    public void SavedArticles(int nNewsId) {
        logger.info((Object)("sourceId\u4e3a\uff1a" + nNewsId + "\u7684\u65b0\u5efa\u7a3f\u4ef6\u5df2\u5b58\u5728"));
    }

    public void record(String _sLogPre, int _nId) {
        logger.info((Object)(_sLogPre + _nId + "]"));
    }

    public void NewsArticles(String nNewsId) {
        logger.info((Object)("UserName\u4e3a\uff1a" + nNewsId + "\u7684\u65b0\u5efa\u7a3f\u4ef6\u6ca1\u6709\u627e\u5230\u6240\u5c5e\u680f\u76ee"));
    }

    public void StartArticles(int nNewsId) {
        logger.info((Object)("sourceId\u4e3a\uff1a" + nNewsId + "\u7684\u65b0\u5efa\u7a3f\u4ef6\u5f00\u59cb\u8fc1\u79fb"));
    }

    public void StartPics(int nNewsId) {
        logger.info((Object)("fromId\u4e3a\uff1a" + nNewsId + "\u7684\u7a3f\u4ef6\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25\uff01"));
    }

    public void ZjolPic(String nNewsId) {
        logger.info((Object)("NewsId\u4e3a\uff1a" + nNewsId + "\u7684\u7a3f\u4ef6\u6ca1\u6709\u9644\u4ef6\u56fe\u7247"));
    }

    public void ZjolChannel(String nNewsId) {
        logger.info((Object)("NewsId\u4e3a\uff1a" + nNewsId + "\u7684\u680f\u76ee\u91cd\u540d"));
    }

    public int readLastInfo() throws Exception {
        if (!CMyFile.fileExists(this.m_sLogFileName)) {
            return 0;
        }
        RandomAccessFile rf = null;
        try {
            rf = new RandomAccessFile(this.m_sLogFileName, "r");
            long len = rf.length();
            long start = rf.getFilePointer();
            long nextend = start + len - 1L;
            int c = -1;
            while (nextend >= start) {
                rf.seek(nextend);
                c = rf.read();
                if (c != 10 && c != 13 && c != 32) {
                    --nextend;
                    continue;
                }
                rf.seek(--nextend);
                c = rf.read();
                String line = "";
                while (c != 10 && c != 13) {
                    line = (char)c + line;
                    if (nextend == 0L) break;
                    rf.seek(--nextend);
                    c = rf.read();
                }
                if (line == null || !line.startsWith(FLAG_LOG)) continue;
                line = line.substring(FLAG_LOG.length());
                if ((line = new String(line.getBytes(), this.m_sCharset).trim()).startsWith(CHANNEL_START)) {
                    int n = 0;
                    return n;
                }
                if (line.startsWith(CHANNEL_END)) {
                    int n = -1;
                    return n;
                }
                if (line.startsWith(GROUP_START)) {
                    int n = 0;
                    return n;
                }
                if (line.startsWith(GROUP_END)) {
                    int n = -1;
                    return n;
                }
                if (line.startsWith(DATA_START)) {
                    int nPos = line.indexOf(93, DATA_START.length());
                    String sTemp = line.substring(DATA_START.length(), nPos).trim();
                    int n = Integer.parseInt(sTemp);
                    return n;
                }
                if (line.startsWith(DATA_END)) {
                    int nPos = line.indexOf(93, DATA_END.length());
                    String sTemp = line.substring(DATA_END.length(), nPos).trim();
                    int n = Integer.parseInt(sTemp) + 1;
                    return n;
                }
                throw new Exception("\u03b4\u05aa\ufffd\ufffd\ufffd\ufffd\u05be[content=" + line + "]");
            }
        }
        catch (Exception e) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\u05be\ufffd\u013c\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ucce3![" + this.m_sLogFileName + "]", e);
        }
        finally {
            try {
                if (rf != null) {
                    rf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

