/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.soap;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.soap.encoding.soapenc.Base64;

public class WordFileService {
    private static String s_sValidFileExts = null;

    private static boolean isValidFileExt(String _sFileExt) {
        if (_sFileExt == null || _sFileExt.trim().length() <= 0) {
            return false;
        }
        return WordFileService.getValidFileExts().indexOf(";" + _sFileExt.trim().toUpperCase() + ";") >= 0;
    }

    private static String getAbsoluteFileByXMLStr(byte[] _pXMLByte) {
        return WordFileService.getAbsoluteFileByXMLStr(new String(_pXMLByte));
    }

    private static String getAbsoluteFileByXMLStr(String _sXML) {
        if (_sXML == null || _sXML.length() <= 0) {
            return "";
        }
        String sStartFlag = "";
        sStartFlag = "<FULL_PATH>";
        int lStartPos = _sXML.indexOf(sStartFlag);
        if (lStartPos < 0) {
            return "";
        }
        int lEndPos = _sXML.indexOf("</FULL_PATH>", lStartPos);
        if (lEndPos < 0) {
            return "";
        }
        return _sXML.substring(lStartPos + sStartFlag.length(), lEndPos);
    }

    public static String sendFileBase64(String strData, String Server, String fileExt) throws IOException {
        return WordFileService.receiveFileByBase64(strData, Server, fileExt);
    }

    public static String receiveFileByBase64(String strData, String Server, String fileExt) throws IOException {
        return WordFileService.receiveFileByBytes(Base64.decode((String)strData), Server, fileExt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String receiveFileByBytes(byte[] _pData, String Server, String fileExt) throws IOException {
        if (!WordFileService.isValidFileExt(fileExt)) {
            System.out.println(I18NMessage.get(WordFileService.class, "WordFileService.label1", "\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff01\u6587\u4ef6\u540d[") + fileExt + I18NMessage.get(WordFileService.class, "WordFileService.label2", "]\u975e\u6cd5\uff01"));
            return "";
        }
        String strFilePathName = "";
        OutputStream fos = null;
        InputStream is = null;
        try {
            byte[] buffer = new byte[1024];
            URL url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Server))).append("/wcm/doc/soap/getnextfile.jsp?fileExt=").append(fileExt))));
            is = url.openStream();
            while (is.read(buffer, 0, buffer.length) != -1) {
                strFilePathName = WordFileService.getAbsoluteFileByXMLStr(buffer);
            }
            fos = new FileService(strFilePathName).getOutputStream();
            fos.write(_pData);
        }
        catch (IOException ex) {
            System.out.println(I18NMessage.get(WordFileService.class, "WordFileService.label3", "\u83b7\u53d6\u6709\u6548\u7684\u6587\u4ef6\u540d\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return WordFileService.extractFileName(strFilePathName);
    }

    private static String extractFileName(String _sFilePathName) {
        int nPos = _sFilePathName.lastIndexOf(File.separatorChar);
        return _sFilePathName.substring(nPos + 1);
    }

    public static String getValidFileExts() {
        return s_sValidFileExts;
    }

    public static void setValidFileExts(String _fileExts) {
        if (_fileExts == null || _fileExts.trim().length() <= 0) {
            return;
        }
        if ((_fileExts = _fileExts.trim()).charAt(_fileExts.length() - 1) != ';') {
            _fileExts = _fileExts + ';';
        }
        if (_fileExts.charAt(0) != ';') {
            _fileExts = ';' + _fileExts;
        }
        s_sValidFileExts = _fileExts;
    }

    static {
        s_sValidFileExts = ";GIF;JPG;JPEG;BMP;PNG;MHT;DOC;ZIP;";
    }
}

