/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.DocKinds;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class DocKind
extends CMSObj {
    public static final int OBJ_TYPE = 602;
    public static final String DB_TABLE_NAME = "WCMDOCKIND";
    public static final String DB_ID_NAME = "DOCKINDID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 602;
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public DocKind getParent() throws WCMException {
        return DocKind.findById(this.getParentId());
    }

    public boolean setParent(int _parentId) throws WCMException {
        return this.setProperty("PARENTID", _parentId);
    }

    public boolean setParent(DocKind _parent) throws WCMException {
        if (_parent == null || !_parent.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(DocKind.class, "DocKind.label1", "\u65e0\u6548\u7684\u7236\u7c7b\u522b\u5bf9\u8c61(DocKind.setParent)"));
        }
        return this.setParent(_parent.getId());
    }

    public int getGrade() {
        return this.getPropertyAsInt("GRADE", 0);
    }

    public String getCode() {
        return (String)this.getProperty("CODE");
    }

    public boolean setCode(String _code) throws WCMException {
        return this.setProperty("CODE", _code);
    }

    public String getName() {
        return (String)this.getProperty("DOCKINDNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("DOCKINDNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("DOCKINDDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("DOCKINDDESC", _desc);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("DOCKINDNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(DocKind.class, "DocKind.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(DocKind.isValid)"));
            }
            if (this.getProperty("PARENTID") == null) {
                throw new WCMException(1106, I18NMessage.get(DocKind.class, "DocKind.label3", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e(DocKind.isValid)"));
            }
            if (this.getProperty("CODE") == null) {
                throw new WCMException(1106, I18NMessage.get(DocKind.class, "DocKind.label4", "\u5c5e\u6027Code\u6ca1\u6709\u8bbe\u7f6e(DocKind.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(DocKind.class, "DocKind.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(DocKind.isValid)"));
            }
            sName = (String)this.getNewProperty("DOCKINDNAME");
        }
        if (sName != null) {
            String strCondition = "ParentId=" + this.getParentId() + " and DocKindName='" + CMyString.filterForSQL(sName) + "'";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(DocKind.class, "DocKind.label6", "\u7c7b\u522b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08DocKind.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            int nParentId = this.getParentId();
            int nGrade = 0;
            if (nParentId > 0) {
                DocKind parent = DocKind.findById(nParentId);
                nGrade = parent.getGrade() + 1;
            }
            this.setProperty("GRADE", nGrade);
            super.insert(_currUser);
        }
    }

    public DocKinds getChildren(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=" + this.getId(), "");
        DocKinds docKinds = new DocKinds(_currUser);
        try {
            docKinds.open(filter);
            return docKinds;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(DocKind.class, "DocKind.label7", "\u83b7\u53d6\u5b50\u7c7b\u522b\u96c6\u5408\u65f6\u5931\u8d25\uff08DocKind.getChildren\uff09"), ex);
        }
    }

    public static final DocKind findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (DocKind)BaseObj.findById(DocKind.class, _nId);
    }

    public static final DocKind createNewInstance() throws WCMException {
        return (DocKind)BaseObj.createNewInstance(DocKind.class);
    }

    public static final DocKind findByKey(Object _oKey) throws WCMException {
        return (DocKind)BaseObj.findByKey(DocKind.class, _oKey);
    }
}

