/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import java.io.File;
import org.apache.log4j.Logger;

public class TagSSIParser
implements ITagParser {
    private static final Logger LOG = Logger.getLogger(TagSSIParser.class);

    public void clear() {
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        TagBeanInfo tbi = new TagBeanInfo();
        tbi.setName("TRS_SSI");
        tbi.setDesc("SSI\u5d4c\u5165");
        tbi.setType(TagBeanInfo.BodyType.IGNORE);
        TagBeanAttrInfo tbai = new TagBeanAttrInfo();
        tbai.setName("ID");
        tbai.setDesc("\u5d4c\u5165\u7684\u680f\u76eeID");
        tbai.setRequired(true);
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("TEMPLATENAME");
        tbai.setDesc("\u6a21\u677f\u540d\u79f0,\u53d6\u76f8\u5e94\u6a21\u677f\u5bf9\u5e94\u7684\u9875\u9762\u5730\u5740");
        tbai.setDefaultValue("");
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("TARGET");
        tbai.setDesc("\u5185\u5bb9\u5bb9\u5668ID");
        tbai.setDefaultValue("");
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("JQUERY");
        tbai.setDesc("\u4f7f\u7528jquery\u8bf7\u6c42");
        tbai.setDefaultValue("false");
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("URLISABS");
        tbai.setDesc("\u662f\u5426\u663e\u793a\u7edd\u5bf9\u8def\u5f84");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setEnumValue(new String[]{"true", "false"});
        tbai.setDefaultValue("false");
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("PATHTYPE");
        tbai.setDesc("\u663e\u793a\u8def\u5f84\u7684\u65b9\u5f0f");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue("virtual");
        tbi.addAttrInfo(tbai);
        return tbi;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String url;
        String target = _context.getAttributeTrim("TARGET");
        String jquery = _context.getAttribute("JQUERY");
        String templateName = _context.getAttributeTrim("TEMPLATENAME");
        String channelID = _context.getAttributeTrim("ID");
        String sPathType = _context.getAttribute("PATHTYPE");
        if (!"virtual".equalsIgnoreCase(sPathType) && !"file".equalsIgnoreCase(sPathType)) {
            sPathType = "virtual";
        }
        if (jquery == null) {
            jquery = "false";
        }
        if (channelID == null || CMyString.isEmpty(channelID)) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Invalid channel id!");
            }
            return null;
        }
        TagItem tagItem = _context.getTagItem();
        BaseChannel oIncludeChannel = WCMTagParserHelper.findFolderHost(tagItem, _context, true, true);
        WebSite site = null;
        site = oIncludeChannel.isSite() ? (WebSite)oIncludeChannel : oIncludeChannel.getSite();
        if (oIncludeChannel == null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Channel with ID[" + channelID + "]cann't be found!"));
            }
            return null;
        }
        if (oIncludeChannel.isDeleted()) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Channel with ID[" + channelID + "]has been deleted!"));
            }
            return null;
        }
        IPublishFolder oIncludeFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(oIncludeChannel);
        if (oIncludeFolder.isLink()) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Can not include a link folder: No content in it.");
            }
            return null;
        }
        Templates templates = oIncludeFolder.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Channel with ID[" + channelID + "] have no templates!"));
            }
            return null;
        }
        StringBuffer strBuffer = new StringBuffer(256);
        PublishPathCompass compass = _context.getPathCompass();
        StringBuffer sFileName = new StringBuffer();
        try {
            if (_context.isPreview()) {
                url = compass.getPreviewHttpPath(oIncludeFolder);
            } else {
                String sPageHttpPath = _context.getPageHttpPath();
                url = compass.getAbsoluteHttpPath(oIncludeFolder);
                url = CMyString.setStrEndWith(url, '/');
                boolean bAbsURL = _context.getAttribute("URLISABS", false);
                if (!bAbsURL) {
                    url = HtmlUtil.calRelativePath(url, sPageHttpPath);
                }
            }
            strBuffer.append(url);
            Template template = null;
            ConfigServer server = ConfigServer.getServer();
            boolean zDefault = true;
            boolean zNameByFile = "true".equalsIgnoreCase(server.getSysConfigValue("NAME_BY_TEMPLATE_FILE", ""));
            if (CMyString.isEmpty(templateName) || templates.size() == 1) {
                template = (Template)templates.getAt(0);
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Channel with ID[" + channelID + "] don't have template[" + templateName + "]! Default Template has been used!"));
                }
            } else {
                int size = templates.size();
                for (int i = 0; i < size; ++i) {
                    Template t = (Template)templates.getAt(i);
                    if (t == null || !t.getName().equals(templateName)) continue;
                    template = t;
                    zDefault = false;
                    break;
                }
                if (template == null) {
                    template = (Template)templates.getAt(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Object)("Channel with ID[" + channelID + "] don't have template[" + templateName + "]! Default Template has been used!"));
                    }
                }
            }
            sFileName.append(template.getOutputFileName());
            if (!zDefault && !zNameByFile) {
                sFileName.append('_').append(template.getId());
            }
            sFileName.append('.').append(template.getOutputFileExt());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("include file: " + sFileName.toString()));
            }
            strBuffer.append(sFileName);
            url = strBuffer.toString();
            strBuffer.setLength(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<fileURL>" + url));
            }
            if (_context.isPreview()) {
                String[] pWarning = new String[1];
                PublishServer.getInstance().previewFolder(oIncludeFolder, pWarning, template);
                if (LOG.isDebugEnabled() && pWarning[0] != null) {
                    LOG.warn((Object)("Channel ID[" + channelID + "] with template[" + templateName + "]! cannot Preview!the Warning info is :" + pWarning[0]));
                }
            } else {
                String sPubPath = compass.getLocalPath(oIncludeFolder, false);
                sPubPath = CMyString.setStrEndWith(sPubPath, File.separatorChar);
                String sPubFilePath = sPubPath + sFileName;
                LOG.debug((Object)("sPubFilePath is  : " + sPubFilePath));
                if (!new FileService(sPubFilePath).isFile() && oIncludeFolder.validateCanDoPub()) {
                    PublishServer.getInstance().publishFolder(oIncludeFolder, 8);
                }
            }
        }
        finally {
            compass.clear();
        }
        boolean isJquery = "true".equalsIgnoreCase(jquery);
        if (isJquery) {
            if (!CMyString.isEmpty(target)) {
                strBuffer.append("<script>try{");
                strBuffer.append("$(document).ready(function(){$('#");
                strBuffer.append(target).append("').load('");
                strBuffer.append(url);
                strBuffer.append("?'+Math.random())});");
                strBuffer.append("}catch(e){}</script>");
            }
        } else if (!CMyString.isEmpty(target)) {
            String fakeid = "trsfake_" + target;
            strBuffer.append("<div id='");
            strBuffer.append(fakeid);
            strBuffer.append("' style='display:none'>");
            strBuffer.append("<!--#include " + sPathType + "=\"");
            strBuffer.append(url);
            strBuffer.append("\"-->");
            strBuffer.append("</div>");
            strBuffer.append("<script>(function(){try{");
            strBuffer.append("var e=document.getElementById('");
            strBuffer.append(target).append("');");
            strBuffer.append("if(e){e.innerHTML=document.getElementById('");
            strBuffer.append(fakeid);
            strBuffer.append("').innerHTML;}");
            strBuffer.append("}catch(e){}})()</script>");
        } else {
            strBuffer.append("<!--#include " + sPathType + "=\"");
            strBuffer.append(url);
            strBuffer.append("\"-->");
        }
        if (strBuffer.length() > 0) {
            return new String[]{strBuffer.toString()};
        }
        return null;
    }
}

