/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.transmit;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.service.MetaDataCenterServiceProvider;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.transmit.DefaultTransmitor;
import com.trs.components.wcm.content.enums.ChnlDocActionTypeEnum;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.WCMContentPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MetaViewDataTransmitor
extends DefaultTransmitor {
    private static Logger logger = Logger.getLogger(MetaViewDataTransmitor.class);
    private IMetaViewEmployerMgr m_MetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private IMetaDataDefCacheMgr m_MetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    public String m_LinkFieldName = "SrcPubURL";
    private static String FILE_SUFFIX = ".ini";
    private static Map<String, Map<String, String>> VIEW_INI_MAP = new HashMap<String, Map<String, String>>();

    @Override
    public Report copy(Channel fromChannel, Document fromDocument, Channel toChannel) throws WCMException {
        return this.copy(fromChannel, fromDocument, toChannel, ChnlDocActionTypeEnum.COPY);
    }

    @Override
    public Report copy(Channel fromChannel, Document fromDocument, Channel toChannel, ChnlDocActionTypeEnum actionType) throws WCMException {
        MetaView fromView = this.m_MetaViewEmployerMgr.getViewOfEmployer(fromChannel);
        MetaView toView = this.m_MetaViewEmployerMgr.getViewOfEmployer(toChannel);
        String scopydiffview = ConfigServer.getServer().getSysConfigValue("ALLOW_COPY_DIFFERENT_VIEW", "true");
        boolean bcopyinanotherview = "true".equalsIgnoreCase(scopydiffview);
        if (CMyString.isEmpty(scopydiffview)) {
            bcopyinanotherview = true;
        }
        if (fromView != null && toView != null && fromView.getId() != toView.getId()) {
            if (bcopyinanotherview) {
                return this.copy2AnotherView(fromChannel, fromDocument, toChannel, actionType);
            }
            Report warnreport = new Report("\u590d\u5236\u5931\u8d25\uff01 \u590d\u5236\u7684\u8bb0\u5f55[" + fromDocument.getTitle() + "]\u6240\u5728\u680f\u76ee[id=" + fromChannel.getId() + "]\u4e0e\u76ee\u6807\u680f\u76ee[id=" + toChannel.getId() + "]\u7684\u89c6\u56fe\u4e0d\u5339\u914d!");
            warnreport.setType(4);
            return warnreport;
        }
        ChnlDoc fromChnlDoc = ChnlDoc.findByDocAndChnl(fromDocument, fromChannel);
        if (fromChnlDoc == null) {
            Report report = new Report("\u590d\u5236\u5931\u8d25\uff01 \u590d\u5236\u7684\u6587\u6863[" + fromDocument.getTitle() + "]\u4e0d\u5728\u5f53\u524d\u680f\u76ee[" + fromChannel.getName() + "]\u4e2d!");
            report.setType(5);
            return report;
        }
        if (fromChnlDoc.isEntity()) {
            return this.copy(fromChnlDoc, toChannel, actionType);
        }
        return this.copyQuote(fromChnlDoc, toChannel);
    }

    private Report copy(ChnlDoc fromChnlDoc, Channel toChannel, ChnlDocActionTypeEnum actionType) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nSrcDocId = fromChnlDoc.getDocId();
        MetaViewData metaViewData = MetaViewData.findById(nSrcDocId);
        MetaViewData newMetaViewData = (MetaViewData)metaViewData.cloneToNewObj();
        MetaView view = metaViewData.getMetaView();
        newMetaViewData.setMetaView(view);
        newMetaViewData.setProperty("channelId", toChannel.getId());
        int originMetaDataId = metaViewData.getOriginMetaDataId();
        newMetaViewData.setOriginMetaDataId(originMetaDataId);
        if (view.isMultiTable()) {
            String sTableName = "WCMMetaRelation" + view.getId();
            CMSObjDefaultImpl oRelationTablePO = new CMSObjDefaultImpl(sTableName, "MetaDataId");
            boolean bFind = oRelationTablePO.loadById(nSrcDocId, null);
            if (bFind) {
                Enumeration<String> enPropNames = oRelationTablePO.getProperties().keys();
                while (enPropNames.hasMoreElements()) {
                    String sPropName = enPropNames.nextElement();
                    if (!sPropName.startsWith("WCMMetaTable".toUpperCase())) continue;
                    newMetaViewData.setProperty(sPropName, oRelationTablePO.getProperty(sPropName));
                }
            }
            IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(view.getId());
            for (MetaViewField field : hFields.values()) {
                if (field == null || field.isFromMainTable()) continue;
                newMetaViewData.removeProperty(field.getName());
            }
        }
        newMetaViewData.save(loginUser);
        Document newDoc = Document.findById(newMetaViewData.getId());
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(newDoc, toChannel);
        chnlDoc.setActionType(actionType.value);
        chnlDoc.save();
        if (newDoc != null) {
            newDoc.setDocLevel(fromChnlDoc.getDocLevleId());
            newDoc.save();
            boolean bDocumentInFlowOnCopy = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false"));
            if (bDocumentInFlowOnCopy) {
                WCMProcessServiceHelper.startDocumentInFlow(loginUser, newDoc, true);
            }
        } else {
            throw new BizError("\u590d\u5236\u7684\u6587\u6863\u4fdd\u5b58\u5931\u8d25");
        }
        Report report = new Report(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label26", "\u6210\u529f\u590d\u5236\u8bb0\u5f55[") + newDoc.getTitle() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label27", "]\u5230\u680f\u76ee[") + toChannel.getDispDesc() + "]\uff01");
        report.setRelateObject(newDoc);
        if (metaViewData.getId() != newMetaViewData.getId()) {
            this.m_oAppendixMgr.copyAppendixes(Document.findById(metaViewData.getId()), Document.findById(newMetaViewData.getId()));
        }
        return report;
    }

    private Report copyQuote(ChnlDoc _fromChnlDoc, Channel _toChannel) throws WCMException {
        Channel fromChannel = _fromChnlDoc.getChannel();
        if (fromChannel == null) {
            Report report = new Report(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label28", "\u590d\u5236\u5931\u8d25:\u6587\u6863\u7684\u680f\u76ee[Id=") + _fromChnlDoc.getChannelId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
            report.setType(5);
            return report;
        }
        Document fromDocument = _fromChnlDoc.getDocument();
        if (fromDocument == null) {
            Report report = new Report(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label30", "\u590d\u5236\u5931\u8d25:\u6587\u6863[Id=") + _fromChnlDoc.getDocId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
            report.setType(5);
            return report;
        }
        DocumentMgr oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Document newDoc = oDocumentMgr.copyDocument(fromDocument, fromChannel, _toChannel);
        if (newDoc == null) {
            Report report = new Report(fromDocument + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label31", "\u5728") + _toChannel + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label32", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), null);
            report.setType(5);
            return report;
        }
        if (newDoc.getId() != fromDocument.getId()) {
            this.m_oAppendixMgr.copyAppendixes(fromDocument, newDoc);
        }
        return new Report(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label26", "\u6210\u529f\u590d\u5236\u8bb0\u5f55[") + newDoc.getTitle() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label27", "]\u5230\u680f\u76ee[") + _toChannel.getDispDesc() + "]\uff01");
    }

    private Report copy2AnotherView(Channel fromChannel, Document fromDocument, Channel toChannel, ChnlDocActionTypeEnum actionType) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        MetaView fromView = this.m_MetaViewEmployerMgr.getViewOfEmployer(fromChannel);
        MetaView toView = this.m_MetaViewEmployerMgr.getViewOfEmployer(toChannel);
        if (fromView == null || toView == null) {
            throw new WCMException(I18NMessage.get(MetaViewDataTransmitor.class, "MetaViewDataTransmitor.labe3", "\u83b7\u53d6\u680f\u76ee\u6240\u914d\u7f6e\u7684\u89c6\u56fe\u9519\u8bef!"));
        }
        MetaViewData fromMetaData = MetaViewData.findById(fromDocument.getId());
        MetaViewData newMetaData = new MetaViewData(toView);
        newMetaData.setProperty("ChannelId", toChannel.getId());
        HashMap mFromMetaViewFields = this.m_MetaDataDefCacheMgr.getMetaViewFields(fromView.getId());
        HashMap mNewMetaViewFields = this.m_MetaDataDefCacheMgr.getMetaViewFields(toView.getId());
        ArrayList<MetaViewField> oLinkFieldList = new ArrayList<MetaViewField>();
        String sConfigFilePath = this.getConfigFilePath(fromView, toView);
        String sIniName = fromView.getName() + "_" + toView.getName();
        Map<String, String> mFiles2Files = this.readIniFile(sConfigFilePath, sIniName);
        boolean bContainsViewFiled2Copy = false;
        boolean bCopyWithConfig = this.isCopyWithConfig(fromView, toView);
        for (Map.Entry entry : mNewMetaViewFields.entrySet()) {
            MetaViewField oViewField = (MetaViewField)entry.getValue();
            String sFieldName = oViewField.getName();
            if (!CMyString.isEmpty(oViewField.getDefaultValue())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"------------\u6839\u636e\u9ed8\u8ba4\u503c\u8bbe\u7f6e\u5b57\u6bb5-------------");
                    logger.debug((Object)("---key---" + sFieldName));
                    logger.debug((Object)("--value--" + oViewField.getDefaultValue()));
                }
                newMetaData.setProperty(sFieldName, oViewField.getDefaultValue());
            }
            HashMap tempMap = new HashMap();
            if (bCopyWithConfig) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"------------\u6839\u636e\u914d\u7f6e\u6587\u4ef6\u8bbe\u7f6e-------------");
                }
                tempMap = mFiles2Files;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"------------\u6839\u636e\u540c\u540d\u5b57\u6bb5\u8bbe\u7f6e-------------");
                }
                tempMap = mFromMetaViewFields;
            }
            if (tempMap.containsKey(entry.getKey())) {
                String sFromFieldName = sFieldName;
                if (bCopyWithConfig) {
                    sFromFieldName = mFiles2Files.get(sFieldName.toUpperCase());
                }
                String sFromFieldValue = fromMetaData.getPropertyAsString(sFromFieldName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("---key---" + sFieldName + " " + sFromFieldName));
                    logger.debug((Object)("--value--" + sFromFieldValue));
                }
                newMetaData.setProperty(sFieldName, sFromFieldValue);
                bContainsViewFiled2Copy = true;
                if (oViewField.getType() == 8) {
                    this.renderAppendixField(oViewField, sFieldName, newMetaData, fromMetaData);
                }
            }
            if (oViewField.getType() != 18) continue;
            oLinkFieldList.add(oViewField);
        }
        boolean bAllowNull = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("MetaViewData_Copy_Allow_Null", "true"));
        if (!bAllowNull && !bContainsViewFiled2Copy) {
            Report report = new Report(CMyString.format("\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}]\u5931\u8d25!\u7531\u4e8e\u590d\u5236\u540e\u7684\u8bb0\u5f55\u4e3a\u7a7a!", new String[]{fromDocument.getTitle(), toChannel.getDispDesc()}));
            report.setType(5);
            return report;
        }
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(fromChannel);
        IPublishContent content = PublishElementFactory.makeContentFrom(fromDocument, folder);
        WCMContentPublishConfig config = new WCMContentPublishConfig(loginUser, content);
        if (oLinkFieldList.size() >= 2) {
            for (String sLinkFieldName : mNewMetaViewFields.keySet()) {
                if (!this.m_LinkFieldName.equalsIgnoreCase(sLinkFieldName)) continue;
                newMetaData.setProperty(this.m_LinkFieldName, config.getURL());
            }
        } else if (oLinkFieldList.size() == 1) {
            MetaViewField oLinkField = (MetaViewField)oLinkFieldList.get(0);
            newMetaData.setProperty(oLinkField.getName(), config.getURL());
        } else {
            logger.debug((Object)"\u6ca1\u6709\u8bbe\u7f6e\u5b58\u653e\u53d1\u5e03\u8def\u5f84\u7684Link\u5b57\u6bb5\uff01");
        }
        try {
            newMetaData.save(loginUser);
        }
        catch (BizError e) {
            throw e;
        }
        catch (Exception e) {
            throw new BizError(CMyString.format("\u8de8\u89c6\u56fe\u590d\u5236\u8bb0\u5f55[{0}]\u5230\u680f\u76ee[{1}]\u5931\u8d25,\u6821\u9a8c\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff1a", new String[]{fromDocument.getTitle(), toChannel.getDispDesc()}));
        }
        Document newDoc = Document.findById(newMetaData.getId());
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(newDoc, toChannel);
        chnlDoc.setActionType(actionType.value);
        chnlDoc.save();
        Report report = new Report(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label99", "\u6210\u529f\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}]!"), new String[]{fromDocument.getTitle(), toChannel.getDispDesc()}));
        report.setRelateObject(newDoc);
        if (newDoc != null) {
            newDoc.setOutUpId(fromDocument.getId());
            newDoc.setDocLevel(ChnlDoc.findByDocAndChnl(fromDocument, fromChannel).getDocLevleId());
            newDoc.save();
            boolean bDocumentInFlowOnCopy = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false"));
            if (bDocumentInFlowOnCopy) {
                WCMProcessServiceHelper.startDocumentInFlow(loginUser, newDoc, true);
            }
        }
        if (fromMetaData.getId() != newMetaData.getId()) {
            this.m_oAppendixMgr.copyAppendixes(Document.findById(fromMetaData.getId()), Document.findById(newMetaData.getId()));
        }
        return report;
    }

    private void renderAppendixField(MetaViewField _oMetaViewField, String _sNewFileName, MetaViewData _oNewMetaViewData, MetaViewData _oFromMetaViewData) throws WCMException {
        String sFieldName = _oMetaViewField.getName();
        String sFieldValue = _oFromMetaViewData.getPropertyAsString(sFieldName);
        if (CMyString.isEmpty(sFieldValue)) {
            return;
        }
        String[] sAppendixFileAllNames = sFieldValue.split(";");
        StringBuffer sbNewValue = new StringBuffer();
        for (int i = 0; i < sAppendixFileAllNames.length; ++i) {
            String sAppendixFileAllName = sAppendixFileAllNames[i];
            String sAppendixName = sAppendixFileAllName.split(",")[0];
            if (!FilesMan.isValidFile(sAppendixName, "P0") && !FilesMan.isValidFile(sAppendixName, "W0")) {
                sbNewValue.append(sAppendixFileAllName).append(";");
                continue;
            }
            String sNewValue = FilesMan.getFilesMan().copyWCMFile(sAppendixName, "P0");
            sAppendixFileAllName = sAppendixFileAllName.replaceAll(sAppendixName, sNewValue);
            sbNewValue.append(sAppendixFileAllName).append(";");
        }
        String sNewValues = sbNewValue.toString();
        sNewValues = sNewValues.substring(0, sNewValues.lastIndexOf(";"));
        if (CMyString.isEmpty(_sNewFileName)) {
            _oNewMetaViewData.setProperty(sFieldName, sNewValues);
        } else {
            _oNewMetaViewData.setProperty(_sNewFileName, sNewValues);
        }
    }

    private boolean isCopyWithConfig(MetaView _fromView, MetaView _toView) throws WCMException {
        String sConfigFilePath = this.getConfigFilePath(_fromView, _toView);
        return CMyFile.fileExists(sConfigFilePath);
    }

    private String getConfigFilePath(MetaView _fromView, MetaView _toView) throws WCMException {
        String sFileName = _fromView.getName() + FILE_SUFFIX;
        String sDomain = ConfigServer.getServer().getInitProperty("WCM_PATH");
        String sApp = ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "app");
        String sUrl = CMyString.setStrEndWith(sDomain, File.separatorChar) + sApp + File.separatorChar + "application" + File.separatorChar + _toView.getId();
        return CMyString.setStrEndWith(sUrl, File.separatorChar) + sFileName;
    }

    private Map<String, String> readIniFile(String _sFileFullPath, String _sMapKey) throws WCMException {
        if (_sMapKey != null && VIEW_INI_MAP.get(_sMapKey) != null) {
            logger.debug((Object)("\u4ececache\u4e2d\u83b7\u53d6:" + VIEW_INI_MAP.get(_sMapKey)));
            return VIEW_INI_MAP.get(_sMapKey);
        }
        HashMap<String, String> oIniMap = new HashMap<String, String>();
        Properties iniFile = new Properties();
        try {
            if (CMyFile.fileExists(_sFileFullPath)) {
                iniFile.load(new FileService(_sFileFullPath).getInputStream());
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u83b7\u53d6\u89c6\u56fe\u914d\u7f6e\u89c4\u5219\u6587\u4ef6\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)e);
        }
        Enumeration<Object> enKeys = iniFile.keys();
        while (enKeys.hasMoreElements()) {
            String sKey = enKeys.nextElement().toString();
            String sValue = iniFile.getProperty(sKey).trim();
            if (sValue.length() == 0) continue;
            oIniMap.put(sKey.toUpperCase(), sValue.toUpperCase());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("---Map---" + oIniMap));
            logger.debug((Object)("filePath:" + _sFileFullPath));
        }
        VIEW_INI_MAP.put(_sMapKey, oIniMap);
        return oIniMap;
    }
}

