/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;

public class RelationMgr {
    public void saveRelations(Document _currDocument, List<CMSObj> _currRelationList) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label1", "\u6587\u6863\u4e3a\u7a7a\uff01"));
        }
        if (_currRelationList == null) {
            return;
        }
        this.deleteUnuseRelations(this.makeUseingIds(_currDocument, _currRelationList), _currDocument);
        if (_currRelationList.isEmpty()) {
            return;
        }
        if (_currDocument.getId() == 0) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label2", "\u6587\u6863ID\u65e0\u6548\uff01"));
        }
        Relation aRelation = null;
        int nSize = _currRelationList.size();
        for (int i = 0; i < nSize; ++i) {
            aRelation = (Relation)_currRelationList.get(i);
            if (aRelation == null) continue;
            aRelation.setProperty("SERN", nSize - i);
            if (aRelation.isAddMode()) {
                aRelation.setDocId(_currDocument.getId());
                aRelation.insert(ContextHelper.getLoginUser());
                continue;
            }
            aRelation.update(ContextHelper.getLoginUser());
        }
    }

    public Relations getRelations(Document _currDocument) throws WCMException {
        return this.getRelations(_currDocument, null);
    }

    public Relations getRelations(Document _currDocument, WCMFilter _extraFilter) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label3", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5176\u76f8\u5173\u5bf9\u8c61\u96c6\u5408!"));
        }
        WCMFilter aFilter = new WCMFilter("", "DocId=" + _currDocument.getDocId(), "SERN desc");
        aFilter.mergeWith(_extraFilter);
        try {
            Relations relations = new Relations(ContextHelper.getLoginUser());
            relations.open(aFilter);
            return relations;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RelationMgr.class, "RelationMgr.label4", "\u83b7\u53d6\u6587\u6863\u7684\u76f8\u5173\u5bf9\u8c61\u96c6\u5408\u5931\u8d25!"), ex);
        }
    }

    public List copyRelationListByObj(BaseObj _currObj) throws WCMException {
        if (_currObj == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label5", "\u67e5\u8be2\u9644\u4ef6\u65f6\uff0c\u5bbf\u4e3b\u5bf9\u8c61\uff08\u6587\u6863\uff09\u4e3a\u7a7a\uff01"));
        }
        Relations currRelations = Relations.findRelationsByObj(_currObj);
        ArrayList<BaseObj> currList = new ArrayList<BaseObj>();
        if (currRelations == null || currRelations.isEmpty()) {
            return currList;
        }
        for (int i = 0; i < currRelations.size(); ++i) {
            currList.add(currRelations.getAt(i).cloneToNewObj());
        }
        return currList;
    }

    public Relations getRelationsByIDs(String ids) throws WCMException {
        if (CMyString.isEmpty(ids)) {
            return Relations.createNewInstance(ContextHelper.getLoginUser());
        }
        User loginUser = ContextHelper.getLoginUser();
        WCMFilter filter = new WCMFilter();
        String[] tempIds = ids.split(",");
        if (tempIds.length > 0) {
            StringBuilder whereSQL = new StringBuilder();
            for (int i = 0; i < tempIds.length; ++i) {
                whereSQL.append("?,");
                filter.addSearchValues(tempIds[i]);
            }
            filter.setWhere("RELATIONID in (" + whereSQL.substring(0, whereSQL.length() - 1) + ")");
        }
        return Relations.openWCMObjs(loginUser, filter);
    }

    public void copyRelations(Document _fromDocument, Document _newDocument) throws WCMException {
        if (_fromDocument == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label6", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u5176\u76f8\u5173\u6587\u6863\uff01"));
        }
        if (_newDocument == null) {
            throw new WCMException(10, I18NMessage.get(RelationMgr.class, "RelationMgr.label7", "\u76ee\u6807\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u76f8\u5173\u6587\u6863\uff01"));
        }
        this.saveRelations(_newDocument, this.copyRelationListByObj(_fromDocument));
    }

    private String makeUseingIds(Document _currDocument, List<CMSObj> _newRelationList) throws WCMException {
        if (_newRelationList == null) {
            return null;
        }
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(RelationMgr.class, "RelationMgr.label8", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u76f8\u5173\u6587\u6863\uff01"));
        }
        String sIds = "0";
        Relation aRelation = new Relation();
        for (int i = 0; i < _newRelationList.size(); ++i) {
            aRelation = (Relation)_newRelationList.get(i);
            if (aRelation == null || aRelation.isAddMode()) continue;
            sIds = sIds + "," + aRelation.getId();
        }
        return sIds;
    }

    public void deleteUnuseRelations(String _sUseingIds, Document _document) throws WCMException {
        if (_document == null || _sUseingIds == null || _sUseingIds.length() <= 0) {
            return;
        }
        String sDelWhere = "DOCID=?";
        if (!"0".equals(_sUseingIds)) {
            sDelWhere = sDelWhere + " and RELATIONID not in (" + _sUseingIds + ")";
        }
        WCMFilter filter = new WCMFilter("", sDelWhere, "", "");
        filter.addSearchValues(_document.getId());
        Relations relations = new Relations(ContextHelper.getLoginUser());
        relations.open(filter);
        if (!relations.isEmpty()) {
            relations.removeAll(true);
        }
    }

    public Relations getRelations(WCMFilter _aWCMFilter) throws WCMException {
        if (_aWCMFilter == null) {
            throw new WCMException(20, I18NMessage.get(RelationMgr.class, "RelationMgr.label9", "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        return Relations.openWCMObjs(ContextHelper.getLoginUser(), _aWCMFilter);
    }

    public void deleteRelations(Document _document) throws WCMException {
        this.getRelations(_document).removeAll();
    }
}

