/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DocStatHandlerByChannel;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandlerBySiteAdmin
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandlerByChannel.class);
    private Channels canManagerChannels = new Channels(null);
    private final int error = -2;
    private final int group = -1;
    private User loginUser;
    private IChnlDeptMgr m_oChnlDeptMgr = null;
    private HashMap m_hRelGroupsOfChannel = new HashMap();
    private HashMap m_hRelGroupsOfUser = new HashMap();
    private int nTypeIndex = -1;
    private String sTypeName = "";
    private String acceptType = "";
    private String acceptValue = "";
    private int acceptTypeIndex = -1;
    private int nChannelIndex = -1;
    private int nAddFieldCount = -1;
    private Channels acceptChannels = null;

    public DocStatHandlerBySiteAdmin(String sTypeName, String acceptTypeName, String acceptValue, int nAddFieldCount) throws WCMException {
        this.sTypeName = sTypeName;
        this.acceptType = acceptTypeName;
        this.acceptValue = acceptValue;
        this.nAddFieldCount = nAddFieldCount;
        this.loginUser = ContextHelper.getLoginUser();
        this.getCanManagerChannels4SiteAdmin();
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        this.nTypeIndex = this.getKeyIndex(this.sTypeName, resultSet);
        this.acceptTypeIndex = this.getKeyIndex(this.acceptType, resultSet);
        this.nChannelIndex = this.getKeyIndex("ChnlId", resultSet);
        super.visitStart(resultSet, nSQLIndex);
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nDataCount = resultSet.getInt(1);
            if (this.nChannelIndex < 0) {
                throw new WCMException("\u6ca1\u6709\u4f20\u5165\u680f\u76ee\u5b57\u6bb5\u6216\u8005\u680f\u76ee\u5b57\u6bb5\u6709\u8bef");
            }
            int nChannelId = resultSet.getInt(this.nChannelIndex);
            if (this.canManagerChannels.indexOf(nChannelId) < 0) {
                return;
            }
            if (this.acceptTypeIndex > 0 && "ChnlId".equalsIgnoreCase(this.acceptType) && "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"))) {
                int nChnlId = resultSet.getInt(this.acceptTypeIndex);
                boolean isSonChannel = false;
                Channel _chnl = Channel.findById(nChnlId);
                if (_chnl == null) {
                    return;
                }
                while (_chnl != null) {
                    if (_chnl.getId() == Integer.parseInt(this.acceptValue)) {
                        isSonChannel = true;
                        break;
                    }
                    _chnl = _chnl.getParent();
                }
                if (!isSonChannel) {
                    return;
                }
            } else {
                Group _group;
                String UserName;
                Groups oGroups;
                if (this.acceptTypeIndex > 0 && !resultSet.getString(this.acceptTypeIndex).equalsIgnoreCase(this.acceptValue)) {
                    return;
                }
                if (this.acceptTypeIndex == -1 && (oGroups = this.makeCurrRelGroups(UserName = resultSet.getString(this.getKeyIndex("CrUser", resultSet)))).indexOf(_group = Group.findById(Integer.parseInt(this.acceptValue))) < 0) {
                    return;
                }
            }
            if (this.nTypeIndex > 0) {
                if (this.sTypeName.equalsIgnoreCase("ChnlId") && "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"))) {
                    String Key2 = resultSet.getString(this.nTypeIndex);
                    for (Channel parent = Channel.findById(nChannelId); parent != null; parent = parent.getParent()) {
                        Key2 = parent.getId() + "";
                        String sKey = this.makePrivateKey(Key2, resultSet);
                        int oldValue = this.getValue(nSQLIndex, sKey);
                        this.setValue(nSQLIndex, sKey, nDataCount + oldValue);
                        this.addMajorObject(Key2);
                    }
                } else {
                    String Key3 = resultSet.getString(this.nTypeIndex);
                    String sKey = this.makePrivateKey(Key3, resultSet);
                    int oldValue = this.getValue(nSQLIndex, sKey);
                    this.setValue(nSQLIndex, sKey, nDataCount + oldValue);
                    this.addMajorObject(Key3);
                }
            } else {
                Channel channel = Channel.findById(nChannelId);
                if (channel == null) {
                    throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u680f\u76ee! [ChannelId = " + nChannelId + "]");
                }
                DebugTimer timerTemp = new DebugTimer();
                timerTemp.start();
                String userName = resultSet.getString(this.getKeyIndex("CrUser", resultSet));
                Groups oRelGroups = this.makeCurrRelGroups(userName);
                timerTemp.stop();
                logger.debug((Object)("makeCurrRelGroups of channel-" + nChannelId + " use[" + timerTemp.getTime() + "]ms"));
                int nSize = oRelGroups.size();
                for (int nRelChannelIndex = 0; nRelChannelIndex < nSize; ++nRelChannelIndex) {
                    Group oRelGroup = (Group)oRelGroups.getAt(nRelChannelIndex);
                    if (oRelGroup == null) continue;
                    String sGroupId = oRelGroup.getId() + "";
                    String oGroupKey = this.makePrivateKey(sGroupId, resultSet);
                    int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                    int nDataCountOfCurrGroup = nDataCount;
                    this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                    this.addMajorObject(sGroupId);
                }
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String Key2, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        int defaultCount = 1;
        if (this.sTypeName == "Group") {
            defaultCount = 2;
        }
        if (nColumnCount > defaultCount + this.nAddFieldCount) {
            String[] sParam = new String[]{Key2, resultSet.getString(nColumnCount)};
            return this.makeKey(sParam);
        }
        return Key2;
    }

    private Groups makeCurrRelGroups(Channel _oChannel) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfChannel.get(_oChannel);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        String _sDepIds = this.m_oChnlDeptMgr.getDepIdsByChannel(_oChannel).toString();
        _sDepIds = _sDepIds.length() <= 2 ? "" : _sDepIds.substring(1, _sDepIds.length() - 1);
        oCurrRelGroups = Groups.findByIds(this.loginUser, _sDepIds.trim());
        int nSize = oCurrRelGroups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)oCurrRelGroups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfChannel.put(_oChannel.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }

    private int getKeyIndex(String keyName, ResultSet resultSet) throws WCMException {
        if (keyName == null || keyName == "") {
            return -2;
        }
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int nColumnCount = metaData.getColumnCount();
            for (int i = 1; i <= nColumnCount; ++i) {
                if (!keyName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
                return i;
            }
        }
        catch (SQLException e) {
            throw new WCMException(1100, "\u8bbe\u7f6ecruser\u7684\u7d22\u5f15\u4f4d\u7f6e\u51fa\u73b0\u9519\u8bef", e);
        }
        return -1;
    }

    private Groups makeCurrRelGroups(String _sLowerCaseUserName) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfUser.get(_sLowerCaseUserName);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        User oCurrUser = User.findByName(_sLowerCaseUserName);
        if (oCurrUser == null) {
            return oCurrRelGroups;
        }
        Groups groups = oCurrUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfUser.put(oCurrUser.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }

    private void getCanManagerChannels4SiteAdmin() throws WCMException {
        String sSiteIds = "";
        WebSites sites = WebSites.openWCMObjs(this.loginUser, null);
        for (int i = 0; i < sites.size(); ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (!AuthServer.hasRight(this.loginUser, (CMSObj)site, 1)) continue;
            sSiteIds = sSiteIds.length() <= 0 ? sSiteIds + site.getId() : sSiteIds + "," + site.getId();
        }
        if (sSiteIds.length() > 0) {
            sSiteIds = "SITEID in (" + sSiteIds + ")";
            this.canManagerChannels = Channels.openWCMObjs(this.loginUser, new WCMFilter("", sSiteIds, ""));
        }
    }
}

