/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.xml;

import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.definition.xml.MetaTableXMLConvertor;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyZip;
import java.io.File;

public class MetaViewExporter {
    public String export(MetaViews _views) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileName = filesMan.getNextFileName("ST", "xml");
        return this.export(_views, sFileName);
    }

    public String export(MetaViews _views, String _sFileName) throws WCMException {
        String sExportFileName = _sFileName;
        if (!CMyFile.pathExists(sExportFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sExportFileName = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
        }
        MetaDBTables tables = new MetaDBTables(null);
        int nSize = _views.size();
        for (int i = 0; i < nSize; ++i) {
            int nMainTableId;
            MetaView view = (MetaView)_views.getAt(i);
            if (view == null || tables.indexOf(nMainTableId = view.getMainTableId()) >= 0) continue;
            tables.addElement(nMainTableId);
        }
        MetaTableXMLConvertor convertor = new MetaTableXMLConvertor(_views);
        convertor.toXMLFile(tables, sExportFileName);
        return _sFileName;
    }

    public String exportZip(MetaViews _views) throws WCMException {
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String sPathName = aFilesMan.getNextFilePathName("ST", "zip");
        CMyZip oCMyZip = new CMyZip();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileName = filesMan.getNextFileName("ST", "xml", null, true);
        MetaDBTables tables = new MetaDBTables(null);
        int nSize = _views.size();
        for (int i = 0; i < nSize; ++i) {
            int nMainTableId;
            MetaView view = (MetaView)_views.getAt(i);
            if (view == null || tables.indexOf(nMainTableId = view.getMainTableId()) >= 0) continue;
            tables.addElement(nMainTableId);
        }
        MetaTableXMLConvertor convertor = new MetaTableXMLConvertor(_views);
        convertor.toXMLFile(tables, sFileName);
        try {
            oCMyZip.setZipFileName(sPathName);
            oCMyZip.addToZip(sFileName, false);
            int nSize2 = _views.size();
            for (int i = 0; i < nSize2; ++i) {
                MetaView oMetaView = (MetaView)_views.getAt(i);
                if (oMetaView == null) continue;
                int nMetaViewId = oMetaView.getId();
                String sDesignFileName = oMetaView.getName() + File.separator + "metaviewdata_addedit_design.html";
                String sAddEditTempName = oMetaView.getName() + File.separator + "metaviewdata_addedit.jsp";
                this.copyFileToDest(nMetaViewId, sDesignFileName, sAddEditTempName);
                String sDesignEntryName = CMyFile.extractMainFileName("metaviewdata_addedit_design.html");
                String sEditEntryName = CMyFile.extractMainFileName("metaviewdata_addedit.jsp");
                oCMyZip.addToZip(sDesignFileName, sDesignEntryName);
                oCMyZip.addToZip(sAddEditTempName, sEditEntryName);
            }
            oCMyZip.done();
        }
        catch (CMyException e) {
            CMyFile.deleteFile(sPathName);
            throw new WCMException(I18NMessage.get(MetaViewExporter.class, "MetaViewExporter.label1", "\u5c06\u6587\u4ef6sFileName\u6dfb\u52a0\u5230\u538b\u7f29\u5305\u5931\u8d25\u3002"), e);
        }
        finally {
            CMyFile.deleteFile(sFileName);
        }
        return CMyFile.extractFileName(sPathName);
    }

    private void copyFileToDest(int _nMetaViewId, String _sDesignFileName, String _AddEditTempName) throws WCMException {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        String sSubDir = ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "WCMV6") + "\\application\\";
        sSubDir = sWCMPath + sSubDir;
        sSubDir = sSubDir.replace('\\', File.separatorChar);
        sSubDir = sSubDir + _nMetaViewId;
        String sSrcDesignFile = sSubDir + File.separatorChar + "template" + File.separatorChar + "metaviewdata_addedit_design.html";
        String sSrcTempFile = sSubDir + File.separatorChar + "template" + File.separatorChar + "metaviewdata_addedit.jsp";
        try {
            CMyFile.copyFile(sSrcDesignFile, _sDesignFileName, true);
            CMyFile.copyFile(sSrcTempFile, _AddEditTempName, true);
        }
        catch (CMyException e) {
            throw new WCMException(I18NMessage.get(MetaViewExporter.class, "MetaViewExporter.label2", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25"), e);
        }
    }
}

