/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.publish.tagparser;

import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TagParserInfoViewComplexData
implements ITagParser {
    private static Logger logger = Logger.getLogger(TagParserInfoViewComplexData.class);
    protected static TagBeanInfo m_sTagBeanInfo = null;

    protected String[] parseHostSpecialProperty(int propertyId, PublishTagContext _context) throws WCMException {
        return null;
    }

    protected void registerHostSpecialProperties() {
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_INFOVIEWCOMPLEXDATA");
            tbi.setDesc("TRS_INFOVIEWCOMPLEXDATA");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setDesc("AUTOFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATEFORMAT");
            tbai.setDesc("DATEFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setDesc("AUTOFORMATTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("HTML");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CODEFILTERED");
            tbai.setDesc("\u8fc7\u6ee4\u5185\u5bb9\u4e2d\u7684html\u4ee3\u7801");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            m_sTagBeanInfo = tbi;
        }
        return m_sTagBeanInfo;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Map currDataMap = this.findObject(_context);
        if (currDataMap == null) {
            return null;
        }
        String sFieldName = _context.getAttribute("field");
        if (CMyString.isEmpty(sFieldName)) {
            return null;
        }
        IPublishElement content = _context.getUpperHost();
        if (content == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        String sFieldValue = "";
        if (!CMyString.isEmpty(sFieldName) && CMyString.isEmpty(sFieldValue = (String)currDataMap.get(sFieldName.toUpperCase()))) {
            sFieldValue = "";
        }
        if (_context.getAttribute("CODEFILTERED", false)) {
            sFieldValue = sFieldValue.replaceAll("<{1}[^>]{1,}>{1}", "");
        }
        String sImagePath = this.calImagePath(_context);
        HTMLContent oHTMLContent = new HTMLContent(sFieldValue);
        sFieldValue = oHTMLContent.parseHTMLContent(sImagePath);
        this.distributionHTMLContentFiles(oHTMLContent, _context, (IPublishContent)content);
        sFieldValue = TagParseHelper.truncateTextIfNeeded(_context, sFieldValue);
        sFieldValue = TagParseHelper.formatTextIfNeeded(_context, sFieldValue);
        return new String[]{sFieldValue};
    }

    protected Map findObject(PublishTagContext _context) throws WCMException {
        Map hpApp = _context.getExtraAttributes();
        Map object = (Map)hpApp.get("COMPLEXFIELDDATA");
        if (object == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return object;
    }

    private String calImagePath(PublishTagContext _context) throws WCMException {
        String attrName = "InfoViewImagePath";
        PublishPageContext pageContext = _context.getPageContext();
        String sImagePath = pageContext.getExtraAttribute(attrName);
        if (sImagePath != null) {
            return sImagePath;
        }
        IPublishContent content2 = (IPublishContent)_context.getUpperHost();
        String sImagePath1 = _context.getPathCompass().getAbsoluteHttpPath(content2.getOriginalHome());
        String sImagePath2 = PublishPathCompass.calSubDirectory(content2, false);
        sImagePath = sImagePath1 + sImagePath2;
        if (!_context.getAttribute("UrlIsABS", false)) {
            sImagePath = HtmlUtil.calRelativePath(sImagePath, _context.getPageHttpPath());
        }
        pageContext.setExtraAttribute(attrName, sImagePath);
        return sImagePath;
    }

    private void distributionHTMLContentFiles(HTMLContent oHTMLContent, PublishTagContext _context, IPublishContent publishContent) {
        try {
            List<String> listFiles = oHTMLContent.getWCMFiles();
            int nSize = listFiles.size();
            if (nSize <= 0) {
                return;
            }
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            publishContent.setFolder(publishContent.getOriginalHome());
            for (int i = 0; i < nSize; ++i) {
                String sSrcFilePathName;
                String sFileName = listFiles.get(i);
                if (sFileName == null || !CMyFile.fileExists(sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName)) continue;
                String sLocalPath = compass.getLocalPath(publishContent, bPreview);
                PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
                if (bPreview) continue;
                _context.getFileDistributeShip().distributeFile(sSrcFilePathName, publishContent, null, true);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("\u53d1\u5e03" + publishContent + "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01"), (Throwable)ex);
        }
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    public void clear() {
    }
}

