/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.process;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowUserHelper;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.infoview.InfoViewDataHelper;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SendEmailForInfoViewHandler
implements IActionHandler {
    private static final int VAR_RECEIVER_CRUSER = 1996496058;
    private static final int VAR_RECEIVER_DEPTMGR = -2022387309;
    private static final int VAR_RECEIVER_SPDEPTMGR = 268620950;
    private static final int VAR_RECEIVER_PREDEALER = 1434819164;
    private static final int VAR_RECEIVER_CURRDEALER = -641375541;
    private static Logger logger = Logger.getLogger(SendEmailForInfoViewHandler.class);
    private Document m_oCurrDocument = null;
    private Map m_hVarValues = null;

    @Override
    public boolean execute(ExecuteContext _context, FlowAction _action) throws WCMException {
        Document document;
        CMSObj content = _context.getFlowContent().getSubinstance();
        if (!(content instanceof Document)) {
            return false;
        }
        this.m_oCurrDocument = document = (Document)content;
        ActionParametersAnalyser parameters = new ActionParametersAnalyser(_action.getParams());
        String sFields = parameters.getParameterValue("Fields");
        Map hContentProperties = this.makeProperties(_context, document, sFields);
        String sMailTemplateFile = parameters.getParameterValue("MailTemplateFile");
        String sContent = this.makeEmailContent(document, hContentProperties, sMailTemplateFile);
        User oPostUser = _context.getPostUser();
        Users oUsers = this.makeReceiverUsers(parameters, _context);
        this.m_hVarValues = new HashMap(5);
        this.m_hVarValues.put("CONTENTTITLE".toUpperCase(), _context.getFlowContent().getDesc());
        this.m_hVarValues.put("CurrDateTime".toUpperCase(), CMyDateTime.now().toString());
        this.m_hVarValues.put("SenderName".toUpperCase(), _context.getPostUser().getName());
        this.sendMail(sContent, oPostUser, parameters, hContentProperties, oUsers);
        return true;
    }

    private void sendMail(String _sMailContent, User oSendUser, ActionParametersAnalyser _parameters, Map _hContentProperties, Users oToUsers) throws WCMException {
        String sHtmlEmailBody = _sMailContent.replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
        String sHtmlEmailTitle = this.getActionParameterWithContent("MailTitle", _parameters, _hContentProperties);
        int nSize = oToUsers.size();
        for (int i = 0; i < nSize; ++i) {
            User toUser = (User)oToUsers.getAt(i);
            if (toUser == null) continue;
            this.m_hVarValues.put("ReceiverName".toUpperCase(), toUser.getName());
            Message newMsg = new Message();
            newMsg.setCrUser(oSendUser);
            newMsg.setTitle(sHtmlEmailTitle);
            newMsg.setBody(sHtmlEmailBody);
            newMsg.setReceivers(204, oToUsers.getIdListAsString());
            newMsg.setSendTypes("Email");
            newMsg.setProperty("MsgType", 1L);
            newMsg.save(oSendUser);
            MessageServer.send(newMsg);
        }
    }

    private Users makeReceiverUsers(ActionParametersAnalyser parameters, ExecuteContext _context) throws WCMException {
        String sReceiver = parameters.getParameterValue("Receiver");
        Users users = null;
        if (sReceiver == null || (sReceiver = sReceiver.trim()).length() == 0) {
            return null;
        }
        switch (sReceiver.toUpperCase().hashCode()) {
            case 1996496058: {
                users = new Users(null, 1, 1);
                User crUser = _context.getFlowContent().getCrUser();
                if (crUser == null) break;
                users.addElement(crUser);
                break;
            }
            case -2022387309: {
                users = FlowUserHelper.getDeptMgrsOfUserx(_context.getPostUser());
                break;
            }
            case 268620950: {
                String sGroupName = _context.getFlowContent().getProperty(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label1", "\u652f\u6301\u90e8\u95e8"));
                users = FlowUserHelper.getDeptMgrsByGrpName(sGroupName);
                break;
            }
            case 1434819164: {
                users = new Users(null, 1, 1);
                User predealer = _context.getCurrFlowDoc().getPostUser();
                if (predealer == null) break;
                users.addElement(predealer);
                break;
            }
            case -641375541: {
                users = new Users(null, 1, 1);
                User currdealer = _context.getCurrFlowDoc().getToUser();
                if (currdealer == null) break;
                users.addElement(currdealer);
                break;
            }
            default: {
                String[] pUserNames = sReceiver.split(",");
                users = new Users(null, pUserNames.length, 1);
                for (int i = 0; i < pUserNames.length; ++i) {
                    User user = User.findByName(pUserNames[i]);
                    if (user == null) continue;
                    users.addElement(user);
                }
            }
        }
        return users;
    }

    private String getActionParameterWithContent(String _sParamName, ActionParametersAnalyser _parameters, Map _hContentProperties) throws WCMException {
        String sMailFrom = _parameters.getParameterValue(_sParamName);
        sMailFrom = this.parsePageVariables(sMailFrom, _hContentProperties);
        return sMailFrom;
    }

    private Map makeProperties(ExecuteContext _context, Document _document, String _sFields) throws WCMException {
        HashMap<String, String> hContentVarValues = new HashMap<String, String>();
        this.putDefaultValues(_context, _document, hContentVarValues);
        String[] pFields = new String[]{};
        if (!CMyString.isEmpty(_sFields)) {
            pFields = _sFields.split(",");
        }
        String textFeildValue = null;
        for (int i = 0; i < pFields.length; ++i) {
            textFeildValue = InfoViewDataHelper.getProperty(_document, pFields[i].trim());
            if (!CMyString.isEmpty(textFeildValue)) {
                hContentVarValues.put(pFields[i], textFeildValue);
                continue;
            }
            hContentVarValues.put(pFields[i], " ");
        }
        return hContentVarValues;
    }

    private void putDefaultValues(ExecuteContext _context, Document _document, Map _hContentVarValues) {
        Users toUsers;
        _hContentVarValues.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label2", "\u6807\u9898"), _document.getTitle());
        _hContentVarValues.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label3", "\u5f53\u524d\u65f6\u95f4"), CMyDateTime.now().toString(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label4", "yyyy\u5e74MM\u6708dd\u65e5")));
        User postUser = _context.getPostUser();
        if (postUser != null) {
            _hContentVarValues.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label5", "\u5904\u7406\u4eba"), postUser.getTrueName());
            _hContentVarValues.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label6", "\u5904\u7406\u4eba\u90ae\u4ef6\u5730\u5740"), postUser.getEmail());
        }
        if ((toUsers = _context.getFlowContext().getToUsers()) != null && !toUsers.isEmpty()) {
            StringBuffer sbToUsersEmail = new StringBuffer();
            StringBuffer sbToUsersName = new StringBuffer();
            int nSize = toUsers.size();
            for (int i = 0; i < nSize; ++i) {
                User toUser = (User)toUsers.getAt(i);
                if (toUser == null) continue;
                sbToUsersEmail.append(toUser.getEmail());
                sbToUsersEmail.append(";");
                sbToUsersName.append(toUser.getTrueName());
                sbToUsersName.append("\u3001");
            }
            sbToUsersEmail.setLength(sbToUsersEmail.length() - 1);
            sbToUsersName.setLength(sbToUsersName.length() - 1);
            _hContentVarValues.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label7", "\u63a5\u6536\u4eba"), sbToUsersName.toString());
            _hContentVarValues.put(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label8", "\u63a5\u6536\u4eba\u90ae\u4ef6\u5730\u5740"), sbToUsersEmail.toString());
        }
    }

    private String makeEmailContent(Document _document, Map _hContentVarValues, String _sMailTemplateFile) throws WCMException {
        String _oContent = this.getEmailTemplateContent(_sMailTemplateFile);
        String oContent = this.parsePageVariables(_oContent, _hContentVarValues);
        return oContent;
    }

    private String getEmailTemplateContent(String _sMailTemplateFile) throws WCMException {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        String sAbsoluteTemplateFile = (sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar)) + _sMailTemplateFile;
        if (!CMyFile.fileExists(sAbsoluteTemplateFile)) {
            throw new WCMException(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label9", "\u90ae\u4ef6\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u8bbe\u7f6e\u7684\u65f6\u5019\u6b63\u786e\uff01[File=") + sAbsoluteTemplateFile + "][ConfigFile=" + _sMailTemplateFile + "]");
        }
        try {
            return CMyFile.readFile(sAbsoluteTemplateFile, "utf-8");
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label10", "\u8bfb\u53d6\u90ae\u4ef6\u6a21\u677f\u5931\u8d25\uff01[File=") + sAbsoluteTemplateFile + "][ConfigFile=" + _sMailTemplateFile + "]", e);
        }
    }

    public String parsePageVariables(String _sContent, Map _variables) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        try {
            char[] chrArray = _sContent.toCharArray();
            int nLength = chrArray.length;
            int nPos = 0;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '{') {
                    StringBuffer buffVarName = new StringBuffer(16);
                    ++nPos;
                    int iCount = 0;
                    boolean zFound = false;
                    while (iCount++ < 20 && nPos < nLength) {
                        if ((aChar = chrArray[nPos++]) == '}') {
                            zFound = true;
                            break;
                        }
                        buffVarName.append(aChar);
                    }
                    if (zFound) {
                        String sKey = buffVarName.toString().trim();
                        String sVal = "";
                        Object oValue = _variables.get(sKey);
                        if (oValue == null && (oValue = InfoViewDataHelper.getProperty(this.m_oCurrDocument, sKey)) == null) {
                            oValue = this.m_oCurrDocument.getProperty(sKey);
                        }
                        if (oValue != null) {
                            sVal = oValue.toString();
                        }
                        if (sVal != null) {
                            buffResult.append(sVal);
                            continue;
                        }
                        buffResult.append("${").append(buffVarName).append('}');
                        continue;
                    }
                    buffResult.append("${").append(buffVarName);
                    continue;
                }
                buffResult.append(aChar);
            }
            return buffResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(SendEmailForInfoViewHandler.class, "SendEmailForInfoViewHandler.label11", "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!"), ex);
        }
    }
}

