/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.cms.ContextHelper;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.helper.ComplexFieldData;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.FieldInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class XMLContentRender {
    private static final String ATTR_COMPLEX_FIELD = "complex_field";
    private static final String ATTR_PARENT_FLAG = "ParentFlag";
    protected static Logger logger = Logger.getLogger(XMLContentRender.class);
    private List m_oComplexFieldDatas;

    public void render(InfoViewData _oDocData, String sXMLContent, String[] saNameSpaceURI) throws WCMException {
        this.render(_oDocData, InfoViewHelper.parseToDocument(sXMLContent), saNameSpaceURI);
    }

    public void render(InfoViewData _oDocData, Document xmlDocument, String[] saNameSpaceURI) throws WCMException {
        Element elRoot = xmlDocument.getRootElement();
        if (elRoot == null) {
            return;
        }
        XMLContentRender.addRootElementField(_oDocData, xmlDocument);
        String[] saNSPrefix = this.getNSPrefix(elRoot, saNameSpaceURI);
        if (saNSPrefix == null) {
            saNSPrefix = new String[]{elRoot.getNamespacePrefix()};
        }
        Iterator itrRoot = elRoot.elementIterator();
        while (itrRoot.hasNext()) {
            this.addElementField(_oDocData, (Element)itrRoot.next(), saNSPrefix);
        }
    }

    static void addRootElementField(InfoViewData _oDocData, Document xmlDocument) throws WCMException {
        String key = "ROOTELEMENT";
        String val = xmlDocument.getRootElement().getQualifiedName();
        _oDocData.setProperty(key, val);
    }

    private void setProperty(InfoViewData _oDocData, String key, String val) throws WCMException {
        this.setProperty(_oDocData, key, val, null);
    }

    private void setProperty(InfoViewData _oDocData, String key, String val, Element _xmlDocument) throws WCMException {
        Object oLastPropValue;
        String sRootAttr = "ROOTELEMENT";
        String sRootPath = _oDocData.getPropertyAsString(sRootAttr);
        key = key.replaceAll("(?i)^/" + sRootPath + "/", "");
        String sKey = InfoViewHelper.getDBFieldByField(_oDocData.getInfoViewId(), key, false);
        String sTrueTableName = InfoViewConstants.makeTrueTableName(_oDocData.getInfoViewId());
        FieldInfo oFieldInfo = DBManager.getDBManager().getFieldInfo(sTrueTableName, sKey);
        Object object = oLastPropValue = _oDocData.isAddMode() ? _oDocData.getProperty(sKey) : _oDocData.getNewProperty(sKey);
        if (oFieldInfo != null) {
            String sParentFlag;
            String sFieldValue;
            String sFieldName;
            String sFiledId;
            ComplexFieldData data;
            boolean bIsComplexField;
            DataType oDataType;
            if (CMyString.isEmpty(val)) {
                String sOldValue = _oDocData.getPropertyAsString(sKey);
                if (CMyString.isEmpty(sOldValue)) {
                    // empty if block
                }
                val = "";
            }
            if ((oDataType = oFieldInfo.getDataType()) != null) {
                int nType = oDataType.getType();
                if (nType == 2005) {
                    _oDocData.setProperty(sKey, new CDBText(DBManager.getDBManager().getDBTypeAsInt(), val));
                } else if (nType == 91 || nType == 93) {
                    CMyDateTime oCMyDateTime = new CMyDateTime();
                    try {
                        boolean bFormatRight;
                        if (!CMyString.isEmpty(val) && !(bFormatRight = oCMyDateTime.setDateTimeWithString(val))) {
                            throw new WCMException(I18NMessage.get(XMLContentRender.class, "XMLContentRender.label1", "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e") + val);
                        }
                    }
                    catch (CMyException e) {
                        throw new WCMException(10, I18NMessage.get(XMLContentRender.class, "XMLContentRender.label2", "\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u503c\u548c\u683c\u5f0f\u65e0\u6548\uff08CMyDateTime.setDateTimeWithString\uff09"), e);
                    }
                    _oDocData.setProperty(sKey, oCMyDateTime);
                } else if (nType == 4) {
                    if (CMyString.isEmpty(val)) {
                        _oDocData.setProperty(sKey, "");
                    } else {
                        _oDocData.setProperty(sKey, Integer.parseInt(val));
                    }
                } else if (nType == 8) {
                    if (CMyString.isEmpty(val)) {
                        _oDocData.setProperty(sKey, "");
                    } else {
                        _oDocData.setProperty(sKey, Double.parseDouble(val));
                    }
                } else if (nType == 6) {
                    if (CMyString.isEmpty(val)) {
                        _oDocData.setProperty(sKey, "");
                    } else {
                        _oDocData.setProperty(sKey, Float.parseFloat(val));
                    }
                } else {
                    _oDocData.setProperty(sKey, val);
                }
            } else {
                _oDocData.setProperty(sKey, val);
            }
            if (_xmlDocument == null) {
                return;
            }
            Element parent = _xmlDocument.getParent();
            if (parent != null && parent.attribute(ATTR_PARENT_FLAG) == null) {
                parent.addAttribute(ATTR_PARENT_FLAG, String.valueOf(parent.hashCode()));
            }
            String sComplexFieldFlag = _xmlDocument.attributeValue(ATTR_COMPLEX_FIELD);
            if (parent != null) {
                sComplexFieldFlag = CMyString.showNull(parent.attributeValue(ATTR_COMPLEX_FIELD), sComplexFieldFlag);
            }
            boolean bl = bIsComplexField = !CMyString.isEmpty(sComplexFieldFlag) || oLastPropValue != null;
            if (bIsComplexField && (data = InfoViewHelper.makeComplexFieldData(sFiledId = sKey, sFieldName = CMyString.isEmpty(sFieldName = _xmlDocument.getName()) ? key : sFieldName, sFieldValue = CMyString.showNull(val), sParentFlag = parent != null ? parent.attributeValue(ATTR_PARENT_FLAG) : "", _oDocData)) != null) {
                data.setCrUser(_oDocData.getPropertyAsString("CrUser", ContextHelper.getLoginUser().getName()));
                this.getComplexFieldDatas().add(data);
            }
        } else if (logger.isDebugEnabled()) {
            logger.warn((Object)(I18NMessage.get(XMLContentRender.class, "XMLContentRender.label3", "InfoPath\u540d\u79f0[") + key + I18NMessage.get(XMLContentRender.class, "XMLContentRender.label4", "]\u5bf9\u5e94\u7684\u5b57\u6bb5[") + sKey + I18NMessage.get(XMLContentRender.class, "XMLContentRender.label5", "]\u5728\u6570\u636e\u5e93\u8868[") + sTrueTableName + I18NMessage.get(XMLContentRender.class, "XMLContentRender.label6", "]\u4e2d\u4e0d\u5b58\u5728\u3002")));
        }
    }

    private String[] getNSPrefix(Element elRoot, String[] saNSURI) {
        if (saNSURI == null) {
            return null;
        }
        List list = elRoot.declaredNamespaces();
        if (list == null) {
            return null;
        }
        ArrayList<String> alPrefix = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            for (int j = 0; j < saNSURI.length; ++j) {
                if (!namespace.getURI().equals(saNSURI[j])) continue;
                alPrefix.add(namespace.getPrefix());
            }
        }
        if (alPrefix.size() <= 0) {
            return null;
        }
        String[] saPrefix = new String[alPrefix.size()];
        alPrefix.toArray(saPrefix);
        return saPrefix;
    }

    private void addElementField(InfoViewData _oDocData, Element xmlElement, String[] saNSPrefix) throws WCMException {
        if (!this.acceptNamespace(xmlElement, saNSPrefix)) {
            return;
        }
        if (this.acceptElement(xmlElement, saNSPrefix)) {
            this.newElementField(_oDocData, xmlElement);
        }
        Iterator itr = xmlElement.attributeIterator();
        while (itr.hasNext()) {
            this.addAttributeField(_oDocData, (Attribute)itr.next(), saNSPrefix);
        }
        itr = xmlElement.elementIterator();
        while (itr.hasNext()) {
            this.addElementField(_oDocData, (Element)itr.next(), saNSPrefix);
        }
    }

    private final void newElementField(InfoViewData _oDocData, Element xmlElement) throws WCMException {
        String val = xmlElement.getText();
        String key = xmlElement.getPath();
        this.setProperty(_oDocData, key, val, xmlElement);
    }

    private boolean acceptElement(Element node, String[] saNSPrefix) {
        if (node.hasMixedContent()) {
            Iterator itr = node.elementIterator();
            while (itr.hasNext()) {
                if (!this.acceptNamespace((Element)itr.next(), saNSPrefix)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean acceptNamespace(Element node, String[] saNSPrefix) {
        if (saNSPrefix == null) {
            return true;
        }
        String sPrefix = node.getNamespacePrefix();
        if (sPrefix == null || sPrefix.length() <= 0) {
            return false;
        }
        for (int i = saNSPrefix.length - 1; i >= 0; --i) {
            if (!sPrefix.equals(saNSPrefix[i])) continue;
            return true;
        }
        return false;
    }

    private boolean acceptNamespace(Attribute node, String[] saNSPrefix) {
        if (saNSPrefix == null) {
            return true;
        }
        String sPrefix = node.getNamespacePrefix();
        if (sPrefix == null || sPrefix.length() <= 0) {
            return true;
        }
        for (int i = saNSPrefix.length - 1; i >= 0; --i) {
            if (!sPrefix.equals(saNSPrefix[i])) continue;
            return true;
        }
        return false;
    }

    private void addAttributeField(InfoViewData _oDocData, Attribute xmlAttribute, String[] saNSPrefix) throws WCMException {
        if (this.acceptNamespace(xmlAttribute, saNSPrefix)) {
            this.newAttributeField(_oDocData, xmlAttribute);
        }
    }

    private final void newAttributeField(InfoViewData _oDocData, Attribute xmlAttribute) throws WCMException {
        String val = xmlAttribute.getValue();
        String sAttrName = xmlAttribute.getName();
        if (this.isSystemAutoAppendAttr(sAttrName)) {
            return;
        }
        String key = xmlAttribute.getPath();
        this.setProperty(_oDocData, key, val);
    }

    private boolean isSystemAutoAppendAttr(String sAttrName) {
        return sAttrName == null || sAttrName.toLowerCase().startsWith("trs") || ATTR_COMPLEX_FIELD.equalsIgnoreCase(sAttrName);
    }

    public List getComplexFieldDatas() {
        if (this.m_oComplexFieldDatas == null) {
            this.m_oComplexFieldDatas = new ArrayList(5);
        }
        return this.m_oComplexFieldDatas;
    }
}

