/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.element;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishElementType;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.infra.common.WCMException;
import java.util.StringTokenizer;

public class PublishElementFactory {
    public static boolean isFolderType(int _nType) throws WCMException {
        PublishElementType type = PublishServerConfigMapper.getElementType(_nType);
        return type != null && type.isFolder();
    }

    public static boolean isContentType(int _nType) throws WCMException {
        PublishElementType type = PublishServerConfigMapper.getElementType(_nType);
        return type != null && !type.isFolder();
    }

    public static IPublishElement createElementOfType(int _nType) throws WCMException {
        PublishElementType type = PublishServerConfigMapper.getElementType(_nType);
        if (type == null) {
            throw new WCMException(226, "unknown publish element type: " + _nType);
        }
        return type.createBean();
    }

    public static IPublishElement lookupElement(int _nType, int _nId) throws WCMException {
        IPublishElement element = PublishElementFactory.createElementOfType(_nType);
        if (element.loadById(_nId)) {
            return element;
        }
        return null;
    }

    public static IPublishContent lookupContent(int _nType, int _iID, IPublishFolder _oFolder) throws WCMException {
        IPublishContent content = (IPublishContent)PublishElementFactory.createElementOfType(_nType);
        if (content.loadById(_iID)) {
            if (_oFolder != null) {
                content.setFolder(_oFolder);
            } else {
                content.setFolder(content.getOriginalHome());
            }
            return content;
        }
        return null;
    }

    public static IPublishElements lookupElements(int _nType, String _sIds) throws WCMException {
        PublishElementsListImpl list = new PublishElementsListImpl();
        try {
            StringTokenizer stIds = new StringTokenizer(_sIds, ",");
            while (stIds.hasMoreElements()) {
                String sValue = stIds.nextToken();
                int nId = Integer.parseInt(sValue);
                IPublishElement element = PublishElementFactory.lookupElement(_nType, nId);
                if (element == null) continue;
                if (element instanceof IPublishContent) {
                    IPublishContent publishContent = (IPublishContent)element;
                    publishContent.setFolder(publishContent.getOriginalHome());
                    list.add(publishContent);
                    continue;
                }
                list.add(element);
            }
            return list;
        }
        catch (Exception ex) {
            if (!list.isEmpty()) {
                list.clear();
            }
            throw new WCMException(1100, "Failed to lookup and fetch the contents: Type=" + _nType + ", Ids=" + _sIds, ex);
        }
    }

    public static IPublishElement makeElementFrom(CMSObj _cmsObj) throws WCMException {
        if (_cmsObj == null) {
            throw new WCMException(10, "Valid CMS object required!");
        }
        try {
            IPublishElement element = PublishElementFactory.createElementOfType(_cmsObj.getWCMType());
            element.makeFrom(_cmsObj);
            return element;
        }
        catch (Exception ex) {
            throw new WCMException(2, "Failed to make publish element from CMS object!", ex);
        }
    }

    public static IPublishContent makeContentFrom(CMSObj _cmsObj, IPublishFolder _oFolder) throws WCMException {
        if (_cmsObj == null) {
            throw new WCMException(10, "Valid CMS object required!");
        }
        try {
            IPublishContent content = (IPublishContent)PublishElementFactory.createElementOfType(_cmsObj.getWCMType());
            content.makeFrom(_cmsObj);
            if (_oFolder != null) {
                content.setFolder(_oFolder);
            } else {
                content.setFolder(content.getOriginalHome());
            }
            return content;
        }
        catch (Exception ex) {
            throw new WCMException(2, "Failed to make publish element from CMS object!", ex);
        }
    }

    public static IPublishElements makeElementsFrom(CMSBaseObjs _cmsObjs) {
        if (_cmsObjs == null) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(_cmsObjs);
    }
}

