/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.html.HtmlUtil;
import org.apache.log4j.Logger;

public abstract class TagParserCMSObjBase
implements ITagParser {
    private static Logger logger = Logger.getLogger(TagParserCMSObjBase.class);
    protected TagItem m_tagItem;
    protected CMSObj m_host = null;
    private static NamesRegister m_hostSpecialPropertiesRegister = new NamesRegister();

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_host != null) {
            this.m_host = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        return this.parse(_context, _context.getAttribute("FIELD"));
    }

    public String[] parse(PublishTagContext _context, String _sFieldName) throws WCMException {
        this.m_host = this.findHost(_context);
        if (this.m_host == null) {
            return this.filterDefaultValue(_context, null);
        }
        try {
            String sFieldName = _sFieldName;
            if (CMyString.isEmpty(sFieldName)) {
                sFieldName = _context.getAttribute("FIELD");
            }
            if (sFieldName == null || (sFieldName = sFieldName.trim()).length() == 0) {
                sFieldName = this.getDefaultField();
            }
            if (sFieldName == null || (sFieldName = sFieldName.trim()).length() == 0) {
                return new String[]{String.valueOf(this.m_host.getId())};
            }
            int nSpecialProperty = this.lookupHostSpecialPropertyId(sFieldName = sFieldName.toUpperCase());
            if (nSpecialProperty > 0) {
                return this.filterDefaultValue(_context, this.parseHostSpecialProperty(nSpecialProperty, _context));
            }
            if (sFieldName.equalsIgnoreCase("_RECURL")) {
                String sUrl = this.getAutoLinkUrl(_context);
                if (!this.isLinkElement() && !_context.getAttribute("UrlIsAbs", false)) {
                    sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
                }
                return new String[]{sUrl};
            }
            return this.filterDefaultValue(_context, this.parseHostNormalProperty(sFieldName, _context));
        }
        catch (Exception ex) {
            throw new WCMException(234, I18NMessage.get(TagParserCMSObjBase.class, "TagParserCMSObjBase.label1", "\u89e3\u6790\u7ec6\u89c8\u7f6e\u6807\u5931\u8d25\uff01\u7f6e\u6807\u5185\u5bb9\u4e3a: ") + this.m_tagItem.toString(), ex);
        }
    }

    private String[] filterDefaultValue(PublishTagContext _context, String[] aValue) {
        String sDefaultValue = _context.getAttribute("DefaultValue");
        if (aValue == null || aValue.length <= 0) {
            return new String[]{sDefaultValue};
        }
        for (int i = 0; i < aValue.length; ++i) {
            aValue[i] = CMyString.showEmpty(aValue[i], sDefaultValue);
        }
        return aValue;
    }

    protected String getDefaultField() {
        return null;
    }

    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        IPublishElement content = _context.getUpperHost();
        if (content == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return content.getSubstance();
    }

    protected String[] parseHostNormalProperty(String _sName, PublishTagContext _context) throws WCMException {
        Object oValue = _sName.charAt(0) == '#' ? this.m_host.getAttributeValue(_sName.substring(1)) : this.m_host.getProperty(_sName);
        if (oValue == null) {
            return null;
        }
        return this.parseProperty(oValue, _context);
    }

    protected String[] parseProperty(Object oValue, PublishTagContext _context) throws WCMException {
        int nMaxLength;
        String sFullValue;
        if (oValue == null) {
            return null;
        }
        if (oValue instanceof CMyDateTime) {
            CMyDateTime dt = (CMyDateTime)oValue;
            boolean isInMillis = _context.getAttribute("InMillis", false);
            if (isInMillis) {
                sFullValue = String.valueOf(dt.getTimeInMillis());
            } else {
                String sLocaleId = _context.getAttribute("LOCALE");
                String sTimeZoneId = _context.getAttribute("TIMEZONE");
                String sFormat = this.getDateFormat(_context);
                sFullValue = dt.toString(sFormat, sLocaleId, sTimeZoneId);
            }
        } else {
            sFullValue = oValue instanceof String ? (String)oValue : oValue.toString();
        }
        if (sFullValue == null) {
            return null;
        }
        String sResult = null;
        sResult = TagParseHelper.truncateTextIfNeeded(_context, sFullValue);
        sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
        sResult = TagParseHelper.addSpanStyleIfNeeded(_context, sResult);
        if (this.mayAutoLink(_context)) {
            sResult = this.addAutoLink(sResult, sFullValue, _context);
        } else if (oValue instanceof CDBText && (nMaxLength = _context.getAttribute("NUM", 0)) == 0) {
            if (_context.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(sResult);
            }
            return new String[]{sResult};
        }
        if (_context.getAttribute("ISHTMLCONTENT", false)) {
            return TagParseHelper.parseHtmlContent(sResult, (IPublishContent)_context.getUpperHost(), _context);
        }
        return new String[]{sResult};
    }

    protected boolean mayAutoLink(PublishTagContext _context) {
        return _context.getAttribute("AUTOLINK", false);
    }

    protected String addAutoLink(String _sValue, String _sDefaultAltText, PublishTagContext _context) throws WCMException {
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = _context.getAttribute("EXTRA");
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        if (_context.getAttribute("LINKALT") == null) {
            String sShowLinkTitle = ConfigServer.getServer().getSysConfigValue("SHOW_LINK_TITLE", "false");
            if (sShowLinkTitle.equalsIgnoreCase("true")) {
                sAltText = _sDefaultAltText;
            }
        } else if (_context.getAttribute("LINKALT", false) && ((sAltText = _context.getAttribute("LINKALTTEXT")) == null || (sAltText = sAltText.trim()).length() == 0)) {
            sAltText = _sDefaultAltText;
        }
        String sUrl = this.getAutoLinkUrl(_context);
        if (!this.isLinkElement() && !_context.getAttribute("UrlIsAbs", false)) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        return HtmlUtil.renderLink(sUrl, sTarget, sAltText, sExtra, _sValue, sLinkText);
    }

    private boolean isLinkElement() {
        if (this.m_host == null) {
            return true;
        }
        try {
            IPublishElement element = PublishElementFactory.makeElementFrom(this.m_host);
            return element.isLink();
        }
        catch (Exception e) {
            logger.error((Object)("The [" + this.m_host + "] is not IPublishElement\uff01"), (Throwable)e);
            return true;
        }
    }

    protected abstract String getAutoLinkUrl(PublishTagContext var1) throws WCMException;

    protected String getDateFormat(PublishTagContext _context) {
        String sDateFormat = _context.getAttribute("DATEFORMAT");
        if (sDateFormat == null || (sDateFormat = sDateFormat.trim()).length() == 0) {
            sDateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        return TagParseHelper.parseDateFormat(sDateFormat);
    }

    protected void registerHostSpecialProperty(String _sName, int _nId) {
        String key = this.m_tagItem.getName() + '.' + _sName;
        m_hostSpecialPropertiesRegister.register(key, _nId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialPropertyId(String _sName) {
        String sPrefix = this.m_tagItem.getName() + '.';
        if (!m_hostSpecialPropertiesRegister.contains(sPrefix)) {
            NamesRegister namesRegister = m_hostSpecialPropertiesRegister;
            synchronized (namesRegister) {
                if (!m_hostSpecialPropertiesRegister.contains(sPrefix)) {
                    this.registerHostSpecialProperties();
                    m_hostSpecialPropertiesRegister.register(sPrefix, 0);
                }
            }
        }
        return m_hostSpecialPropertiesRegister.lookup(sPrefix + _sName, -1);
    }

    protected abstract void registerHostSpecialProperties();

    protected abstract String[] parseHostSpecialProperty(int var1, PublishTagContext var2) throws WCMException;
}

