/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.IFilterForFlowContent;
import com.trs.cms.process.IFlowContent;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DefaultFilterForFlowContent
implements IFilterForFlowContent {
    private int searchField = -1;
    private String[] doFilterFields = new String[]{"chnlName", "title", "userName", "chnlids", "crtime"};

    @Override
    public boolean needFilter(String _searchFiled) {
        for (int i = 0; i < this.doFilterFields.length; ++i) {
            if (!this.doFilterFields[i].equalsIgnoreCase(_searchFiled)) continue;
            this.searchField = i;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doFilter(String value, IFlowContent content) throws WCMException {
        if (CMyString.isEmpty(value)) {
            return false;
        }
        try {
            if (!(content.getSubinstance() instanceof Document)) {
                return false;
            }
            Document doc = (Document)content.getSubinstance();
            switch (this.searchField) {
                case 0: {
                    if (doc.getChannelName().indexOf(value) >= 0) return true;
                    return false;
                }
                case 1: {
                    if (doc.getTitle().indexOf(value) >= 0) return true;
                    return false;
                }
                case 2: {
                    if (doc.getCrUser().getTrueName().indexOf(value) >= 0) return true;
                    return false;
                }
                case 3: {
                    String[] channels = value.split(",");
                    int j = 0;
                    while (j < channels.length) {
                        if (channels[j].equalsIgnoreCase(doc.getChannelId() + "")) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                case 4: {
                    String[] values = value.split("=");
                    SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (values.length == 4) {
                        try {
                            long start = dd.parse(values[1]).getTime();
                            long end = dd.parse(values[3]).getTime();
                            long crtime = doc.getCrTime().getTimeInMillis();
                            if (start > end) {
                                long temp = start;
                                start = end;
                                end = temp;
                            }
                            if (crtime < start) return false;
                            if (crtime > end) return false;
                            return true;
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                            throw new WCMException("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38");
                        }
                    }
                    if (values.length != 2) return false;
                    if (values[0].equalsIgnoreCase("s")) {
                        try {
                            long start = dd.parse(values[1]).getTime();
                            long crtime = doc.getCrTime().getTimeInMillis();
                            if (crtime < start) return false;
                            return true;
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        return false;
                    } else {
                        if (!values[0].equalsIgnoreCase("e")) return false;
                        try {
                            long end = dd.parse(values[1]).getTime();
                            long crtime = doc.getCrTime().getTimeInMillis();
                            if (crtime > end) return false;
                            return true;
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                            throw new WCMException("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38");
                        }
                    }
                }
            }
            return true;
        }
        catch (WCMException e) {
            e.printStackTrace();
            throw new WCMException("\u8fc7\u6ee4\u5668\u51fa\u73b0\u5f02\u5e38\uff0c\u8f6c\u5316\u5904\u7406\u7684IFlowContent\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38");
        }
    }
}

