/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.DreamFactory;
import com.trs.ajaxservice.TemplateAuthHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WCMFolderPublishConfigToXML
implements IXMLConvertor {
    private String[] m_pSelectFields = null;
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");

    @Override
    public String[] registerTargetClassName() {
        return new String[]{WCMFolderPublishConfig.class.getName()};
    }

    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        Element element;
        if (!(_result instanceof WCMFolderPublishConfig)) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label1", "\u53c2\u6570\u7c7b\u578b[") + _result.getClass() + I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label2", "]\u4e0d\u4e00\u81f4[") + WCMFolderPublishConfig.class + "]\uff01");
        }
        this.m_pSelectFields = this.makeSelectFields(_methodContext);
        WCMFolderPublishConfig publishConfig = (WCMFolderPublishConfig)_result;
        Element rootElement = DocumentHelper.createElement((String)"PublishConfig");
        try {
            if (this.isSelectFields("OutlineTemplate")) {
                rootElement.add(this.makeTemplateTag(_methodContext, publishConfig.getDefaultOutlineTemplateId(), "OutlineTemplate"));
            }
            if (this.isSelectFields("OtherOutlineTemplates")) {
                element = rootElement.addElement("OtherOutlineTemplates");
                Templates templates = this.m_oEmployMgr.getOtherOutlineTemplates(publishConfig.getFolder());
                int nSize = templates.size();
                for (int i = 0; i < nSize; ++i) {
                    Template template = (Template)templates.getAt(i);
                    if (template == null) continue;
                    element.add(this.makeTemplateTag(_methodContext, template, "OtherOutlineTemplate"));
                }
            }
            if (this.isSelectFields("DetailTemplate")) {
                rootElement.add(this.makeTemplateTag(_methodContext, publishConfig.getDetailTemplateId(), "DetailTemplate"));
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label3", "\u6784\u9020\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01"), e);
        }
        try {
            if (this.isSelectFields("DataPath")) {
                rootElement.addElement("DataPath").addCDATA(publishConfig.getDataPath());
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label4", "\u6784\u9020\u5b58\u50a8\u8def\u5f84\u5931\u8d25\uff01"), e);
        }
        try {
            if (this.isSelectFields("URL")) {
                rootElement.addElement("URL").addCDATA(CMyString.showNull(publishConfig.getURL()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.isSelectFields("STATUSESCANDOPUB")) {
                rootElement.addElement("STATUSESCANDOPUB").addCDATA(publishConfig.getStatusesCanDoPub());
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label5", "\u6784\u9020\u5b9e\u9645\u53ef\u9884\u89c8\u5730\u5740\u5931\u8d25\uff01"), e);
        }
        try {
            if (this.isSelectFields("ROOTDOMAIN")) {
                rootElement.addElement("ROOTDOMAIN").addCDATA(publishConfig.getRootDomain());
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label5", "\u6784\u9020\u5b9e\u9645\u53ef\u9884\u89c8\u5730\u5740\u5931\u8d25\uff01"), e);
        }
        try {
            if (this.isSelectFields("PageEncoding") || this.isSelectFields("SiteLanguage")) {
                rootElement.addElement("PageEncoding").addCDATA(publishConfig.getPageEncoding());
                rootElement.addElement("SiteLanguage").addText(String.valueOf(publishConfig.getSiteLanguage()));
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label6", "\u6784\u9020\u9875\u9762\u7f16\u7801\u5931\u8d25\uff01"), e);
        }
        try {
            if (this.isSelectFields("StatusIdAfterModify")) {
                rootElement.addElement("StatusIdAfterModify").addText(String.valueOf(publishConfig.getStatusIdAfterModify()));
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label7", "\u6784\u9020\u7f16\u8f91\u540e\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff01"), e);
        }
        try {
            if (this.isSelectFields("Schedule")) {
                element = rootElement.addElement("Schedule");
                element.addAttribute("ScheduleMode", String.valueOf(publishConfig.getScheduleMode()));
                element.addAttribute("StartTime", publishConfig.getStartTime());
                element.addAttribute("EndTime", publishConfig.getEndTime());
                element.addAttribute("Interval", String.valueOf(publishConfig.getInterval()));
                element.addAttribute("ExecTime", publishConfig.getExecTime());
            }
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label7", "\u6784\u9020\u7f16\u8f91\u540e\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff01"), e);
        }
        return rootElement.asXML();
    }

    private Element makeTemplateTag(MethodContext _methodContext, int _nTemplateId, String _sTagName) throws WCMException, ConvertException {
        Template template = null;
        if (_nTemplateId > 0) {
            template = Template.findById(_nTemplateId);
        }
        return this.makeTemplateTag(_methodContext, template, _sTagName);
    }

    private Element makeTemplateTag(MethodContext _methodContext, Template _template, String _sTagName) throws ConvertException {
        Element element = DocumentHelper.createElement((String)_sTagName);
        if (_template != null) {
            element.addCDATA(_template.getName());
            element.addAttribute("Id", String.valueOf(_template.getId()));
        } else {
            element.addAttribute("Id", "0");
        }
        if (_methodContext.getValue("ContainsRight", false) && _template != null) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                if (loginUser.isAdministrator() || loginUser.getName().equals(_template.getCrUserName())) {
                    rightValue = new RightValue(RightValue.VALUE_ADMINISTRATOR);
                } else {
                    IPublishFolder host = (IPublishFolder)_methodContext.getContextCacheData("Host");
                    rightValue = TemplateAuthHelper.makeTemplateRightValue(_methodContext, loginUser, _template, host);
                }
                element.addAttribute("Right", rightValue.toString());
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label8", "\u6784\u9020[") + _template + I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label9", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        return element;
    }

    private String[] makeSelectFields(MethodContext _methodContext) {
        String[] pSelectFields = null;
        String sSelectFields = _methodContext.getValue("SelectFields");
        if (sSelectFields != null && (sSelectFields = sSelectFields.trim()).length() > 0 && !sSelectFields.equals("*")) {
            pSelectFields = CMyString.split(sSelectFields, ",");
        }
        return pSelectFields;
    }

    private boolean isSelectFields(String _sFieldName) {
        if (this.m_pSelectFields == null) {
            return true;
        }
        for (int i = 0; i < this.m_pSelectFields.length; ++i) {
            if (!this.m_pSelectFields[i].equalsIgnoreCase(_sFieldName)) continue;
            return true;
        }
        return false;
    }
}

