/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.data.bo.User;
import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class RequestContext {
    private String userName;
    private int userId;
    private String clientIP;
    private long clientTime;
    private String proxyIPs;
    private String uri;
    private String uriAfterContextPath;
    private String queryStr;
    private String httpMethod;
    private String userAgent;
    private String ssoSessionId;
    private String clientSessionId;
    private String sysFlag;
    private String callerStackBrief;
    private HttpServletRequest httpRequest;
    private String referURL;
    private String coAppName;

    public String getCoAppName() {
        return this.coAppName;
    }

    protected void setCoAppName(String coAppName) {
        this.coAppName = coAppName;
    }

    protected RequestContext() {
    }

    public boolean isLogined() {
        return this.userName != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestContext [");
        if (this.uri != null) {
            sb.append("uri=").append(this.uri);
            if (this.queryStr != null) {
                sb.append("?").append(this.queryStr);
            }
        }
        if (this.clientIP != null) {
            sb.append(", ").append("clientIP=").append(this.clientIP);
        }
        if (this.userName != null) {
            sb.append(", ").append("loginUserName=").append(this.userName);
        }
        if (this.userAgent != null) {
            sb.append(", ").append("userAgent=").append(this.userAgent);
        }
        if (this.proxyIPs != null) {
            sb.append(", ").append("proxyIPs=").append(this.proxyIPs);
        }
        if (this.referURL != null) {
            sb.append(", ").append("referUrl=").append(this.referURL);
        }
        if (this.uri != null) {
            sb.append(", ").append("uri=").append(this.uri);
        }
        if (this.ssoSessionId != null) {
            sb.append(", ").append("ssoSessionId=").append(this.ssoSessionId);
        }
        if (this.coAppName != null) {
            sb.append(", ").append("coAppName=").append(this.coAppName);
        }
        sb.append("]");
        return sb.toString();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getProxyIPs() {
        return this.proxyIPs;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUriAfterContextPath() {
        return this.uriAfterContextPath;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUriWithQueryString() {
        if (StringHelper.isEmpty(this.queryStr)) {
            return this.uri;
        }
        return String.valueOf(this.uri) + "?" + this.queryStr;
    }

    public String getQueryString() {
        return this.queryStr;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getSysFlag() {
        if (StringHelper.isEmpty(this.sysFlag)) {
            return "";
        }
        return this.sysFlag;
    }

    public String getCallerStackBrief() {
        return this.callerStackBrief;
    }

    @Deprecated
    public static RequestContext getLocalRequestContext() {
        return RequestContext.getLocalRequestContext("TRS.SYSTEM");
    }

    public static RequestContext getLocalRequestContext(String userName) {
        RequestContext requestContext = new RequestContext();
        requestContext.setUserName(userName);
        requestContext.setClientIP("localhost");
        return requestContext;
    }

    public static RequestContext getWebRequestContext(HttpServletRequest request) {
        RequestContext requestContext = new RequestContext();
        return RequestContext.buildRequestContext(requestContext, request);
    }

    public static RequestContext getAPIRequestContext(HttpServletRequest request) {
        RequestContext requestContext = new RequestContext();
        RequestContext.buildRequestContext(requestContext, request);
        String appName = requestContext.getParameter("appName");
        if (!StringHelper.isEmpty(appName)) {
            requestContext.setCoAppName(appName);
        }
        requestContext.setUserName("SYSTEM");
        return requestContext;
    }

    private static RequestContext buildRequestContext(RequestContext requestContext, HttpServletRequest request) {
        requestContext.setClientIP(RequestUtil.getClientIP(request));
        requestContext.setProxyIPs(request.getHeader("X-Forwarded-For"));
        requestContext.uri = request.getRequestURI();
        requestContext.queryStr = request.getQueryString();
        requestContext.uriAfterContextPath = RequestUtil.getRelativePath(request);
        requestContext.httpMethod = request.getMethod();
        requestContext.userAgent = request.getHeader("user-agent");
        requestContext.httpRequest = request;
        User loginUser = (User)request.getAttribute("currentUser");
        if (loginUser != null) {
            requestContext.setUserName(loginUser.getUserName());
        } else {
            requestContext.setUserName((String)request.getAttribute("loginUserName"));
        }
        requestContext.clientSessionId = new CookieHelper(request, null).getValue("JSESSIONID");
        return requestContext;
    }

    public boolean isWebRequest() {
        return this.httpRequest != null;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setProxyIPs(String proxyIPs) {
        this.proxyIPs = proxyIPs;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public void setSysFlag(String sysFlag) {
        this.sysFlag = sysFlag;
    }

    public void setCallerStackBrief(String callerStackBrief) {
        this.callerStackBrief = callerStackBrief;
    }

    public String getServerSessionId() {
        return this.ssoSessionId;
    }

    public String getClientSessionId() {
        return StringHelper.avoidNull(this.clientSessionId);
    }

    public boolean isNewSessionAsFresh() {
        return this.clientSessionId == null;
    }

    public boolean isNewSessionAsOutofDate() {
        return this.clientSessionId != null && !this.clientSessionId.equals(this.ssoSessionId);
    }

    public String getHeader(String headerName) {
        if (this.httpRequest == null) {
            return null;
        }
        return this.httpRequest.getHeader(headerName);
    }

    public String getParameter(String parameterName) {
        if (this.httpRequest == null) {
            return null;
        }
        return this.httpRequest.getParameter(parameterName);
    }

    public Object getAttribute(String attributeName) {
        if (this.httpRequest == null) {
            return null;
        }
        return this.httpRequest.getAttribute(attributeName);
    }

    public String getCookie(String cookieName) {
        if (this.httpRequest == null) {
            return null;
        }
        CookieHelper cookieHelper = new CookieHelper(this.httpRequest, null);
        return cookieHelper.getValue(cookieName);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setQueryStr(String queryStr) {
        this.queryStr = queryStr;
    }

    protected void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setServerSessionId(String serverSessionId) {
        this.ssoSessionId = serverSessionId;
    }

    public void setClientSessionId(String clientSessionId) {
        this.clientSessionId = clientSessionId;
    }

    protected void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    protected void setUriAfterContextPath(String uriAfterContextPath) {
        this.uriAfterContextPath = uriAfterContextPath;
    }

    protected void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getParameterAndTrim(String param, String defaultValue) {
        return RequestUtil.getParameterAndTrim(this.httpRequest, param, defaultValue);
    }

    public int getParameterAsInt(String param, int defaultValue) {
        return RequestUtil.getParameterAsInt(this.httpRequest, param, defaultValue);
    }

    public HttpServletRequest getRequest() {
        return this.httpRequest;
    }

    public MultipartFile getMultipartFile(String fileName) {
        if (this.httpRequest == null) {
            return null;
        }
        if (!(this.httpRequest instanceof MultipartHttpServletRequest)) {
            return null;
        }
        return ((MultipartHttpServletRequest)this.httpRequest).getFile(fileName);
    }

    public User getCurrentUser() {
        if (this.httpRequest == null) {
            return null;
        }
        return (User)this.httpRequest.getAttribute("currentUser");
    }

    public long getClientTime() {
        return this.clientTime;
    }

    public void setClientTime(long clientTime) {
        this.clientTime = clientTime;
    }

    public String getReferURL() {
        if (StringHelper.isEmpty(this.referURL)) {
            return this.uri;
        }
        return this.referURL;
    }

    public void setReferURL(String referURL) {
        this.referURL = referURL;
    }
}

