/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.xml.node;

import com.trs.dev4.jdk16.xml.AbstractNode;
import com.trs.dev4.jdk16.xml.Node;
import com.trs.dev4.jdk16.xml.node.SimpleNode;
import java.util.LinkedList;

public class ContainerNode
extends AbstractNode {
    protected LinkedList<Node> children = new LinkedList();

    public ContainerNode(String nodeName) {
        super(nodeName);
    }

    public void addChildNode(String nodeName, String nodeValue) {
        SimpleNode node = new SimpleNode(nodeName, nodeValue);
        this.addChildNode(node);
    }

    public void addChildNode(String nodeName, String nodeValue, boolean CDATANeeded) {
        SimpleNode node = new SimpleNode(nodeName, nodeValue);
        node.setCDATANeeded(CDATANeeded);
        this.addChildNode(node);
    }

    public void addChildNode(String nodeName, int nodeValue) {
        SimpleNode node = new SimpleNode(nodeName, nodeValue);
        this.addChildNode(node);
    }

    public void addChildNode(Node node) {
        node.setLevel(this.getLevel() + 1);
        this.children.addLast(node);
    }

    public boolean removeChildNode(Node node) {
        return this.children.remove(node);
    }

    @Override
    public void setLevel(int level) {
        super.setLevel(level);
        int i = 0;
        while (i < this.children.size()) {
            this.children.get(i).setLevel(this.getLevel() + 1);
            ++i;
        }
    }

    @Override
    protected boolean hasNodeValue() {
        return !this.children.isEmpty();
    }

    @Override
    protected String getNodeValue() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("\n");
        int i = 0;
        while (i < this.children.size()) {
            Node node = this.children.get(i);
            sb.append(node.toXML());
            sb.append("\n");
            ++i;
        }
        sb.append(this.getFmtWhiteSpace());
        return sb.toString();
    }
}

