/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.log4j.Logger;

public class SessionIdGenerator {
    private static final Logger LOG = Logger.getLogger(SessionIdGenerator.class);
    private int sessionIdLength = 16;
    protected Random random = null;
    protected String entropy = null;
    protected String randomClass = "java.security.SecureRandom";
    protected MessageDigest digest = null;
    protected String algorithm = "MD5";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    private String nodeKey;

    public SessionIdGenerator() {
    }

    public SessionIdGenerator(String nodeKey) {
        if (nodeKey != null && nodeKey.trim().length() > 0) {
            this.nodeKey = nodeKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSessionId() {
        byte[] random = new byte[this.sessionIdLength];
        StringBuffer result = new StringBuffer();
        int resultLenBytes = 0;
        SessionIdGenerator sessionIdGenerator = this;
        synchronized (sessionIdGenerator) {
            while (resultLenBytes < this.sessionIdLength) {
                this.getRandomBytes(random);
                random = this.getDigest().digest(random);
                int j = 0;
                while (j < random.length && resultLenBytes < this.sessionIdLength) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        result.append((char)(48 + b1));
                    } else {
                        result.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        result.append((char)(48 + b2));
                    } else {
                        result.append((char)(65 + (b2 - 10)));
                    }
                    ++resultLenBytes;
                    ++j;
                }
            }
        }
        if (this.nodeKey != null) {
            result.append(this.nodeKey);
        }
        return result.toString();
    }

    protected void getRandomBytes(byte[] bytes) {
        this.getRandom();
        this.getRandom().nextBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Random getRandom() {
        if (this.random == null) {
            SessionIdGenerator sessionIdGenerator = this;
            synchronized (sessionIdGenerator) {
                if (this.random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    int i = 0;
                    while (i < entropy.length) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                        ++i;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("SSOSessionManager.random: " + this.randomClass), (Throwable)e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        LOG.debug((Object)("SSOSessionIdGen.seeding time high! " + this.randomClass + " " + (t2 - t1)));
                    }
                }
            }
        }
        return this.random;
    }

    synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)("SSOSessionManager.digest:     " + this.algorithm + "   " + e));
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    LOG.error((Object)("SSOSessionManager.digest:   MD5   " + e));
                    this.digest = null;
                }
            }
            long t2 = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getDigest(): " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    String getNodeKey() {
        return this.nodeKey;
    }
}

