/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.schedule;

import com.trs.dev4.jdk16.schedule.ISchedulable;
import com.trs.dev4.jdk16.utils.ObjectUtil;
import org.apache.log4j.Logger;

public class ScheduleRunner
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ScheduleRunner.class);
    private ISchedulable schedulable;
    private RunStatus status = RunStatus.IDLE;
    private long failureTimes;
    private long successTimes;
    private long currRunTimestamp;
    private long lastRunTimestamp;
    private long lastRunDuration;
    private long maxDuration;
    private int fixedDelaySeconds;
    private Throwable lastException;
    private long lastErrorTimestamp;

    ScheduleRunner(ISchedulable schedulable, int fixedDelaySeconds) {
        this.schedulable = schedulable;
        this.fixedDelaySeconds = fixedDelaySeconds;
    }

    public String getDisplayName() {
        return this.schedulable.getDisplayName();
    }

    public String getSchedulabeClassName() {
        return this.schedulable.getClass().getName();
    }

    public boolean isRunning() {
        return RunStatus.RUNNING.equals((Object)this.status);
    }

    public long getLastRunDuration() {
        return this.lastRunDuration;
    }

    public long getLastRunTimestamp() {
        return this.lastRunTimestamp;
    }

    public long getNextRunTimestamp() {
        return this.currRunTimestamp + this.lastRunDuration + (long)(this.fixedDelaySeconds * 1000);
    }

    public long getSuccessTimes() {
        return this.successTimes;
    }

    public long getRanTimes() {
        return this.successTimes + this.failureTimes;
    }

    public long getFailureTimes() {
        return this.failureTimes;
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    public void run() {
        this.status = RunStatus.RUNNING;
        this.currRunTimestamp = System.currentTimeMillis();
        try {
            this.schedulable.runOnce();
            ++this.successTimes;
        }
        catch (Throwable t) {
            this.lastErrorTimestamp = System.currentTimeMillis();
            ++this.failureTimes;
            this.lastException = t;
            LOG.error((Object)("error in this turn of " + this.schedulable), t);
        }
        this.lastRunDuration = this.getCurrEstimated();
        this.lastRunTimestamp = this.currRunTimestamp;
        this.status = RunStatus.IDLE;
        if (this.maxDuration < this.lastRunDuration) {
            this.maxDuration = this.lastRunDuration;
        }
    }

    public long getCurrEstimated() {
        return System.currentTimeMillis() - this.currRunTimestamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScheduleRunner)) {
            return false;
        }
        ScheduleRunner another = (ScheduleRunner)obj;
        return ObjectUtil.equals(this.schedulable, another.schedulable);
    }

    public int getDelay() {
        return this.fixedDelaySeconds;
    }

    public ISchedulable getSchedulable() {
        return this.schedulable;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public long getLastErrorTimestamp() {
        return this.lastErrorTimestamp;
    }

    public static enum RunStatus {
        IDLE,
        RUNNING;

    }
}

