/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model;

import com.trs.dev4.jdk16.model.BaseEntity;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="MAS_CONFIG")
@GenericGenerator(name="idStrategy", strategy="native")
public class Configuration
extends BaseEntity
implements Serializable {
    @Column(name="`PREFIX`")
    private String prefix;
    @Column(name="`NAME`")
    private String name;
    @Column(name="`VALUE`")
    private String value = "";
    @Column(name="`CNAME`")
    private String cname;
    @Column(name="`COMMENT`")
    private String comment;
    @Column(name="`NODE`")
    private String node = "%";
    @Column(name="`NEEDSETUP`")
    private boolean needSetup;
    @Column(name="`NEEDENCRYPT`")
    @AccessType(value="com.trs.idm.util.hb.SafeDirectPropertyAccessor")
    private boolean needEncrypt;
    @Column(name="`DEFAULTVALUE`")
    private String defaultValue;
    @Column(name="`FORBIDMODIFY`")
    private boolean forbidModify;
    @Column(name="`TYPE`")
    private String type;
    @Column(name="`OPTIONS`", length=200)
    private String options;

    public Configuration() {
        long now;
        this.createdTime = now = System.currentTimeMillis();
        this.lastModifiedTime = now;
    }

    public void setValueFromObject(Object obj) {
        if (obj != null) {
            this.value = String.valueOf(obj);
        }
    }

    public String getMaskValue() {
        if (this.isNeedEncrypt()) {
            return StringHelper.avoidNull(StringHelper.toSecurityMaskForm(this.value));
        }
        return StringHelper.avoidNull(this.getValue());
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(96);
        buffer.append(this.getClass().getSimpleName()).append("@").append(this.hashCode());
        buffer.append(": ").append(this.prefix).append(".").append(this.name);
        buffer.append("=").append(this.value);
        buffer.append(";id=").append(this.id);
        buffer.append(";createdTime=").append(this.createdTime);
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String notes) {
        this.comment = notes;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String module) {
        this.prefix = module;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String nodeName) {
        this.node = nodeName;
    }

    public String getCname() {
        return StringHelper.avoidNull(this.cname);
    }

    public void setCname(String cname) {
        this.cname = cname;
    }

    public boolean isNeedSetup() {
        return this.needSetup;
    }

    public void setNeedSetup(boolean needSetup) {
        this.needSetup = needSetup;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isForbidModify() {
        return this.forbidModify;
    }

    public void setForbidModify(boolean forbidModify) {
        this.forbidModify = forbidModify;
    }

    public boolean isNeedEncrypt() {
        return this.needEncrypt;
    }

    public void setNeedEncrypt(boolean needEncrypt) {
        this.needEncrypt = needEncrypt;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }
}

