/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.debug.impl;

import com.trs.dev4.jdk16.debug.Debug;
import com.trs.dev4.jdk16.debug.Debuglog;
import com.trs.dev4.jdk16.debug.IDebuglogManager;
import com.trs.dev4.jdk16.utils.DateUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DebuglogAspectHandler {
    @Autowired
    private IDebuglogManager debuglogManager;
    protected static Logger logger = Logger.getLogger(DebuglogAspectHandler.class);

    @Pointcut(value="@annotation(debug)", argNames="debug")
    public void annolog(Debug debug) {
    }

    @Around(value="annolog(debug))", argNames="debug")
    public Object aroundAnnoLog(ProceedingJoinPoint joinPoint, Debug debug) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("aroundAnnoLog(method:" + joinPoint.getSignature() + " is method signature:" + (joinPoint.getSignature() instanceof MethodSignature) + ",args:" + StringHelper.join(joinPoint.getArgs())));
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        long lStartTime = System.currentTimeMillis();
        Throwable error = null;
        Debuglog debuglog = new Debuglog();
        debuglog.setCreatedTime(DateUtil.getCurrentTimeMillis());
        debuglog.setClassName(joinPoint.getTarget().getClass().getName());
        debuglog.setMethodName(method.getName());
        debuglog.setMethodSignature(methodSignature.toLongString());
        debuglog.setParameterNames("");
        debuglog.setArguments(StringHelper.join(joinPoint.getArgs()));
        try {
            Object object = this.execute(joinPoint);
            if (object != null) {
                debuglog.setReturnValue(object.toString());
            }
            debuglog.setResult("SUCCESSED");
            Object object2 = object;
            return object2;
        }
        catch (Throwable tx) {
            logger.error((Object)("LOG error:" + tx.getMessage()), tx);
            error = tx;
            debuglog.setResult("FAILED");
            String errorMessage = error.getMessage();
            if (errorMessage != null && errorMessage.length() > 2000) {
                errorMessage = StringHelper.adjustLength(errorMessage, 1800);
            }
            debuglog.setErrorMessage(errorMessage);
            throw tx;
        }
        finally {
            long lEndTime = System.currentTimeMillis();
            debuglog.setElapsed((int)(lEndTime - lStartTime));
            this.debuglogManager.saveOrUpdate(debuglog);
        }
    }

    private Object execute(ProceedingJoinPoint joinPoint) throws Throwable {
        return joinPoint.proceed(joinPoint.getArgs());
    }
}

