/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.security.dos;

import com.trs.dev4.util.IPUtil;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DosAttackJudger {
    public static final String MODE_INCLUDE = "include";
    public static final String MODE_EXCLUDE = "exclude";
    private static final Logger logger;
    private Map requestMap;
    private Thread processThread;
    private boolean threadDone;
    private long expiryTimeAsLong;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.dev4.security.dos.DosAttackJudger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public DosAttackJudger() {
        if (this.requestMap == null) {
            this.requestMap = new Hashtable();
        }
        if (this.processThread == null) {
            this.processThread = new Thread(new BackGroundProcessor());
            this.processThread.start();
        }
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTimeAsLong = expiryTime;
    }

    public boolean shouldPass(Set pathSet, Set excludeIpSet, String filterMode, String currentPath, String clientIp) {
        if (this.shouldExcludeIp(excludeIpSet, clientIp)) {
            logger.info((Object)("clientIp[" + clientIp + "] should be exclude, so pass"));
            return true;
        }
        if (MODE_EXCLUDE.equals(filterMode)) {
            if (pathSet != null && pathSet.contains(currentPath)) {
                logger.info((Object)("CurrentPath[" + currentPath + "] should pass."));
                return true;
            }
            return false;
        }
        if (pathSet == null || !pathSet.contains(currentPath)) {
            return true;
        }
        logger.info((Object)("CurrentPath[" + currentPath + "] should NOT pass."));
        return false;
    }

    private boolean shouldExcludeIp(Set excludeIpSet, String clientIp) {
        return excludeIpSet != null && IPUtil.containIpAddr(excludeIpSet, clientIp);
    }

    public int getMapSize() {
        if (this.requestMap == null) {
            return 0;
        }
        return this.requestMap.size();
    }

    public boolean shouldDenyBySuspect(int timeUnit, int maxClickPerTimeUnit, String clientIp) {
        logger.debug((Object)"---------------------------------");
        RequestInfo requestInfo = (RequestInfo)this.requestMap.get(clientIp);
        logger.debug((Object)requestInfo);
        if (requestInfo != null) {
            if (requestInfo.shouldReset()) {
                logger.debug((Object)("RequestInfo is too old, about to reset . RequestInfo: " + requestInfo));
                this.requestMap.remove(clientIp);
                return false;
            }
            requestInfo.refresh();
            logger.debug((Object)("RequestInfo.refresh(). RequestInfo: " + requestInfo));
            if (requestInfo.isTooMuch()) {
                logger.warn((Object)("Too much request, this reuqest will be deny. RequestInfo: " + requestInfo));
                return true;
            }
            return false;
        }
        requestInfo = new RequestInfo(timeUnit, maxClickPerTimeUnit, timeUnit * 1 * 1000, clientIp);
        this.requestMap.put(clientIp, requestInfo);
        logger.debug((Object)("Create a new RequestInfo: " + requestInfo));
        return false;
    }

    public String getRequestInfo(String clientIp) {
        RequestInfo requestInfo = (RequestInfo)this.requestMap.get(clientIp);
        return requestInfo == null ? null : requestInfo.toString();
    }

    private void processExpiresRequest() {
        if (this.requestMap == null) {
            return;
        }
        Iterator iter = this.requestMap.entrySet().iterator();
        logger.debug((Object)("process and find expiry one to remove by requestMap[" + this.requestMap + "], requestMap.size()[" + this.requestMap.size() + "]"));
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String clientIp = (String)entry.getKey();
            RequestInfo requestInfo = (RequestInfo)entry.getValue();
            if (requestInfo == null || !requestInfo.shouldExpired()) continue;
            logger.debug((Object)("RequestInfo[" + requestInfo + "] is too old, about to remove it by back ground thread"));
            this.requestMap.remove(clientIp);
        }
    }

    public void stop() {
        this.threadDone = true;
    }

    class BackGroundProcessor
    implements Runnable {
        BackGroundProcessor() {
        }

        public void run() {
            while (!DosAttackJudger.this.threadDone) {
                try {
                    DosAttackJudger.this.processExpiresRequest();
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"interrrupted when sleep in BackGroundProcessor.", (Throwable)e);
                }
            }
        }
    }

    class RequestInfo {
        long firstTime;
        long lastTime;
        int count;
        String client;
        int timeUnitOfThisRequest;
        int maxClickPerTimeUnitOfThisRequest;
        long maxTimeToSaveForEachIpOfThisRequest;

        public RequestInfo(int timeUnit, int maxClickPerTimeUnit, long maxTimeToSaveForEachIp, String clientIp) {
            this.client = clientIp;
            this.firstTime = System.currentTimeMillis();
            this.lastTime = System.currentTimeMillis();
            this.count = 1;
            this.timeUnitOfThisRequest = timeUnit;
            this.maxClickPerTimeUnitOfThisRequest = maxClickPerTimeUnit;
            this.maxTimeToSaveForEachIpOfThisRequest = maxTimeToSaveForEachIp;
        }

        public void reset() {
            this.firstTime = System.currentTimeMillis();
            this.lastTime = System.currentTimeMillis();
            this.count = 1;
        }

        public void refresh() {
            this.lastTime = System.currentTimeMillis();
            ++this.count;
        }

        public boolean isTooMuch() {
            logger.debug((Object)"DosHelper.RequestInfo.isTooMuch()");
            long passedTimes = this.lastTime - this.firstTime;
            logger.debug((Object)("passedTimeMillis: " + passedTimes));
            long timeUnitCounts = passedTimes / (long)(this.timeUnitOfThisRequest * 1000);
            logger.debug((Object)("timeUnitCounts: " + timeUnitCounts));
            if (timeUnitCounts == 0L) {
                timeUnitCounts = 1L;
            }
            int times = (int)((long)this.count / timeUnitCounts);
            logger.debug((Object)("Current : " + times + " per " + this.timeUnitOfThisRequest + " seconds, max times allow: " + this.maxClickPerTimeUnitOfThisRequest));
            boolean isTooMuch = false;
            if (times > this.maxClickPerTimeUnitOfThisRequest) {
                isTooMuch = true;
            }
            logger.debug((Object)("is Too Much: " + isTooMuch));
            return isTooMuch;
        }

        public boolean shouldReset() {
            long currenTime = System.currentTimeMillis();
            long delta = currenTime - this.firstTime;
            logger.debug((Object)"DosHelper.RequestInfo.shouldReset()");
            logger.debug((Object)("currenTime: " + currenTime + ", firstTime: " + this.firstTime + ", delta: " + delta + "; shouldReset: " + (delta > this.maxTimeToSaveForEachIpOfThisRequest)));
            return delta > this.maxTimeToSaveForEachIpOfThisRequest;
        }

        private boolean shouldExpired() {
            long currenTime = System.currentTimeMillis();
            long delta = currenTime - this.firstTime;
            if (DosAttackJudger.this.expiryTimeAsLong <= 0L) {
                logger.debug((Object)("get expiryTimeAsLong[" + DosAttackJudger.this.expiryTimeAsLong + "] is not configured, so use maxTimeToSaveForEachIpOfThisRequest[" + this.maxTimeToSaveForEachIpOfThisRequest + "] instead!"));
                DosAttackJudger.this.expiryTimeAsLong = this.maxTimeToSaveForEachIpOfThisRequest;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DosHelper.RequestInfo.shouldExpired()");
                logger.debug((Object)("currenTime: " + currenTime + ", firstTime: " + this.firstTime + ", expiryTimeAsLong: " + DosAttackJudger.this.expiryTimeAsLong + ", delta: " + delta + "; shouldExpired: " + (delta > DosAttackJudger.this.expiryTimeAsLong)));
            }
            return delta > DosAttackJudger.this.expiryTimeAsLong;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "[" + this.client + ", " + this.count + " times, TTL(" + this.lastTime + " - " + this.firstTime + "): " + (this.lastTime - this.firstTime) + " milli seconds,";
        }
    }
}

