/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.util;

import com.trs.dev4.util.StringHelperInDev4CompJDK14;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class IPUtil {
    public static final String IP_SEGMENT_SPLITTER = "-";
    private static final String REG_IP_V4 = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
    private static final String REG_IP_V4_SEG = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\-((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";

    public static boolean isValidV4IP(String ip) {
        if (ip == null) {
            return false;
        }
        if ((ip = ip.trim()).length() == 0) {
            return false;
        }
        String[] part_IP = ip.split("\\.");
        if (part_IP.length != 4) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            try {
                int int_IP = Integer.parseInt(part_IP[i]);
                if (int_IP < 0 || int_IP > 255) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidV4IPOrSegment(String ip) {
        if (StringHelperInDev4CompJDK14.isEmpty(ip)) {
            return false;
        }
        return ip.matches(REG_IP_V4_SEG) || ip.matches(REG_IP_V4);
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        String remoteAddr = request.getRemoteAddr();
        if (xForwardedFor != null && xForwardedFor.length() > 4) {
            int index = xForwardedFor.indexOf(",");
            remoteAddr = index != -1 ? xForwardedFor.substring(0, index) : xForwardedFor;
        }
        return remoteAddr;
    }

    public static boolean isIpOrSegmentContainsIpAddr(String ipOrIpSegment, String ipAddress) {
        if (ipOrIpSegment == null) {
            return false;
        }
        if (ipAddress == null) {
            return false;
        }
        if (-1 == ipOrIpSegment.indexOf(IP_SEGMENT_SPLITTER) && ipOrIpSegment.equals(ipAddress)) {
            return true;
        }
        if (-1 != ipOrIpSegment.indexOf(IP_SEGMENT_SPLITTER)) {
            return IPUtil.isIpInSegment(ipOrIpSegment, ipAddress);
        }
        return false;
    }

    public static boolean containIpAddr(Set ipSet, String ipAddress) {
        if (ipSet == null || ipSet.size() == 0) {
            return false;
        }
        Object[] ipArray = ipSet.toArray();
        int i = 0;
        while (i < ipArray.length) {
            String ipOrSegment = (String)ipArray[i];
            if (IPUtil.isIpOrSegmentContainsIpAddr(ipOrSegment, ipAddress)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsOrCross(String ipSegment1, String ipSegment2) {
        if (StringHelperInDev4CompJDK14.isEmpty(ipSegment1) || StringHelperInDev4CompJDK14.isEmpty(ipSegment2)) {
            return false;
        }
        if (!ipSegment1.matches(REG_IP_V4_SEG) || !ipSegment2.matches(REG_IP_V4_SEG)) {
            return false;
        }
        String[] segmentArray1 = StringHelperInDev4CompJDK14.split(ipSegment1, IP_SEGMENT_SPLITTER);
        if (segmentArray1 == null || segmentArray1.length != 2) {
            return false;
        }
        String prefixThreeLetterStr1 = segmentArray1[0].substring(0, segmentArray1[0].lastIndexOf("."));
        String tailThreeLetterStr1 = segmentArray1[1].substring(0, segmentArray1[1].lastIndexOf("."));
        String[] segmentArray2 = StringHelperInDev4CompJDK14.split(ipSegment2, IP_SEGMENT_SPLITTER);
        if (segmentArray2 == null || segmentArray2.length != 2) {
            return false;
        }
        String prefixThreeLetterStr2 = segmentArray2[0].substring(0, segmentArray2[0].lastIndexOf("."));
        String tailThreeLetterStr2 = segmentArray2[1].substring(0, segmentArray2[1].lastIndexOf("."));
        if (!(prefixThreeLetterStr1.equals(prefixThreeLetterStr2) || prefixThreeLetterStr1.equals(tailThreeLetterStr2) || tailThreeLetterStr1.equals(prefixThreeLetterStr2) || tailThreeLetterStr1.equals(tailThreeLetterStr2))) {
            return false;
        }
        String lastMinLetterOfStr1 = segmentArray1[0].substring(segmentArray1[0].lastIndexOf(".") + 1);
        String lastMaxLetterOfStr1 = segmentArray1[1].substring(segmentArray1[1].lastIndexOf(".") + 1);
        String lastMinLetterOfStr2 = segmentArray2[0].substring(segmentArray2[0].lastIndexOf(".") + 1);
        String lastMaxLetterOfStr2 = segmentArray2[1].substring(segmentArray2[1].lastIndexOf(".") + 1);
        return Integer.parseInt(lastMaxLetterOfStr1) >= Integer.parseInt(lastMinLetterOfStr2) && Integer.parseInt(lastMaxLetterOfStr2) >= Integer.parseInt(lastMinLetterOfStr1);
    }

    public static boolean isIpInSegment(String ipSegment, String ipAddr) {
        if (ipSegment == null) {
            return false;
        }
        if (ipAddr == null) {
            return false;
        }
        ipSegment = ipSegment.trim();
        ipAddr = ipAddr.trim();
        if (!ipSegment.matches(REG_IP_V4_SEG) || !ipAddr.matches(REG_IP_V4)) {
            return false;
        }
        int splitterIndex = ipSegment.indexOf(45);
        String[] ipSegBeforeArray = ipSegment.substring(0, splitterIndex).split("\\.");
        String[] ipSegEndArray = ipSegment.substring(splitterIndex + 1).split("\\.");
        String[] ipAddrArray = ipAddr.split("\\.");
        long ipSegBeforeLongValue = 0L;
        long ipSegEndLongValue = 0L;
        long ipAddrLongValue = 0L;
        int i = 0;
        while (i < 4) {
            ipSegBeforeLongValue = ipSegBeforeLongValue << 8 | (long)Integer.parseInt(ipSegBeforeArray[i]);
            ipSegEndLongValue = ipSegEndLongValue << 8 | (long)Integer.parseInt(ipSegEndArray[i]);
            ipAddrLongValue = ipAddrLongValue << 8 | (long)Integer.parseInt(ipAddrArray[i]);
            ++i;
        }
        if (ipSegBeforeLongValue > ipSegEndLongValue) {
            long t = ipSegBeforeLongValue;
            ipSegBeforeLongValue = ipSegEndLongValue;
            ipSegEndLongValue = t;
        }
        return ipSegBeforeLongValue <= ipAddrLongValue && ipAddrLongValue <= ipSegEndLongValue;
    }
}

