/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.security.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransformUtil {
    private static final Pattern pat1ScriptTag = Pattern.compile("<%?.*script\\s*[^>]*>.*</script>", 42);
    private static final Pattern pat2ScriptTag = Pattern.compile("<%?.*script\\s*[^>]*/>", 42);
    private static final Pattern pat3ScriptTag = Pattern.compile("<%?.*script\\s*[^>]*>", 42);
    private static final Pattern pat4ScriptTag = Pattern.compile("<img.+>|\"\\);.+|='.+|\\'%.+|\"%.+|=\".+|\\'\\+.+|\\';.+|\"\\+.+|<STYLE>.+|\";.+", 42);
    private static final Pattern pat1IframeTag = Pattern.compile("<iframe\\s*[^>]*>.*</iframe>", 42);
    private static final Pattern pat2IframeTag = Pattern.compile("<iframe\\s*[^>]*/>", 42);
    private static final Pattern pat3IframeTag = Pattern.compile("<iframe\\s*[^>]*>*", 42);
    private static final Pattern patJSProtocol = Pattern.compile("=(\\s)*(\\'|\\\")?(\\s)*javascript:", 10);
    private static final Pattern patEventCode = Pattern.compile("(\\s)on([a-zA-Z]+)\\s*=", 10);

    public static String transform(String content) {
        if (content == null) {
            return "";
        }
        content = content.replaceAll("%0a", "CR");
        content = content.replaceAll("%0A", "CR");
        content = content.replaceAll("%0d", "LF");
        content = content.replaceAll("%0D", "LF");
        return TransformUtil.getSafeHtml(content);
    }

    private static String getSafeHtml(String text) {
        if (text == null || text.trim().length() == 0) {
            return text;
        }
        text = TransformUtil.removeScriptTag(text);
        text = TransformUtil.removeIframeTag(text);
        text = TransformUtil.replaceEventCode(text);
        text = TransformUtil.replaceJS(text);
        return text;
    }

    static String removeScriptTag(String text) {
        String replacementStr = "";
        Matcher matcher = pat1ScriptTag.matcher(text);
        String result = matcher.replaceAll(replacementStr);
        matcher = pat2ScriptTag.matcher(result);
        result = matcher.replaceAll(replacementStr);
        matcher = pat3ScriptTag.matcher(result);
        result = matcher.replaceAll(replacementStr);
        matcher = pat4ScriptTag.matcher(result);
        result = matcher.replaceAll(replacementStr);
        return result;
    }

    static String removeIframeTag(String text) {
        String replacementStr = "";
        Matcher matcher = pat1IframeTag.matcher(text);
        text = matcher.replaceAll(replacementStr);
        matcher = pat2IframeTag.matcher(text);
        text = matcher.replaceAll(replacementStr);
        matcher = pat3IframeTag.matcher(text);
        return matcher.replaceAll(replacementStr);
    }

    static String replaceEventCode(String text) {
        String replacementStr = "$1on-$2=";
        Matcher matcher = patEventCode.matcher(text);
        return matcher.replaceAll(replacementStr);
    }

    static String replaceJS(String text) {
        String replacementStr = "=$2java-script:";
        Matcher matcher = patJSProtocol.matcher(text);
        return matcher.replaceAll(replacementStr);
    }

    public static void main(String[] args) {
        System.out.println(TransformUtil.transform("returnUrl=&loginKey=admin&password=trsadmin&2FAVerifyCode=&sourceName=ids_internal\");alert(\"aaaa"));
    }
}

