/*
 * Decompiled with CFR 0.152.
 */
package com.trs.deployer.domain.impl;

import com.trs.deployer.domain.DeployerStatus;
import com.trs.deployer.domain.IDeployerStatusRecorder;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DeployerStatusRecorder
implements IDeployerStatusRecorder {
    private static Logger logger = Logger.getLogger(DeployerStatusRecorder.class);
    private String m_sStatusFilePath = "";
    private HashMap statusObjMap = null;

    public DeployerStatus getDeployerStatus(String string) {
        if (CMyString.isEmpty((String)string)) {
            return null;
        }
        if (this.statusObjMap == null) {
            this.loadStatusObjs();
        }
        return (DeployerStatus)this.statusObjMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeployerStatus(DeployerStatus deployerStatus) {
        if (this.statusObjMap == null) {
            this.loadStatusObjs();
        }
        String string = deployerStatus.getClassName();
        this.statusObjMap.put(string, deployerStatus);
        this.checkStatusFileExist();
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.m_sStatusFilePath);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.statusObjMap);
        }
        catch (IOException iOException) {
            logger.error((Object)("\u7ed9\u6587\u4ef6 \u3010" + this.m_sStatusFilePath + "\u3011 \u5199\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStatusObjs() {
        this.statusObjMap = new HashMap();
        this.checkStatusFileExist();
        File file = new File(this.m_sStatusFilePath);
        if (!file.exists() || file.length() == 0L) {
            return;
        }
        ObjectInputStream objectInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(fileInputStream);
            this.statusObjMap = (HashMap)objectInputStream.readObject();
        }
        catch (Exception exception) {
            logger.error((Object)"\u5c06\u6587\u4ef6\u5185\u5bb9\u8f6c\u5316\u4e3a\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void initStatusFilePath() {
        String string = CMyString.setStrEndWith((String)ConfigServer.getServer().getInitProperty("WCM_PATH"), (char)File.separatorChar);
        this.m_sStatusFilePath = string + "WEB-INF" + File.separator + "classes" + File.separator + "installdeployer" + File.separator + "deployerLogger.txt";
    }

    private void checkStatusFileExist() {
        File file;
        if (CMyString.isEmpty((String)this.m_sStatusFilePath)) {
            this.initStatusFilePath();
        }
        if ((file = new File(this.m_sStatusFilePath)).exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
    }
}

